/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.ic.gates.logic;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.mechanics.ic.AbstractIC;
import com.sk89q.craftbook.mechanics.ic.AbstractICFactory;
import com.sk89q.craftbook.mechanics.ic.ChipState;
import com.sk89q.craftbook.mechanics.ic.IC;
import com.sk89q.craftbook.mechanics.ic.ICFactory;
import org.bukkit.Server;

public class Repeater
extends AbstractIC {
    public Repeater(Server server, ChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public String getTitle() {
        return "Repeater";
    }

    @Override
    public String getSignTitle() {
        return "REPEATER";
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.getOutput(0) != chip.getInput(0)) {
            chip.setOutput(0, chip.getInput(0));
        }
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(ChangedSign sign) {
            return new Repeater(this.getServer(), sign, this);
        }

        @Override
        public String getShortDescription() {
            return "Repeats a redstone signal.";
        }

        @Override
        public String[] getPinDescription(ChipState state) {
            return new String[]{"Trigger IC", "Same as Input"};
        }

        @Override
        public String[] getLongDescription() {
            return new String[]{"The '''MC1000''' repeats a state from input to output terminals.", "", "Equivalent [[../Perlstone/]] script: <code>Ar</code>", "", "== Uses ==", "* Prolonging a redstone circuit over more than 15 fields."};
        }
    }
}

