/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.ic.gates.logic;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.mechanics.ic.AbstractIC;
import com.sk89q.craftbook.mechanics.ic.AbstractICFactory;
import com.sk89q.craftbook.mechanics.ic.ChipState;
import com.sk89q.craftbook.mechanics.ic.IC;
import com.sk89q.craftbook.mechanics.ic.ICFactory;
import com.sk89q.craftbook.util.RegexUtil;
import org.bukkit.Server;

public class DownCounter
extends AbstractIC {
    private int resetVal;
    private boolean inf;

    public DownCounter(Server server, ChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public void load() {
        String line2 = this.getSign().getLine(2);
        String[] config = RegexUtil.COLON_PATTERN.split(line2);
        this.resetVal = 0;
        this.inf = false;
        try {
            this.resetVal = Integer.parseInt(config[0]);
            this.inf = config[1].equals("INF");
        }
        catch (NumberFormatException e) {
            this.resetVal = 5;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.inf = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.getSign().setLine(2, this.resetVal + (this.inf ? ":INF" : ""));
        this.getSign().update(false);
    }

    @Override
    public String getTitle() {
        return "Down Counter";
    }

    @Override
    public String getSignTitle() {
        return "DOWN COUNTER";
    }

    @Override
    public void trigger(ChipState chip) {
        int curVal;
        String line3 = this.getSign().getLine(3);
        try {
            curVal = Integer.parseInt(line3);
        }
        catch (Exception e) {
            curVal = this.resetVal;
        }
        int oldVal = curVal;
        try {
            if (chip.getInput(0)) {
                if (curVal == 0) {
                    if (this.inf) {
                        curVal = this.resetVal;
                    }
                } else {
                    --curVal;
                }
                chip.setOutput(0, curVal == 0);
            } else if (chip.getInput(1)) {
                curVal = this.resetVal;
                chip.setOutput(0, false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (curVal != oldVal) {
            this.getSign().setLine(3, String.valueOf(curVal));
        }
        this.getSign().update(false);
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(ChangedSign sign) {
            return new DownCounter(this.getServer(), sign, this);
        }

        @Override
        public String getShortDescription() {
            return "Outputs high when counter reaches 0.";
        }

        @Override
        public String[] getPinDescription(ChipState state) {
            return new String[]{"Trigger IC", "Reset Counter", "Nothing", "High on Counter Complete"};
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"start ticks:(Optional)INF", "current ticks"};
        }
    }
}

