/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.ic.gates.logic;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.mechanics.ic.AbstractICFactory;
import com.sk89q.craftbook.mechanics.ic.AbstractSelfTriggeredIC;
import com.sk89q.craftbook.mechanics.ic.ChipState;
import com.sk89q.craftbook.mechanics.ic.ConfigurableIC;
import com.sk89q.craftbook.mechanics.ic.IC;
import com.sk89q.craftbook.mechanics.ic.ICFactory;
import com.sk89q.craftbook.mechanics.ic.ICVerificationException;
import com.sk89q.util.yaml.YAMLProcessor;
import org.bukkit.Server;

public class Clock
extends AbstractSelfTriggeredIC {
    short tick;
    short reset;

    public Clock(Server server, ChangedSign psign, ICFactory factory) {
        super(server, psign, factory);
    }

    @Override
    public boolean isAlwaysST() {
        return true;
    }

    @Override
    public String getTitle() {
        return "Clock";
    }

    @Override
    public String getSignTitle() {
        return "CLOCK";
    }

    @Override
    public void trigger(ChipState chip) {
    }

    @Override
    public void think(ChipState chip) {
        if (((Factory)this.getFactory()).inverted == chip.getInput(0)) {
            this.triggerClock(chip);
        }
    }

    protected void triggerClock(ChipState chip) {
        this.tick = (short)(this.tick + 1);
        if (this.tick == this.reset) {
            this.tick = 0;
            chip.setOutput(0, !chip.getOutput(0));
        }
        this.getSign().setLine(3, Short.toString(this.tick));
        this.getSign().update(false);
    }

    @Override
    public void load() {
        try {
            this.reset = Short.parseShort(this.getSign().getLine(2));
        }
        catch (NumberFormatException e) {
            this.reset = (short)5;
            this.getSign().setLine(2, Short.toString(this.reset));
            this.getSign().update(false);
        }
        try {
            this.tick = Short.parseShort(this.getSign().getLine(3));
        }
        catch (NumberFormatException e) {
            this.tick = 0;
            this.getSign().setLine(3, Short.toString(this.tick));
            this.getSign().update(false);
        }
    }

    public static class Factory
    extends AbstractICFactory
    implements ConfigurableIC {
        public boolean inverted = false;

        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(ChangedSign sign) {
            return new Clock(this.getServer(), sign, this);
        }

        @Override
        public void verify(ChangedSign sign) throws ICVerificationException {
            int tick;
            int interval;
            try {
                interval = Integer.parseInt(sign.getLine(2));
            }
            catch (NumberFormatException e) {
                throw new ICVerificationException("The third line must be a number between 5 and 100000.");
            }
            interval = Math.max(Math.min(interval, 100000), 5);
            sign.setLine(2, Integer.toString(interval));
            try {
                tick = Integer.parseInt(sign.getLine(3));
            }
            catch (NumberFormatException e) {
                tick = 0;
            }
            tick = Math.max(tick, 0);
            tick = Math.min(tick, interval);
            sign.setLine(3, Integer.toString(tick));
            sign.update(false);
        }

        @Override
        public String getShortDescription() {
            return "Outputs high every X ticks when input is high.";
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"ticks required", "current ticks"};
        }

        @Override
        public void addConfiguration(YAMLProcessor config, String path) {
            this.inverted = config.getBoolean(path + "inverted", false);
        }
    }
}

