/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.ic.families;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.util.CraftBookBukkitUtil;
import com.sk89q.craftbook.mechanics.ic.AbstractChipState;
import com.sk89q.craftbook.mechanics.ic.AbstractICFamily;
import com.sk89q.craftbook.mechanics.ic.ChipState;
import com.sk89q.craftbook.util.SignUtil;
import com.sk89q.worldedit.util.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;

public class Family3ISO
extends AbstractICFamily {
    @Override
    public ChipState detect(Location source, ChangedSign sign) {
        return new ChipState3ISO(source, sign);
    }

    @Override
    public ChipState detectSelfTriggered(Location source, ChangedSign sign) {
        return new ChipState3ISO(source, sign, true);
    }

    @Override
    public String getName() {
        return "3ISO";
    }

    public static class ChipState3ISO
    extends AbstractChipState {
        public ChipState3ISO(Location source, ChangedSign sign) {
            super(source, sign, false);
        }

        public ChipState3ISO(Location source, ChangedSign sign, boolean selfTriggered) {
            super(source, sign, selfTriggered);
        }

        @Override
        protected Block getBlock(int pin) {
            switch (pin) {
                case 0: {
                    return SignUtil.getFrontBlock(CraftBookBukkitUtil.toSign(this.sign).getBlock());
                }
                case 1: {
                    return SignUtil.getLeftBlock(CraftBookBukkitUtil.toSign(this.sign).getBlock());
                }
                case 2: {
                    return SignUtil.getRightBlock(CraftBookBukkitUtil.toSign(this.sign).getBlock());
                }
                case 3: {
                    BlockFace face = SignUtil.getBack(CraftBookBukkitUtil.toSign(this.sign).getBlock());
                    return CraftBookBukkitUtil.toSign(this.sign).getBlock().getRelative(face).getRelative(face);
                }
            }
            return null;
        }

        @Override
        public boolean getInput(int inputIndex) {
            return this.get(inputIndex);
        }

        @Override
        public boolean getOutput(int outputIndex) {
            return this.get(outputIndex + 3);
        }

        @Override
        public void setOutput(int outputIndex, boolean value) {
            this.set(outputIndex + 3, value);
        }

        @Override
        public int getInputCount() {
            return 3;
        }

        @Override
        public int getOutputCount() {
            return 1;
        }
    }
}

