/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.ic;

import com.sk89q.craftbook.AbstractCraftBookMechanic;
import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.CraftBookPlayer;
import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import com.sk89q.craftbook.bukkit.util.CraftBookBukkitUtil;
import com.sk89q.craftbook.mechanics.ic.ChipState;
import com.sk89q.craftbook.mechanics.ic.IC;
import com.sk89q.craftbook.mechanics.ic.ICFactory;
import com.sk89q.craftbook.mechanics.ic.ICFamily;
import com.sk89q.craftbook.mechanics.ic.ICManager;
import com.sk89q.craftbook.mechanics.ic.ICVerificationException;
import com.sk89q.craftbook.mechanics.ic.PipeInputIC;
import com.sk89q.craftbook.mechanics.ic.RegisteredICFactory;
import com.sk89q.craftbook.mechanics.ic.RestrictedIC;
import com.sk89q.craftbook.mechanics.ic.SelfTriggeredIC;
import com.sk89q.craftbook.mechanics.pipe.PipePutEvent;
import com.sk89q.craftbook.util.EventUtil;
import com.sk89q.craftbook.util.ICUtil;
import com.sk89q.craftbook.util.RegexUtil;
import com.sk89q.craftbook.util.SignUtil;
import com.sk89q.craftbook.util.events.SelfTriggerPingEvent;
import com.sk89q.craftbook.util.events.SelfTriggerThinkEvent;
import com.sk89q.craftbook.util.events.SelfTriggerUnregisterEvent;
import com.sk89q.craftbook.util.events.SignClickEvent;
import com.sk89q.craftbook.util.events.SourcedBlockRedstoneEvent;
import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.plugin.Plugin;

public class ICMechanic
extends AbstractCraftBookMechanic {
    protected final ICManager manager = new ICManager();
    public static ICMechanic instance;
    public boolean cache;
    public boolean shortHand;
    public double maxRange;
    public List<String> disabledICs;
    public boolean keepLoaded;
    public ICUtil.LocationCheckType defaultCoordinates;
    public boolean savePersistentData;
    public boolean usePercussionMidi;
    public boolean breakOnError;
    public boolean disableSelfTriggered;

    public ICMechanic() {
        instance = this;
    }

    @Override
    public boolean enable() {
        ICManager.inst().enable();
        return true;
    }

    @Override
    public void disable() {
        this.manager.disable();
    }

    public Object[] setupIC(Block block, boolean create) {
        IC ic;
        if (!SignUtil.isWallSign(block)) {
            return null;
        }
        ChangedSign sign = CraftBookBukkitUtil.toChangedSign(block);
        Matcher matcher = RegexUtil.IC_PATTERN.matcher(sign.getLine(1));
        if (!matcher.matches()) {
            return null;
        }
        String prefix = matcher.group(2);
        if (prefix.equalsIgnoreCase("MCA")) {
            sign.setLine(1, (StringUtils.replace((String)sign.getLine(1).toLowerCase(Locale.ENGLISH), (String)"mca", (String)"mc") + "a").toUpperCase(Locale.ENGLISH));
            sign.update(false);
            return this.setupIC(block, create);
        }
        if (sign.getLine(1).toLowerCase(Locale.ENGLISH).startsWith("[mc0")) {
            if (sign.getLine(1).equalsIgnoreCase("[mc0420]")) {
                sign.setLine(1, "[MC1421]S");
            } else if (sign.getLine(1).equalsIgnoreCase("[mc0421]")) {
                sign.setLine(1, "[MC1422]S");
            } else {
                sign.setLine(1, (StringUtils.replace((String)sign.getLine(1).toLowerCase(Locale.ENGLISH), (String)"mc0", (String)"mc1") + "s").toUpperCase(Locale.ENGLISH));
            }
            sign.update(false);
            return this.setupIC(block, create);
        }
        if (sign.getLine(1).toLowerCase(Locale.ENGLISH).startsWith("[mcz")) {
            sign.setLine(1, (StringUtils.replace((String)sign.getLine(1).toLowerCase(Locale.ENGLISH), (String)"mcz", (String)"mcx") + "s").toUpperCase(Locale.ENGLISH));
            sign.update(false);
            return this.setupIC(block, create);
        }
        if (!ICManager.hasCustomPrefix(prefix)) {
            return null;
        }
        String id = matcher.group(1);
        if (this.disabledICs.contains(id.toLowerCase()) || this.disabledICs.contains(id)) {
            return null;
        }
        RegisteredICFactory registration = this.manager.get(id);
        if (registration == null) {
            CraftBookPlugin.logger().warning("\"" + sign.getLine(1) + "\" should be an IC ID, but no IC registered under that ID could be found.");
            block.breakNaturally();
            return null;
        }
        if (ICManager.isCachedIC(block.getLocation())) {
            ic = ICManager.getCachedIC(block.getLocation());
            if (ic.getSign().updateSign(sign)) {
                ICManager.removeCachedIC(block.getLocation());
                ic = registration.getFactory().create(sign);
                if (!sign.getLine(0).equals(ic.getSignTitle()) && !sign.getLine(0).startsWith("=")) {
                    sign.setLine(0, ic.getSignTitle());
                    sign.update(false);
                }
                ic.load();
                ICManager.addCachedIC(block.getLocation(), ic);
            }
        } else if (create) {
            ic = registration.getFactory().create(sign);
            if (!sign.getLine(0).equals(ic.getSignTitle()) && !sign.getLine(0).startsWith("=")) {
                sign.setLine(0, ic.getSignTitle());
                sign.update(false);
            }
            ic.load();
            ICManager.addCachedIC(block.getLocation(), ic);
        } else {
            return null;
        }
        String suffix = "";
        String[] str = RegexUtil.RIGHT_BRACKET_PATTERN.split(sign.getLine(1));
        if (str.length > 1) {
            suffix = str[1];
        }
        ICFamily family = registration.getFamilies()[0];
        if (suffix != null && !suffix.isEmpty()) {
            for (ICFamily f : registration.getFamilies()) {
                if (!f.getSuffix().equalsIgnoreCase(suffix)) continue;
                family = f;
                break;
            }
        }
        if (ic instanceof SelfTriggeredIC && (sign.getLine(1).trim().toUpperCase(Locale.ENGLISH).endsWith("S") || ((SelfTriggeredIC)ic).isAlwaysST())) {
            if (this.disableSelfTriggered) {
                return null;
            }
            CraftBookPlugin.inst().getSelfTriggerManager().registerSelfTrigger(block.getLocation());
        }
        Object[] rets = new Object[]{id, family, ic};
        return rets;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockRedstoneChange(SourcedBlockRedstoneEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        Object[] icData = this.setupIC(event.getBlock(), true);
        if (icData == null) {
            return;
        }
        Block block = event.getBlock();
        if (event.getNewCurrent() == event.getOldCurrent()) {
            return;
        }
        if (SignUtil.isWallSign(block)) {
            Block source = event.getSource();
            if (SignUtil.getBackBlock(block).equals(source) || block.equals(source)) {
                return;
            }
            Runnable runnable = () -> {
                block5: {
                    if (!SignUtil.isWallSign(block)) {
                        return;
                    }
                    try {
                        ChipState chipState = ((ICFamily)icData[1]).detect(BukkitAdapter.adapt((Location)source.getLocation()), CraftBookBukkitUtil.toChangedSign(block));
                        int cnt = 0;
                        for (int i = 0; i < chipState.getInputCount(); ++i) {
                            if (!chipState.isTriggered(i)) continue;
                            ++cnt;
                        }
                        if (cnt > 0) {
                            ((IC)icData[2]).trigger(chipState);
                        }
                    }
                    catch (IllegalArgumentException ex) {
                        if (ex.getMessage().contains("Null ChangedSign found")) break block5;
                        throw ex;
                    }
                }
            };
            CraftBookPlugin.server().getScheduler().runTaskLater((Plugin)CraftBookPlugin.inst(), runnable, 2L);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onRightClick(SignClickEvent event) {
        Object[] icData;
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (ICManager.isCachedIC(event.getClickedBlock().getLocation()) && event.getPlayer().isSneaking()) {
            ICManager.getCachedIC(event.getClickedBlock().getLocation()).unload();
            ICManager.removeCachedIC(event.getClickedBlock().getLocation());
        }
        if ((icData = this.setupIC(event.getClickedBlock(), true)) == null) {
            return;
        }
        ((IC)icData[2]).onRightClick(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onThinkPing(SelfTriggerPingEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        this.setupIC(event.getBlock(), true);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onThinkUnregister(SelfTriggerUnregisterEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        Object[] icData = this.setupIC(event.getBlock(), false);
        if (icData != null) {
            if (event.getReason() == SelfTriggerUnregisterEvent.UnregisterReason.ERROR && this.breakOnError) {
                ((IC)icData[2]).unload();
                event.getBlock().breakNaturally();
                return;
            }
            if (this.keepLoaded) {
                event.setCancelled(true);
                return;
            }
            ((IC)icData[2]).unload();
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onThink(SelfTriggerThinkEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        Object[] icData = this.setupIC(event.getBlock(), true);
        if (icData != null && icData[2] instanceof SelfTriggeredIC) {
            event.setHandled(true);
            ChipState chipState = ((ICFamily)icData[1]).detectSelfTriggered(BukkitAdapter.adapt((Location)event.getBlock().getLocation()), ((IC)icData[2]).getSign());
            ((SelfTriggeredIC)icData[2]).think(chipState);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockBreak(BlockBreakEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        Object[] icData = this.setupIC(event.getBlock(), false);
        if (icData == null) {
            return;
        }
        CraftBookPlugin.inst().getSelfTriggerManager().unregisterSelfTrigger(event.getBlock().getLocation(), SelfTriggerUnregisterEvent.UnregisterReason.BREAK);
        ICManager.removeCachedIC(event.getBlock().getLocation());
        ((IC)icData[2]).onICBreak(event);
        if (!event.isCancelled()) {
            ((IC)icData[2]).unload();
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPipePut(PipePutEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        Object[] icData = this.setupIC(event.getPuttingBlock(), true);
        if (icData == null) {
            return;
        }
        if (icData[2] instanceof PipeInputIC) {
            ((PipeInputIC)icData[2]).onPipeTransfer(event);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onSignChange(SignChangeEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        this.initializeIC(event.getBlock(), CraftBookPlugin.inst().wrapPlayer(event.getPlayer()), event, false);
    }

    public void initializeIC(Block block, CraftBookPlayer player, SignChangeEvent event, boolean shortHand) {
        boolean matches = true;
        Matcher matcher = RegexUtil.IC_PATTERN.matcher(event.getLine(1));
        if (!matcher.matches()) {
            matches = false;
        }
        try {
            if (!ICManager.hasCustomPrefix(matcher.group(2))) {
                matches = false;
            }
        }
        catch (Exception e) {
            matches = false;
        }
        if (matches) {
            RegisteredICFactory registration;
            try {
                String prefix = matcher.group(2);
                if (prefix.equalsIgnoreCase("MCA")) {
                    event.setLine(1, (event.getLine(1).toLowerCase(Locale.ENGLISH).replace("mca", "mc") + "a").toUpperCase(Locale.ENGLISH));
                    this.initializeIC(block, player, event, shortHand);
                    return;
                }
                if (event.getLine(1).toLowerCase(Locale.ENGLISH).startsWith("[mc0")) {
                    if (event.getLine(1).equalsIgnoreCase("[mc0420]")) {
                        event.setLine(1, "[MC1421]S");
                    } else if (event.getLine(1).equalsIgnoreCase("[mc0421]")) {
                        event.setLine(1, "[MC1422]S");
                    } else {
                        event.setLine(1, (event.getLine(1).toLowerCase(Locale.ENGLISH).replace("mc0", "mc1") + "s").toUpperCase(Locale.ENGLISH));
                    }
                    this.initializeIC(block, player, event, shortHand);
                    return;
                }
                if (event.getLine(1).toLowerCase(Locale.ENGLISH).startsWith("[mcz")) {
                    event.setLine(1, (event.getLine(1).toLowerCase(Locale.ENGLISH).replace("mcz", "mcx") + "s").toUpperCase(Locale.ENGLISH));
                    this.initializeIC(block, player, event, shortHand);
                    return;
                }
            }
            catch (Exception prefix) {
                // empty catch block
            }
            String id = matcher.group(1);
            String[] str = RegexUtil.RIGHT_BRACKET_PATTERN.split(event.getLine(1));
            String suffix = str.length > 1 ? str[1] : "";
            if (!SignUtil.isWallSign(block)) {
                player.printError("Only wall signs are used for ICs.");
                SignUtil.cancelSign(event);
                return;
            }
            if (ICManager.isCachedIC(block.getLocation())) {
                CraftBookPlugin.logDebugMessage("Existing IC found at selected location!", "ic-create");
                ICManager.getCachedIC(block.getLocation()).unload();
                ICManager.removeCachedIC(block.getLocation());
            }
            if ((registration = this.manager.get(id)) == null) {
                player.printError("Unknown IC detected: " + id);
                SignUtil.cancelSign(event);
                return;
            }
            ICFactory factory = registration.getFactory();
            try {
                ICMechanic.checkPermissions(player, factory, registration.getId().toLowerCase(Locale.ENGLISH));
            }
            catch (ICVerificationException e) {
                player.printError(e.getMessage());
                SignUtil.cancelSign(event);
                return;
            }
            Bukkit.getServer().getScheduler().runTask((Plugin)CraftBookPlugin.inst(), () -> {
                ChangedSign sign = CraftBookPlugin.inst().getNmsAdapter().getChangedSign(event.getBlock(), event.getLines(), null);
                ICUtil.parseSignFlags(player, sign);
                try {
                    factory.verify(sign);
                    factory.checkPlayer(sign, player);
                }
                catch (ICVerificationException e) {
                    player.printError(e.getMessage());
                    event.getBlock().breakNaturally();
                    return;
                }
                IC ic = registration.getFactory().create(sign);
                ic.load();
                sign.setLine(1, "[" + registration.getId() + "]" + suffix);
                if (!shortHand) {
                    sign.setLine(0, ic.getSignTitle());
                }
                sign.update(false);
                if (ic instanceof SelfTriggeredIC && (event.getLine(1).trim().toUpperCase(Locale.ENGLISH).endsWith("S") || ((SelfTriggeredIC)ic).isAlwaysST())) {
                    if (this.disableSelfTriggered) {
                        player.printError("Self-triggered ICs are disabled!");
                        return;
                    }
                    CraftBookPlugin.inst().getSelfTriggerManager().registerSelfTrigger(block.getLocation());
                }
                player.print("You've created " + registration.getId() + ": " + ic.getTitle() + ".");
            });
            return;
        }
        if (shortHand && event.getLine(0).startsWith("=")) {
            String id = event.getLine(0).substring(1);
            boolean st = id.toLowerCase(Locale.ENGLISH).endsWith(" st");
            String shortId = this.manager.longRegistered.get((id = StringUtils.replace((String)id.toLowerCase(Locale.ENGLISH), (String)" st", (String)"")).toLowerCase(Locale.ENGLISH));
            if (shortId == null) {
                player.printError("Warning: Unknown IC");
                return;
            }
            if (!SignUtil.isWallSign(block)) {
                player.printError("Only wall signs are used for ICs.");
                SignUtil.cancelSign(event);
                return;
            }
            event.setLine(1, "[" + shortId + "]" + (st ? "S" : ""));
            this.initializeIC(block, player, event, true);
            return;
        }
    }

    public static boolean checkPermissionsBoolean(CraftBookPlayer player, ICFactory factory, String id) {
        try {
            ICMechanic.checkPermissions(player, factory, id);
        }
        catch (ICVerificationException e) {
            return false;
        }
        return true;
    }

    public static void checkPermissions(CraftBookPlayer player, ICFactory factory, String id) throws ICVerificationException {
        if (player.hasPermission("craftbook.ic." + id.toLowerCase(Locale.ENGLISH))) {
            return;
        }
        if (player.hasPermission("craftbook.ic." + factory.getClass().getPackage().getName() + '.' + id.toLowerCase(Locale.ENGLISH))) {
            return;
        }
        if (factory instanceof RestrictedIC ? ICMechanic.hasRestrictedPermissions(player, factory, id) : ICMechanic.hasSafePermissions(player, factory, id)) {
            return;
        }
        throw new ICVerificationException("You don't have permission to use " + id.toLowerCase(Locale.ENGLISH) + ".");
    }

    public static boolean hasRestrictedPermissions(CraftBookPlayer player, ICFactory factory, String id) {
        return player.hasPermission("craftbook.ic.restricted." + id.toLowerCase(Locale.ENGLISH));
    }

    public static boolean hasSafePermissions(CraftBookPlayer player, ICFactory factory, String id) {
        return player.hasPermission("craftbook.ic.safe." + id.toLowerCase(Locale.ENGLISH));
    }

    @Override
    public void loadConfiguration(YAMLProcessor config, String path) {
        config.setComment(path + "cache", "Saves many CPU cycles with a VERY small cost to memory (Highly Recommended)");
        this.cache = config.getBoolean(path + "cache", true);
        config.setComment(path + "max-radius", "The max radius IC's with a radius setting can use. (WILL cause lag at higher values)");
        this.maxRange = config.getDouble(path + "max-radius", 10.0);
        config.setComment(path + "allow-short-hand", "Allows the usage of IC Shorthand, which is an easier way to create ICs.");
        this.shortHand = config.getBoolean(path + "allow-short-hand", true);
        config.setComment(path + "keep-loaded", "Keep any chunk with an ST IC in it loaded.");
        this.keepLoaded = config.getBoolean(path + "keep-loaded", false);
        config.setComment(path + "disallowed-ics", "A list of IC's which are never loaded. They will not work or show up in /ic list.");
        this.disabledICs = config.getStringList(path + "disallowed-ics", new ArrayList());
        config.setComment(path + "default-coordinate-system", "The default coordinate system for ICs. This changes the way IC offsets work. From RELATIVE, OFFSET and ABSOLUTE.");
        this.defaultCoordinates = ICUtil.LocationCheckType.getTypeFromName(config.getString(path + "default-coordinate-system", "RELATIVE"));
        config.setComment(path + "save-persistent-data", "Saves extra data to the CraftBook folder that allows some ICs to work better on server restart.");
        this.savePersistentData = config.getBoolean(path + "save-persistent-data", true);
        config.setComment(path + "midi-use-percussion", "Plays the MIDI percussion channel when using a MIDI playing IC. Note: This may sound horrible on some songs.");
        this.usePercussionMidi = config.getBoolean(path + "midi-use-percussion", false);
        config.setComment(path + "break-on-error", "Break the IC sign when an error occurs from that specific IC.");
        this.breakOnError = config.getBoolean(path + "break-on-error", false);
        config.setComment(path + "disable-self-triggered", "Disable creation and checking of self-triggered ICs.");
        this.disableSelfTriggered = config.getBoolean(path + "disable-self-triggered", false);
    }
}

