/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.ic;

import com.sk89q.craftbook.mechanics.ic.ConfigurableIC;
import com.sk89q.craftbook.mechanics.ic.ICManager;
import com.sk89q.craftbook.mechanics.ic.RegisteredICFactory;
import com.sk89q.util.yaml.YAMLProcessor;
import java.io.IOException;
import java.util.logging.Logger;

public class ICConfiguration {
    public final YAMLProcessor config;
    protected final Logger logger;

    public ICConfiguration(YAMLProcessor config, Logger logger) {
        this.config = config;
        this.logger = logger;
    }

    public void load() {
        try {
            this.config.load();
        }
        catch (IOException e) {
            this.logger.severe("Error loading CraftBook IC configuration: " + e);
            e.printStackTrace();
        }
        for (RegisteredICFactory factory : ICManager.inst().getICList()) {
            if (!(factory.getFactory() instanceof ConfigurableIC)) continue;
            ((ConfigurableIC)((Object)factory.getFactory())).addConfiguration(this.config, "ics." + factory.getId() + ".");
        }
        this.config.save();
    }
}

