/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.ic;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import com.sk89q.craftbook.bukkit.util.CraftBookBukkitUtil;
import com.sk89q.craftbook.mechanics.ic.IC;
import com.sk89q.craftbook.mechanics.ic.ICDocsParser;
import com.sk89q.craftbook.mechanics.ic.ICFactory;
import com.sk89q.craftbook.util.RegexUtil;
import com.sk89q.craftbook.util.SignUtil;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;

public abstract class AbstractIC
implements IC {
    private final Server server;
    private final ChangedSign sign;
    private final ICFactory factory;

    public AbstractIC(Server server, ChangedSign sign, ICFactory factory) {
        this.factory = factory;
        this.server = server;
        this.sign = sign;
    }

    protected Server getServer() {
        return this.server;
    }

    @Override
    public ChangedSign getSign() {
        return this.sign;
    }

    public Location getLocation() {
        return CraftBookBukkitUtil.toSign(this.getSign()).getLocation();
    }

    public Block getBackBlock() {
        return SignUtil.getBackBlock(CraftBookBukkitUtil.toSign(this.sign).getBlock());
    }

    public String getLine(int line) {
        return this.sign.getLine(line);
    }

    public String getRawLine(int line) {
        return this.sign.getRawLine(line);
    }

    public ICFactory getFactory() {
        return this.factory;
    }

    public CraftBookPlugin getPlugin() {
        return CraftBookPlugin.inst();
    }

    @Override
    public void onRightClick(Player p) {
        if (p.isSneaking()) {
            ICDocsParser.generateICDocs(p, RegexUtil.RIGHT_BRACKET_PATTERN.split(RegexUtil.LEFT_BRACKET_PATTERN.split(this.getSign().getLine(1))[1])[0]);
        }
    }

    @Override
    public void onICBreak(BlockBreakEvent event) {
    }

    @Override
    public void unload() {
        this.sign.update(false);
    }

    @Override
    public void load() {
    }

    public boolean equals(Object o) {
        return o instanceof AbstractIC && this.getSignTitle().equalsIgnoreCase(((AbstractIC)o).getSignTitle()) && this.getTitle().equalsIgnoreCase(((AbstractIC)o).getTitle()) && this.sign.equals(((AbstractIC)o).sign);
    }
}

