/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.drops;

import com.sk89q.craftbook.AbstractCraftBookMechanic;
import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import com.sk89q.craftbook.bukkit.util.CraftBookBukkitUtil;
import com.sk89q.craftbook.mechanics.drops.BlockCustomDropDefinition;
import com.sk89q.craftbook.mechanics.drops.CustomDropDefinition;
import com.sk89q.craftbook.mechanics.drops.DropItemStack;
import com.sk89q.craftbook.mechanics.drops.EntityCustomDropDefinition;
import com.sk89q.craftbook.mechanics.drops.rewards.DropReward;
import com.sk89q.craftbook.mechanics.drops.rewards.MonetaryDropReward;
import com.sk89q.craftbook.util.BlockSyntax;
import com.sk89q.craftbook.util.BlockUtil;
import com.sk89q.craftbook.util.EventUtil;
import com.sk89q.craftbook.util.ItemSyntax;
import com.sk89q.craftbook.util.ItemUtil;
import com.sk89q.craftbook.util.TernaryState;
import com.sk89q.util.yaml.YAMLFormat;
import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.data.BlockData;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;

public class CustomDrops
extends AbstractCraftBookMechanic {
    private YAMLProcessor config;
    private Set<CustomDropDefinition> definitions;
    private boolean customDropPermissions;
    private boolean removeVanillaDrops;

    @Override
    public boolean enable() {
        this.definitions = new LinkedHashSet<CustomDropDefinition>();
        CraftBookPlugin.inst().createDefaultConfiguration(new File(CraftBookPlugin.inst().getDataFolder(), "custom-drops.yml"), "custom-drops.yml");
        this.config = new YAMLProcessor(new File(CraftBookPlugin.inst().getDataFolder(), "custom-drops.yml"), false, YAMLFormat.EXTENDED);
        this.load();
        return true;
    }

    public boolean load() {
        this.definitions.clear();
        try {
            this.config.load();
        }
        catch (IOException e) {
            CraftBookBukkitUtil.printStacktrace(e);
            return false;
        }
        for (String key : this.config.getKeys("custom-drops")) {
            String type = this.config.getString("custom-drops." + key + ".type");
            boolean append = this.config.getBoolean("custom-drops." + key + ".append", false);
            TernaryState silkTouch = TernaryState.getFromString(this.config.getString("custom-drops." + key + ".silk-touch", "none"));
            List regions = this.config.getStringList("custom-drops." + key + ".regions", null);
            List requiredItems = this.config.getStringList("custom-drops." + key + ".required-items", null);
            List biomeStrings = this.config.getStringList("custom-drops." + key + ".biomes", null);
            ArrayList<DropItemStack> drops = new ArrayList<DropItemStack>();
            for (Object drop : this.config.getKeys("custom-drops." + key + ".drops")) {
                ItemStack item = ItemUtil.makeItemValid(ItemSyntax.getItem(this.config.getString("custom-drops." + key + ".drops." + (String)drop + ".item")));
                if (item == null) continue;
                DropItemStack stack = new DropItemStack(item);
                stack.setName((String)drop);
                stack.setChance(this.config.getDouble("custom-drops." + key + ".drops." + (String)drop + ".chance", 100.0));
                stack.setMinimum(this.config.getInt("custom-drops." + key + ".drops." + (String)drop + ".minimum-amount", -1));
                stack.setMaximum(this.config.getInt("custom-drops." + key + ".drops." + (String)drop + ".maximum-amount", -1));
                drops.add(stack);
            }
            ArrayList<DropReward> rewards = new ArrayList<DropReward>();
            if (this.config.getKeys("custom-drops." + key + ".rewards") != null) {
                Object drop;
                drop = this.config.getKeys("custom-drops." + key + ".rewards").iterator();
                while (drop.hasNext()) {
                    String reward = (String)drop.next();
                    String rewardType = this.config.getString("custom-drops." + key + ".rewards." + reward + ".type", "None");
                    MonetaryDropReward dropReward = null;
                    if (rewardType.equalsIgnoreCase("money")) {
                        double amount = this.config.getDouble("custom-drops." + key + ".rewards." + reward + ".amount", 10.0);
                        dropReward = new MonetaryDropReward(reward, amount);
                    }
                    if (dropReward == null) continue;
                    rewards.add(dropReward);
                }
            }
            CustomDropDefinition def = null;
            if (type.equalsIgnoreCase("entity") || type.equalsIgnoreCase("mob")) {
                EntityType ent = EntityType.valueOf((String)this.config.getString("custom-drops." + key + ".entity-type"));
                def = new EntityCustomDropDefinition(key, drops, rewards, silkTouch, ent);
            } else if (type.equalsIgnoreCase("block")) {
                BaseBlock data = BlockSyntax.getBlock(this.config.getString("custom-drops." + key + ".block"), true);
                def = new BlockCustomDropDefinition(key, drops, rewards, silkTouch, (BlockStateHolder)data);
            }
            if (def == null) continue;
            def.setAppend(append);
            if (regions != null) {
                def.setRegions(regions);
            }
            def.setPermissionNode(this.config.getString("custom-drops." + key + ".permission-node", null));
            if (requiredItems != null) {
                ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                for (String requiredItem : requiredItems) {
                    items.add(ItemSyntax.getItem(requiredItem));
                }
                def.setItems(items);
            }
            if (biomeStrings != null && !biomeStrings.isEmpty()) {
                ArrayList<Biome> biomes = new ArrayList<Biome>();
                for (String biomeString : biomeStrings) {
                    try {
                        Biome biome = Biome.valueOf((String)biomeString);
                        biomes.add(biome);
                    }
                    catch (IllegalArgumentException e) {
                        CraftBookPlugin.logger().warning("Tried to assign invalid biome " + biomeString + " to custom drop!");
                    }
                }
                def.setBiomes(biomes);
            }
            this.definitions.add(def);
        }
        return true;
    }

    public void save() {
        for (CustomDropDefinition def : this.definitions) {
            this.config.setProperty("custom-drops." + def.getName() + ".append", (Object)def.getAppend());
            this.config.setProperty("custom-drops." + def.getName() + ".silk-touch", (Object)def.getSilkTouch().toString());
            if (def.getPermissionNode() != null) {
                this.config.setProperty("custom-drops." + def.getName() + ".permission-node", (Object)def.getPermissionNode());
            }
            if (def.getRegions() != null) {
                this.config.setProperty("custom-drops." + def.getName() + ".regions", def.getRegions());
            }
            if (def.getItems() != null) {
                ArrayList<String> itemsList = new ArrayList<String>();
                for (ItemStack itemStack : def.getItems()) {
                    itemsList.add(ItemSyntax.getStringFromItem(itemStack));
                }
                this.config.setProperty("custom-drops." + def.getName() + ".required-items", itemsList);
            }
            if (def.getBiomes() != null) {
                ArrayList<String> biomeStringList = new ArrayList<String>();
                for (Biome biome : def.getBiomes()) {
                    biomeStringList.add(biome.name());
                }
                this.config.setProperty("custom-drops." + def.getName() + ".biomes", biomeStringList);
            }
            int i = 0;
            for (DropItemStack stack : def.getDrops()) {
                String stackName = stack.getName();
                if (stackName == null) {
                    stackName = "Drop" + i++;
                }
                this.config.setProperty("custom-drops." + def.getName() + ".drops." + stackName + ".item", (Object)ItemSyntax.getStringFromItem(stack.getStack()));
                this.config.setProperty("custom-drops." + def.getName() + ".drops." + stackName + ".chance", (Object)stack.getChance());
                this.config.setProperty("custom-drops." + def.getName() + ".drops." + stackName + ".minimum-amount", (Object)stack.getMinimum());
                this.config.setProperty("custom-drops." + def.getName() + ".drops." + stackName + ".maximum-amount", (Object)stack.getMaximum());
            }
            for (DropReward reward : def.getRewards()) {
                if (!(reward instanceof MonetaryDropReward)) continue;
                this.config.setProperty("custom-drops." + def.getName() + ".rewards." + reward.getName() + ".type", (Object)"money");
                this.config.setProperty("custom-drops." + def.getName() + ".rewards." + reward.getName() + ".amount", (Object)((MonetaryDropReward)reward).getAmount());
            }
            if (def instanceof EntityCustomDropDefinition) {
                this.config.setProperty("custom-drops." + def.getName() + ".type", (Object)"ENTITY");
                this.config.setProperty("custom-drops." + def.getName() + ".entity-type", (Object)((EntityCustomDropDefinition)def).getEntityType().name());
                continue;
            }
            if (!(def instanceof BlockCustomDropDefinition)) continue;
            this.config.setProperty("custom-drops." + def.getName() + ".type", (Object)"BLOCK");
            this.config.setProperty("custom-drops." + def.getName() + ".block", (Object)((BlockCustomDropDefinition)def).getBlockType().toString());
        }
        this.config.save();
    }

    public void addDefinition(CustomDropDefinition definition) {
        this.definitions.add(definition);
        this.save();
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockBreak(BlockBreakEvent event) {
        if (this.customDropPermissions && !CraftBookPlugin.inst().wrapPlayer(event.getPlayer()).hasPermission("craftbook.mech.drops")) {
            return;
        }
        if (event.getPlayer().getGameMode() == GameMode.CREATIVE) {
            return;
        }
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        for (CustomDropDefinition def : this.definitions) {
            boolean isSilkTouch;
            boolean found;
            if (!(def instanceof BlockCustomDropDefinition) || !((BlockCustomDropDefinition)def).getBlockType().equalsFuzzy((BlockStateHolder)BukkitAdapter.adapt((BlockData)event.getBlock().getBlockData()))) continue;
            if (def.getPermissionNode() != null && !CraftBookPlugin.inst().wrapPlayer(event.getPlayer()).hasPermission(def.getPermissionNode())) {
                return;
            }
            if (def.getRegions() != null) {
                found = false;
                for (String region : def.getRegions()) {
                    ProtectedRegion r = WorldGuard.getInstance().getPlatform().getRegionContainer().get(BukkitAdapter.adapt((World)event.getBlock().getWorld())).getRegion(region);
                    if (r == null || !r.contains(event.getBlock().getX(), event.getBlock().getY(), event.getBlock().getZ())) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
            }
            if (def.getBiomes() != null) {
                found = false;
                for (Biome biome : def.getBiomes()) {
                    if (!event.getBlock().getBiome().equals((Object)biome)) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
            }
            if (def.getItems() != null) {
                found = false;
                for (ItemStack item : def.getItems()) {
                    if (!ItemUtil.areItemsIdentical(event.getPlayer().getItemInHand(), item)) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
            }
            boolean bl = isSilkTouch = event.getPlayer().getInventory().getItemInMainHand() != null && event.getPlayer().getInventory().getItemInMainHand().getEnchantmentLevel(Enchantment.SILK_TOUCH) > 0;
            if (!def.getSilkTouch().doesPass(isSilkTouch)) continue;
            if (!def.getAppend()) {
                event.setCancelled(true);
                event.getBlock().setType(Material.AIR);
                if (event.getExpToDrop() > 0) {
                    ((ExperienceOrb)event.getBlock().getWorld().spawnEntity(BlockUtil.getBlockCentre(event.getBlock()), EntityType.EXPERIENCE_ORB)).setExperience(event.getExpToDrop());
                }
            }
            for (ItemStack itemStack : def.getRandomDrops()) {
                event.getBlock().getWorld().dropItemNaturally(BlockUtil.getBlockCentre(event.getBlock()), itemStack);
            }
            for (DropReward dropReward : def.getRewards()) {
                dropReward.giveReward(event.getPlayer());
            }
        }
        if (this.removeVanillaDrops) {
            event.setCancelled(true);
            event.getBlock().setType(Material.AIR);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onEntityDeath(EntityDeathEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        for (CustomDropDefinition def : this.definitions) {
            boolean isSilkTouch;
            boolean found;
            if (!(def instanceof EntityCustomDropDefinition) || !((EntityCustomDropDefinition)def).getEntityType().equals((Object)event.getEntityType())) continue;
            if (!(def.getPermissionNode() == null || event.getEntity().getKiller() != null && CraftBookPlugin.inst().wrapPlayer(event.getEntity().getKiller()).hasPermission(def.getPermissionNode()))) {
                return;
            }
            if (def.getRegions() != null) {
                found = false;
                for (String string : def.getRegions()) {
                    ProtectedRegion r = WorldGuard.getInstance().getPlatform().getRegionContainer().get(BukkitAdapter.adapt((World)event.getEntity().getWorld())).getRegion(string);
                    if (r == null || !r.contains(event.getEntity().getLocation().getBlockX(), event.getEntity().getLocation().getBlockY(), event.getEntity().getLocation().getBlockZ())) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
            }
            if (def.getBiomes() != null) {
                found = false;
                for (Biome biome : def.getBiomes()) {
                    if (!event.getEntity().getLocation().getBlock().getBiome().equals((Object)biome)) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
            }
            Player killer = event.getEntity().getKiller();
            if (def.getItems() != null) {
                boolean found2 = false;
                if (killer != null) {
                    for (ItemStack item : def.getItems()) {
                        if (!ItemUtil.areItemsIdentical(killer.getInventory().getItemInMainHand(), item)) continue;
                        found2 = true;
                        break;
                    }
                }
                if (!found2) continue;
            }
            boolean bl = isSilkTouch = killer != null && killer.getInventory().getItemInMainHand() != null && killer.getInventory().getItemInMainHand().getEnchantmentLevel(Enchantment.SILK_TOUCH) > 0;
            if (!def.getSilkTouch().doesPass(isSilkTouch)) continue;
            if (!def.getAppend()) {
                event.getDrops().clear();
                if (event.getDroppedExp() > 0) {
                    ((ExperienceOrb)event.getEntity().getWorld().spawnEntity(event.getEntity().getLocation(), EntityType.EXPERIENCE_ORB)).setExperience(event.getDroppedExp());
                }
            }
            for (ItemStack itemStack : def.getRandomDrops()) {
                event.getEntity().getWorld().dropItemNaturally(event.getEntity().getLocation(), itemStack);
            }
            for (DropReward dropReward : def.getRewards()) {
                if (killer == null && dropReward.doesRequirePlayer()) continue;
                dropReward.giveReward(killer);
            }
        }
        if (this.removeVanillaDrops) {
            event.getDrops().clear();
        }
    }

    @Override
    public void loadConfiguration(YAMLProcessor config, String path) {
        config.setComment(path + "require-permissions", "Require a permission node to get custom drops.");
        this.customDropPermissions = config.getBoolean(path + "require-permissions", false);
        config.setComment(path + "remove-vanilla-drops", "Remove all vanilla drops.");
        this.removeVanillaDrops = config.getBoolean(path + "remove-vanilla-drops", false);
    }
}

