/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.dispenser;

import com.sk89q.craftbook.AbstractCraftBookMechanic;
import com.sk89q.craftbook.mechanics.dispenser.Cannon;
import com.sk89q.craftbook.mechanics.dispenser.Fan;
import com.sk89q.craftbook.mechanics.dispenser.FireArrows;
import com.sk89q.craftbook.mechanics.dispenser.Recipe;
import com.sk89q.craftbook.mechanics.dispenser.SnowShooter;
import com.sk89q.craftbook.mechanics.dispenser.XPShooter;
import com.sk89q.craftbook.util.EventUtil;
import com.sk89q.craftbook.util.ItemUtil;
import com.sk89q.util.yaml.YAMLProcessor;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Dispenser;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class DispenserRecipes
extends AbstractCraftBookMechanic {
    private Set<Recipe> recipes;
    private static DispenserRecipes instance;
    private boolean cannonEnable;
    private boolean fanEnable;
    private boolean fireArrowsEnable;
    private boolean snowShooterEnable;
    private boolean xpShooterEnable;

    @Override
    public boolean enable() {
        instance = this;
        this.recipes = new HashSet<Recipe>();
        if (this.xpShooterEnable) {
            this.addRecipe(new XPShooter());
        }
        if (this.snowShooterEnable) {
            this.addRecipe(new SnowShooter());
        }
        if (this.fireArrowsEnable) {
            this.addRecipe(new FireArrows());
        }
        if (this.fanEnable) {
            this.addRecipe(new Fan());
        }
        if (this.cannonEnable) {
            this.addRecipe(new Cannon());
        }
        return this.recipes.size() > 0;
    }

    @Override
    public void disable() {
        this.recipes.clear();
        instance = null;
    }

    public static DispenserRecipes inst() {
        return instance;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockDispense(BlockDispenseEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (event.getBlock().getType() != Material.DISPENSER) {
            return;
        }
        if (this.dispenseNew(event.getBlock(), event.getItem(), event.getVelocity(), event)) {
            event.setCancelled(true);
        }
    }

    private boolean dispenseNew(Block block, ItemStack item, Vector velocity, BlockDispenseEvent event) {
        Dispenser dis = (Dispenser)block.getState();
        if (dis == null || dis.getInventory() == null || dis.getInventory().getContents() == null) {
            return false;
        }
        ItemStack[] stacks = dis.getInventory().getContents();
        for (Recipe r : this.recipes) {
            Material[] recipe = r.getRecipe();
            if (!DispenserRecipes.checkRecipe(stacks, recipe)) continue;
            boolean toReturn = r.doAction(block, item, velocity, event);
            for (int i = 0; i < stacks.length; ++i) {
                if (recipe[i] == Material.AIR) continue;
                stacks[i] = ItemUtil.getUsedItem(stacks[i]);
            }
            dis.getInventory().setContents(stacks);
            return toReturn;
        }
        return false;
    }

    private static boolean checkRecipe(ItemStack[] stacks, Material[] recipe) {
        for (int i = 0; i < stacks.length; ++i) {
            Material id;
            ItemStack stack = stacks[i];
            Material material = id = stack == null ? Material.AIR : stack.getType();
            if (recipe[i] == id) continue;
            return false;
        }
        return true;
    }

    public boolean addRecipe(Recipe recipe) {
        if (recipe == null) {
            throw new NullPointerException("Dispenser recipe must not be null.");
        }
        if (this.recipes.contains(recipe)) {
            return false;
        }
        this.recipes.add(recipe);
        return true;
    }

    @Override
    public void loadConfiguration(YAMLProcessor config, String path) {
        config.setComment(path + "cannon-enable", "Enables Cannon Dispenser Recipe.");
        this.cannonEnable = config.getBoolean(path + "cannon-enable", true);
        config.setComment(path + "fan-enable", "Enables Fan Dispenser Recipe.");
        this.fanEnable = config.getBoolean(path + "fan-enable", true);
        config.setComment(path + "fire-arrows-enable", "Enables Fire Arrows Dispenser Recipe.");
        this.fireArrowsEnable = config.getBoolean(path + "fire-arrows-enable", true);
        config.setComment(path + "snow-shooter-enable", "Enables Snow Shooter Dispenser Recipe.");
        this.snowShooterEnable = config.getBoolean(path + "snow-shooter-enable", true);
        config.setComment(path + "xp-shooter-enable", "Enables XP Shooter Dispenser Recipe.");
        this.xpShooterEnable = config.getBoolean(path + "xp-shooter-enable", true);
    }
}

