/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.crafting;

import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import com.sk89q.craftbook.bukkit.util.CraftBookBukkitUtil;
import com.sk89q.craftbook.mechanics.crafting.CraftingItemStack;
import com.sk89q.craftbook.mechanics.crafting.InvalidCraftingException;
import com.sk89q.craftbook.util.ItemSyntax;
import com.sk89q.craftbook.util.ItemUtil;
import com.sk89q.craftbook.util.RegexUtil;
import com.sk89q.util.yaml.YAMLProcessor;
import java.io.IOException;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.inventory.ItemStack;

public class RecipeManager {
    public static RecipeManager INSTANCE;
    private Set<Recipe> recipes;
    protected YAMLProcessor config;

    public RecipeManager(YAMLProcessor config) {
        INSTANCE = this;
        this.config = config;
        this.load();
    }

    public void load() {
        this.recipes = new LinkedHashSet<Recipe>();
        if (this.config == null) {
            CraftBookPlugin.logger().severe("Failure loading recipes! Config is null!");
            return;
        }
        try {
            this.config.load();
        }
        catch (IOException e) {
            CraftBookPlugin.logger().severe("Corrupt Custom Crafting crafting-recipes.yml File! Make sure that the correct syntax has been used, and that there are no tabs!");
            e.printStackTrace();
        }
        this.config.setHeader(new String[]{"# CraftBook Custom Recipes. CraftBook Version: " + CraftBookPlugin.inst().getDescription().getVersion(), "# For more information on setting up custom recipes, see the wiki:", "# " + CraftBookPlugin.getWikiDomain() + "/Custom_crafting", "", ""});
        List keys = this.config.getKeys("crafting-recipes");
        if (keys != null) {
            for (String key : keys) {
                try {
                    this.recipes.add(new Recipe(key, this.config));
                }
                catch (InvalidCraftingException e) {
                    CraftBookBukkitUtil.printStacktrace(e);
                }
            }
        }
    }

    public void disable() {
        INSTANCE = null;
    }

    public void save() {
        if (this.config == null) {
            CraftBookPlugin.logger().severe("Failure saving recipes! Config is null!");
            return;
        }
        this.config.clear();
        this.config.setHeader(new String[]{"# CraftBook Custom Recipes. CraftBook Version: " + CraftBookPlugin.inst().getDescription().getVersion(), "# For more information on setting up custom recipes, see the wiki:", "# " + CraftBookPlugin.getWikiDomain() + "/Custom_crafting", "", ""});
        this.config.addNode("crafting-recipes");
        for (Recipe recipe : this.recipes) {
            recipe.save();
        }
        this.config.save();
        this.load();
    }

    public Collection<Recipe> getRecipes() {
        return this.recipes;
    }

    public void addRecipe(Recipe rec) {
        this.recipes.add(rec);
        this.save();
    }

    public boolean removeRecipe(String name) {
        Iterator<Recipe> recs = this.recipes.iterator();
        while (recs.hasNext()) {
            Recipe rec = recs.next();
            if (!rec.getId().equalsIgnoreCase(name)) continue;
            recs.remove();
            this.save();
            return true;
        }
        return false;
    }

    public static enum RecipeType {
        SHAPELESS("Shapeless"),
        FURNACE("Furnace"),
        SHAPED("Shaped");

        private String name;

        private RecipeType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static RecipeType getTypeFromName(String name) {
            if (name.equalsIgnoreCase("Shaped2x2") || name.equalsIgnoreCase("Shaped3x3")) {
                CraftBookPlugin.logger().warning("You are using deprecated recipe type '" + name + "', we recommend you change it to 'shaped'!");
                return SHAPED;
            }
            for (RecipeType t : RecipeType.values()) {
                if (!t.name.equalsIgnoreCase(name)) continue;
                return t;
            }
            return SHAPELESS;
        }
    }

    public final class Recipe {
        private final String id;
        private RecipeType type;
        private List<CraftingItemStack> ingredients;
        private LinkedHashMap<CraftingItemStack, Character> items;
        private CraftingItemStack result;
        private List<String> shape;
        private float experience;
        private int cookTime;
        private HashMap<String, Object> advancedData = new HashMap();

        public boolean equals(Object o) {
            if (o instanceof Recipe) {
                CraftingItemStack sta;
                Iterator it;
                ArrayList<CraftingItemStack> stacks;
                if (this.shape != null && this.shape.size() != ((Recipe)o).shape.size()) {
                    return false;
                }
                if (this.ingredients != null) {
                    if (this.ingredients.size() != ((Recipe)o).ingredients.size()) {
                        return false;
                    }
                    stacks = new ArrayList<CraftingItemStack>(this.ingredients);
                    block0: for (CraftingItemStack st : ((Recipe)o).ingredients) {
                        if (stacks.size() <= 0) {
                            return false;
                        }
                        it = stacks.iterator();
                        while (it.hasNext()) {
                            sta = (CraftingItemStack)it.next();
                            if (!st.equals(sta)) continue;
                            it.remove();
                            continue block0;
                        }
                    }
                    if (stacks.size() > 0) {
                        return false;
                    }
                }
                if (this.items != null) {
                    if (this.items.size() != ((Recipe)o).items.size()) {
                        return false;
                    }
                    stacks = new ArrayList<CraftingItemStack>(this.items.keySet());
                    block2: for (CraftingItemStack st : ((Recipe)o).items.keySet()) {
                        if (stacks.size() <= 0) {
                            return false;
                        }
                        it = stacks.iterator();
                        while (it.hasNext()) {
                            sta = (CraftingItemStack)it.next();
                            if (!st.equals(sta)) continue;
                            it.remove();
                            continue block2;
                        }
                    }
                    if (stacks.size() > 0) {
                        return false;
                    }
                }
                if (this.advancedData != null && this.advancedData.size() != ((Recipe)o).advancedData.size()) {
                    return false;
                }
                return ((Recipe)o).id.equals(this.id) && this.type == ((Recipe)o).type && this.result.equals(((Recipe)o).result);
            }
            return false;
        }

        public int hashCode() {
            int ret = this.id.hashCode();
            if (this.ingredients != null) {
                ret += this.ingredients.hashCode();
            } else if (this.items != null) {
                ret += this.items.hashCode();
            }
            ret += this.result.hashCode();
            if (this.shape != null) {
                ret += this.shape.hashCode();
            }
            return ret + this.advancedData.hashCode();
        }

        public boolean hasAdvancedData() {
            if (this.ingredients != null) {
                for (CraftingItemStack stack : this.ingredients) {
                    if (!stack.hasAdvancedData()) continue;
                    return true;
                }
            }
            if (this.items != null) {
                for (CraftingItemStack stack : this.items.keySet()) {
                    if (!stack.hasAdvancedData()) continue;
                    return true;
                }
            }
            return this.result.hasAdvancedData() || !this.advancedData.isEmpty();
        }

        private Recipe(String id, YAMLProcessor config) throws InvalidCraftingException {
            this.id = id;
            this.ingredients = new ArrayList<CraftingItemStack>();
            this.items = new LinkedHashMap();
            this.load();
        }

        public Recipe(String id, RecipeType type, LinkedHashMap<CraftingItemStack, Character> items, List<String> shape, CraftingItemStack result, HashMap<String, Object> advancedData) throws InvalidCraftingException {
            this.id = id;
            this.type = type;
            this.items = items;
            this.shape = shape;
            this.result = result;
            this.advancedData = advancedData;
        }

        public Recipe(String id, RecipeType type, List<CraftingItemStack> ingredients, CraftingItemStack result, HashMap<String, Object> advancedData) throws InvalidCraftingException {
            this.id = id;
            this.type = type;
            this.ingredients = ingredients;
            this.result = result;
            this.advancedData = advancedData;
        }

        private void load() throws InvalidCraftingException {
            List actions;
            String permError;
            String permNode;
            Iterator<CraftingItemStack> iterator;
            this.type = RecipeType.getTypeFromName(RecipeManager.this.config.getString("crafting-recipes." + this.id + ".type"));
            if (this.type != RecipeType.SHAPED) {
                this.ingredients = this.getItems("crafting-recipes." + this.id + ".ingredients");
                if (this.type == RecipeType.FURNACE) {
                    this.cookTime = RecipeManager.this.config.getInt("crafting-recipes." + this.id + ".cook-time", 200);
                    this.experience = (float)RecipeManager.this.config.getDouble("crafting-recipes." + this.id + ".experience", 0.0);
                }
            } else {
                this.items = this.getShapeIngredients("crafting-recipes." + this.id + ".ingredients");
                this.shape = RecipeManager.this.config.getStringList("crafting-recipes." + this.id + ".shape", Collections.singletonList(""));
            }
            if (!(iterator = this.getItems("crafting-recipes." + this.id + ".results").iterator()).hasNext()) {
                throw new InvalidCraftingException("Result is invalid in recipe: " + this.id);
            }
            this.result = iterator.next();
            if (iterator.hasNext()) {
                ArrayList<CraftingItemStack> extraResults = new ArrayList<CraftingItemStack>();
                while (iterator.hasNext()) {
                    extraResults.add(iterator.next());
                }
                this.addAdvancedData("extra-results", extraResults);
            }
            if ((permNode = RecipeManager.this.config.getString("crafting-recipes." + this.id + ".permission-node", null)) != null) {
                this.addAdvancedData("permission-node", permNode);
            }
            if ((permError = RecipeManager.this.config.getString("crafting-recipes." + this.id + ".permission-error", null)) != null) {
                this.addAdvancedData("permission-error", permError);
            }
            if ((actions = RecipeManager.this.config.getKeys("crafting-recipes." + this.id + ".craft-actions")) != null && !actions.isEmpty()) {
                for (String s : actions) {
                    if (s.equalsIgnoreCase("commands-console")) {
                        this.addAdvancedData("commands-console", RecipeManager.this.config.getStringList("crafting-recipes." + this.id + ".craft-actions." + s, new ArrayList()));
                        continue;
                    }
                    if (!s.equalsIgnoreCase("commands-player")) continue;
                    this.addAdvancedData("commands-player", RecipeManager.this.config.getStringList("crafting-recipes." + this.id + ".craft-actions." + s, new ArrayList()));
                }
            }
        }

        public void save() {
            LinkedHashMap<String, Constable> resz;
            RecipeManager.this.config.addNode("crafting-recipes." + this.id);
            RecipeManager.this.config.setProperty("crafting-recipes." + this.id + ".type", (Object)this.type.name);
            if (this.type != RecipeType.SHAPED) {
                resz = new LinkedHashMap<String, Constable>();
                for (CraftingItemStack craftingItemStack : this.ingredients) {
                    resz.put(craftingItemStack.toString() + ' ', Integer.valueOf(craftingItemStack.getItemStack().getAmount()));
                }
                RecipeManager.this.config.setProperty("crafting-recipes." + this.id + ".ingredients", resz);
                if (this.type == RecipeType.FURNACE) {
                    RecipeManager.this.config.setProperty("crafting-recipes." + this.id + ".cook-time", (Object)this.cookTime);
                    RecipeManager.this.config.setProperty("crafting-recipes." + this.id + ".experience", (Object)Float.valueOf(this.experience));
                }
            } else {
                resz = new LinkedHashMap();
                for (Map.Entry entry : this.items.entrySet()) {
                    resz.put(((CraftingItemStack)entry.getKey()).toString() + ' ', (Character)entry.getValue());
                }
                RecipeManager.this.config.setProperty("crafting-recipes." + this.id + ".ingredients", resz);
                RecipeManager.this.config.setProperty("crafting-recipes." + this.id + ".shape", this.shape);
            }
            resz = new LinkedHashMap();
            resz.put(this.result.toString() + ' ', Integer.valueOf(this.result.getItemStack().getAmount()));
            if (this.hasAdvancedData("extra-results")) {
                ArrayList extraResults = new ArrayList((Collection)this.getAdvancedData("extra-results"));
                for (CraftingItemStack s : extraResults) {
                    resz.put(s.toString() + ' ', Integer.valueOf(s.getItemStack().getAmount()));
                }
            }
            RecipeManager.this.config.setProperty("crafting-recipes." + this.id + ".results", resz);
            if (this.hasAdvancedData("permission-node")) {
                RecipeManager.this.config.setProperty("crafting-recipes." + this.id + ".permission-node", this.getAdvancedData("permission-node"));
            }
            if (this.hasAdvancedData("permission-error")) {
                RecipeManager.this.config.setProperty("crafting-recipes." + this.id + ".permission-error", this.getAdvancedData("permission-error"));
            }
            if (this.hasAdvancedData("commands-player") || this.hasAdvancedData("commands-console")) {
                RecipeManager.this.config.addNode("crafting-recipes." + this.id + ".craft-actions");
                if (this.hasAdvancedData("commands-player")) {
                    RecipeManager.this.config.setProperty("crafting-recipes." + this.id + ".craft-actions.commands-player", this.getAdvancedData("commands-player"));
                }
                if (this.hasAdvancedData("commands-console")) {
                    RecipeManager.this.config.setProperty("crafting-recipes." + this.id + ".craft-actions.commands-console", this.getAdvancedData("commands-console"));
                }
            }
        }

        private LinkedHashMap<CraftingItemStack, Character> getShapeIngredients(String path) {
            LinkedHashMap<CraftingItemStack, Character> items = new LinkedHashMap<CraftingItemStack, Character>();
            try {
                for (String item : RecipeManager.this.config.getKeys(path)) {
                    ItemStack stack = ItemUtil.makeItemValid(ItemSyntax.getItem(RegexUtil.PERCENT_PATTERN.split(item.trim())[0]));
                    if (stack == null) continue;
                    stack.setAmount(1);
                    CraftingItemStack itemStack = new CraftingItemStack(stack);
                    if (RegexUtil.PERCENT_PATTERN.split(item).length > 1) {
                        itemStack.addAdvancedData("chance", Double.parseDouble(RegexUtil.PERCENT_PATTERN.split(item.trim())[1]));
                    }
                    items.put(itemStack, Character.valueOf(RecipeManager.this.config.getString(path + '.' + item, "a").charAt(0)));
                }
            }
            catch (Exception e) {
                CraftBookPlugin.inst().getLogger().severe("An error occured generating ingredients for recipe: " + this.id);
                CraftBookBukkitUtil.printStacktrace(e);
            }
            return items;
        }

        private List<CraftingItemStack> getItems(String path) {
            ArrayList<CraftingItemStack> items = new ArrayList<CraftingItemStack>();
            try {
                for (Object oitem : RecipeManager.this.config.getKeys(path)) {
                    String okey = String.valueOf(oitem);
                    String item = okey.trim();
                    ItemStack stack = ItemUtil.makeItemValid(ItemSyntax.getItem(RegexUtil.PERCENT_PATTERN.split(item)[0]));
                    if (stack == null) continue;
                    stack.setAmount(RecipeManager.this.config.getInt(path + '.' + okey, 1));
                    CraftingItemStack itemStack = new CraftingItemStack(stack);
                    if (RegexUtil.PERCENT_PATTERN.split(item).length > 1) {
                        itemStack.addAdvancedData("chance", Double.parseDouble(RegexUtil.PERCENT_PATTERN.split(item)[1]));
                    }
                    items.add(itemStack);
                }
            }
            catch (Exception e) {
                CraftBookPlugin.inst().getLogger().severe("An error occured generating ingredients for recipe: " + this.id);
                CraftBookBukkitUtil.printStacktrace(e);
            }
            return items;
        }

        public String getId() {
            return this.id;
        }

        public RecipeType getType() {
            return this.type;
        }

        public List<CraftingItemStack> getIngredients() {
            return this.ingredients;
        }

        public String[] getShape() {
            return this.shape.toArray(new String[this.shape.size()]);
        }

        public LinkedHashMap<CraftingItemStack, Character> getShapedIngredients() {
            return this.items;
        }

        public CraftingItemStack getResult() {
            return this.result;
        }

        public float getExperience() {
            return this.experience;
        }

        public void setExperience(float experience) {
            this.experience = experience;
        }

        public int getCookTime() {
            return this.cookTime;
        }

        public void setCookTime(int cookTime) {
            this.cookTime = cookTime;
        }

        public boolean hasAdvancedData(String key) {
            return this.advancedData.containsKey(key);
        }

        public Object getAdvancedData(String key) {
            return this.advancedData.get(key);
        }

        public void addAdvancedData(String key, Object data) {
            CraftBookPlugin.logDebugMessage("Adding advanced data of type: " + key + " to an ItemStack! {" + String.valueOf(data) + '}', "advanced-data.init");
            this.advancedData.put(key, data);
        }

        public HashMap<String, Object> getAdvancedDataMap() {
            return this.advancedData;
        }
    }
}

