/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.crafting;

import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import com.sk89q.craftbook.util.ItemSyntax;
import com.sk89q.craftbook.util.ItemUtil;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.inventory.ItemStack;

public class CraftingItemStack
implements Comparable<CraftingItemStack> {
    private ItemStack item;
    private HashMap<String, Object> advancedData = new HashMap();

    public boolean hasAdvancedData() {
        return !this.advancedData.isEmpty();
    }

    public boolean hasAdvancedData(String key) {
        return this.advancedData.containsKey(key);
    }

    public Object getAdvancedData(String key) {
        return this.advancedData.get(key);
    }

    public void addAdvancedData(String key, Object data) {
        CraftBookPlugin.logDebugMessage("Adding advanced data of type: " + key + " to an ItemStack!", "advanced-data.init");
        this.advancedData.put(key, data);
    }

    public CraftingItemStack(ItemStack item) {
        this.item = item;
        if (item != null && item.hasItemMeta()) {
            this.addAdvancedData("item-meta", true);
        }
    }

    public ItemStack getItemStack() {
        return this.item;
    }

    public CraftingItemStack add(CraftingItemStack stack) {
        if (stack.isSameType(this)) {
            ItemUtil.addToStack(this.item, stack.item);
            this.advancedData.putAll(stack.advancedData);
        }
        return this;
    }

    boolean isSameType(CraftingItemStack stack) {
        return ItemUtil.areItemsIdentical(this.item, stack.item);
    }

    @Override
    public int compareTo(CraftingItemStack stack) {
        return Integer.compare(stack.item.getAmount(), this.item.getAmount());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.item.hashCode();
        result = 31 * result + this.advancedData.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CraftingItemStack) {
            CraftingItemStack stack = (CraftingItemStack)obj;
            if (stack.advancedData.size() != this.advancedData.size()) {
                return false;
            }
            for (Map.Entry<String, Object> advancedDataEntries : this.advancedData.entrySet()) {
                if (!stack.hasAdvancedData(advancedDataEntries.getKey())) {
                    return false;
                }
                if (advancedDataEntries.getValue().equals(stack.getAdvancedData(advancedDataEntries.getKey()))) continue;
                return false;
            }
            return this.isSameType(stack) && stack.item.getAmount() == this.item.getAmount();
        }
        return false;
    }

    public String toString() {
        String it = ItemSyntax.getStringFromItem(this.item);
        if (this.hasAdvancedData("chance")) {
            it = it + '%' + this.getAdvancedData("chance");
        }
        return it;
    }
}

