/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.cauldron.legacy;

import com.sk89q.craftbook.AbstractCraftBookMechanic;
import com.sk89q.craftbook.CraftBookPlayer;
import com.sk89q.craftbook.bukkit.BukkitCraftBookPlayer;
import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import com.sk89q.craftbook.mechanics.cauldron.legacy.CauldronCookbook;
import com.sk89q.craftbook.util.BlockSyntax;
import com.sk89q.craftbook.util.EventUtil;
import com.sk89q.craftbook.util.ProtectionUtil;
import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import com.sk89q.worldedit.world.item.ItemType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

@Deprecated
public class Cauldron
extends AbstractCraftBookMechanic {
    protected CauldronCookbook recipes;
    public BlockStateHolder cauldronBlock;

    public boolean isACauldron(Block block) {
        Material below = block.getRelative(0, -1, 0).getType();
        Material below2 = block.getRelative(0, -2, 0).getType();
        Block s1 = block.getRelative(1, 0, 0);
        Block s3 = block.getRelative(-1, 0, 0);
        Block s2 = block.getRelative(0, 0, 1);
        Block s4 = block.getRelative(0, 0, -1);
        BlockStateHolder blockItem = this.cauldronBlock;
        return !(below != Material.LAVA && below2 != Material.LAVA || !blockItem.equalsFuzzy((BlockStateHolder)BukkitAdapter.adapt((BlockData)s1.getBlockData())) && !blockItem.equalsFuzzy((BlockStateHolder)BukkitAdapter.adapt((BlockData)s2.getBlockData())) && !blockItem.equalsFuzzy((BlockStateHolder)BukkitAdapter.adapt((BlockData)s3.getBlockData())) && !blockItem.equalsFuzzy((BlockStateHolder)BukkitAdapter.adapt((BlockData)s4.getBlockData())));
    }

    @Override
    public boolean enable() {
        this.recipes = new CauldronCookbook();
        return this.recipes.size() > 0;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onRightClick(PlayerInteractEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK || event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        if (!this.isACauldron(event.getClickedBlock())) {
            return;
        }
        CraftBookPlayer localPlayer = CraftBookPlugin.inst().wrapPlayer(event.getPlayer());
        if (!localPlayer.hasPermission("craftbook.mech.cauldron")) {
            if (CraftBookPlugin.inst().getConfiguration().showPermissionMessages) {
                localPlayer.printError("mech.use-permission");
            }
            return;
        }
        if (!ProtectionUtil.canUse(event.getPlayer(), event.getClickedBlock().getLocation(), event.getBlockFace(), event.getAction())) {
            if (CraftBookPlugin.inst().getConfiguration().showPermissionMessages) {
                localPlayer.printError("area.use-permissions");
            }
            return;
        }
        if (!localPlayer.isHoldingBlock()) {
            this.performCauldron(localPlayer, event.getPlayer().getWorld(), event.getClickedBlock().getRelative(0, event.getClickedBlock().getRelative(0, -1, 0).getType() == Material.LAVA ? 1 : 0, 0));
            event.setCancelled(true);
        }
    }

    private void performCauldron(CraftBookPlayer player, World world, Block block) {
        int rootY = block.getY();
        Player p = ((BukkitCraftBookPlayer)player).getPlayer();
        BlockStateHolder blockItem = this.cauldronBlock;
        HashMap<Location, BlockStateHolder> visited = new HashMap<Location, BlockStateHolder>();
        this.findCauldronContents(player, world, block, rootY - 1, rootY, visited);
        if (visited.size() != 24) {
            player.printError("mech.cauldron.too-small");
            return;
        }
        HashMap<BlockStateHolder, Integer> contents = new HashMap<BlockStateHolder, Integer>();
        for (Map.Entry entry : visited.entrySet()) {
            if (((BlockStateHolder)entry.getValue()).equals(blockItem)) continue;
            if (!contents.containsKey(entry.getValue())) {
                contents.put((BlockStateHolder)entry.getValue(), 1);
                continue;
            }
            contents.put((BlockStateHolder)entry.getValue(), (Integer)contents.get(entry.getValue()) + 1);
        }
        CraftBookPlugin.logDebugMessage("Ingredients: " + contents.keySet().toString(), "legacy-cauldron.ingredients");
        CauldronCookbook.Recipe recipe = this.recipes.find(contents);
        if (recipe != null) {
            String[] groups = recipe.getGroups();
            if (groups != null) {
                boolean found = false;
                for (String group : groups) {
                    if (!CraftBookPlugin.inst().inGroup(p, group)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    player.printError("mech.cauldron.legacy-not-in-group");
                    return;
                }
            }
            player.print(player.translate("mech.cauldron.legacy-create") + " " + recipe.getName() + ".");
            ArrayList<BlockStateHolder> ingredients = new ArrayList<BlockStateHolder>(recipe.getIngredients());
            for (Map.Entry entry : visited.entrySet()) {
                if (!ingredients.contains(entry.getValue())) continue;
                world.getBlockAt(((Location)entry.getKey()).getBlockX(), ((Location)entry.getKey()).getBlockY(), ((Location)entry.getKey()).getBlockZ()).setType(Material.AIR);
                ingredients.remove(entry.getValue());
            }
            for (BlockStateHolder blockStateHolder : recipe.getResults()) {
                HashMap map = p.getInventory().addItem(new ItemStack[]{new ItemStack(BukkitAdapter.adapt((ItemType)blockStateHolder.getBlockType().getItemType()), 1)});
                for (Map.Entry i : map.entrySet()) {
                    world.dropItem(p.getLocation(), (ItemStack)i.getValue());
                }
            }
            p.updateInventory();
        } else {
            player.printError("mech.cauldron.legacy-not-a-recipe");
        }
    }

    public void findCauldronContents(CraftBookPlayer player, World world, Block block, int minY, int maxY, Map<Location, BlockStateHolder> visited) {
        BlockStateHolder blockID = this.cauldronBlock;
        if (block.getY() < minY) {
            return;
        }
        if (block.getY() > maxY) {
            return;
        }
        if (visited.size() > 24) {
            player.printError("mech.cauldron.leaky");
            return;
        }
        if (visited.containsKey(block.getLocation())) {
            return;
        }
        Material type = block.getType();
        visited.put(block.getLocation(), (BlockStateHolder)BukkitAdapter.adapt((BlockData)block.getBlockData()));
        if (BukkitAdapter.equals((BlockType)blockID.getBlockType(), (Material)type)) {
            return;
        }
        Block lavaPos = this.recurse(0, block.getY() - minY + 1, 0, block);
        if (world.getBlockAt(lavaPos.getX(), lavaPos.getY(), lavaPos.getZ()).getType() == Material.LAVA) {
            player.printError("mech.cauldron.no-lava");
            return;
        }
        this.findCauldronContents(player, world, this.recurse(1, 0, 0, block), minY, maxY, visited);
        this.findCauldronContents(player, world, this.recurse(-1, 0, 0, block), minY, maxY, visited);
        this.findCauldronContents(player, world, this.recurse(0, 0, 1, block), minY, maxY, visited);
        this.findCauldronContents(player, world, this.recurse(0, 0, -1, block), minY, maxY, visited);
        this.findCauldronContents(player, world, this.recurse(0, 1, 0, block), minY, maxY, visited);
        this.findCauldronContents(player, world, this.recurse(0, -1, 0, block), minY, maxY, visited);
    }

    private Block recurse(int x, int y, int z, Block block) {
        return block.getRelative(x, y, z);
    }

    @Override
    public void loadConfiguration(YAMLProcessor config, String path) {
        config.setComment(path + "block", "The block to use as the casing for the legacy cauldron.");
        this.cauldronBlock = BlockSyntax.getBlock(config.getString(path + "block", BlockTypes.STONE.getId()), true);
    }
}

