/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.boat;

import com.sk89q.craftbook.AbstractCraftBookMechanic;
import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import com.sk89q.craftbook.util.EntityUtil;
import com.sk89q.craftbook.util.EventUtil;
import com.sk89q.craftbook.util.ItemUtil;
import com.sk89q.util.yaml.YAMLProcessor;
import org.bukkit.Bukkit;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ExitRemover
extends AbstractCraftBookMechanic {
    boolean giveItem;

    @EventHandler(priority=EventPriority.HIGH)
    public void onVehicleExit(VehicleExitEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (!(event.getVehicle() instanceof Boat)) {
            return;
        }
        Bukkit.getScheduler().runTaskLater((Plugin)CraftBookPlugin.inst(), (Runnable)new BoatRemover(event.getExited(), (Boat)event.getVehicle()), 2L);
    }

    @Override
    public void loadConfiguration(YAMLProcessor config, String path) {
        config.setComment(path + "give-item", "Sets whether to give the player the item back or not.");
        this.giveItem = config.getBoolean(path + "give-item", false);
    }

    class BoatRemover
    implements Runnable {
        LivingEntity player;
        Boat boat;

        BoatRemover(LivingEntity player, Boat boat) {
            this.player = player;
            this.boat = boat;
        }

        @Override
        public void run() {
            if (!this.boat.isValid() || this.boat.isDead() || !this.boat.isEmpty()) {
                return;
            }
            if (ExitRemover.this.giveItem) {
                ItemStack stack = new ItemStack(ItemUtil.getBoatFromTree(this.boat.getWoodType()), 1);
                if (this.player instanceof Player) {
                    if (!((Player)this.player).getInventory().addItem(new ItemStack[]{stack}).isEmpty()) {
                        this.player.getLocation().getWorld().dropItemNaturally(this.player.getLocation(), stack);
                    }
                } else if (this.player != null) {
                    this.player.getLocation().getWorld().dropItemNaturally(this.player.getLocation(), stack);
                } else {
                    this.boat.getLocation().getWorld().dropItemNaturally(this.boat.getLocation(), stack);
                }
            }
            EntityUtil.killEntity((Entity)this.boat);
        }
    }
}

