/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.boat;

import com.sk89q.craftbook.AbstractCraftBookMechanic;
import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import com.sk89q.craftbook.util.EventUtil;
import com.sk89q.util.yaml.YAMLProcessor;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.plugin.Plugin;

public class EmptyDecay
extends AbstractCraftBookMechanic {
    private int delay;

    @EventHandler(priority=EventPriority.HIGH)
    public void onVehicleExit(VehicleExitEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        Vehicle vehicle = event.getVehicle();
        if (!(vehicle instanceof Boat)) {
            return;
        }
        CraftBookPlugin.inst().getServer().getScheduler().runTaskLater((Plugin)CraftBookPlugin.inst(), (Runnable)new Decay((Boat)vehicle), (long)this.delay);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onChunkLoad(ChunkLoadEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        for (Entity ent : event.getChunk().getEntities()) {
            if (ent == null || !ent.isValid() || !(ent instanceof Boat) || !ent.isEmpty()) continue;
            CraftBookPlugin.inst().getServer().getScheduler().runTaskLater((Plugin)CraftBookPlugin.inst(), (Runnable)new Decay((Boat)ent), (long)this.delay);
        }
    }

    @Override
    public void loadConfiguration(YAMLProcessor config, String path) {
        config.setComment(path + "time-in-ticks", "The time in ticks that the boat will wait before decaying.");
        this.delay = config.getInt(path + "time-in-ticks", 20);
    }

    private static class Decay
    implements Runnable {
        Boat cart;

        public Decay(Boat cart) {
            this.cart = cart;
        }

        @Override
        public void run() {
            if (this.cart == null || !this.cart.isValid() || !this.cart.isEmpty()) {
                return;
            }
            this.cart.remove();
        }
    }
}

