/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.area.simple;

import com.sk89q.craftbook.AbstractCraftBookMechanic;
import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.CraftBookPlayer;
import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import com.sk89q.craftbook.bukkit.util.CraftBookBukkitUtil;
import com.sk89q.craftbook.mechanics.pipe.PipeFinishEvent;
import com.sk89q.craftbook.mechanics.pipe.PipePutEvent;
import com.sk89q.craftbook.mechanics.pipe.PipeSuckEvent;
import com.sk89q.craftbook.util.BlockSyntax;
import com.sk89q.craftbook.util.BlockUtil;
import com.sk89q.craftbook.util.EventUtil;
import com.sk89q.craftbook.util.SignUtil;
import com.sk89q.craftbook.util.exceptions.InvalidMechanismException;
import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;

public abstract class CuboidToggleMechanic
extends AbstractCraftBookMechanic {
    protected boolean enforceType;

    public abstract Block getFarSign(Block var1);

    public abstract Block getBlockBase(Block var1) throws InvalidMechanismException;

    public abstract CuboidRegion getCuboidArea(Block var1, Block var2, Block var3) throws InvalidMechanismException;

    public abstract boolean isApplicableSign(String var1);

    public static boolean open(Block sign, Block farSide, BlockData type, CuboidRegion toggle) {
        ChangedSign s = CraftBookBukkitUtil.toChangedSign(sign);
        ChangedSign other = CraftBookBukkitUtil.toChangedSign(farSide);
        for (BlockVector3 bv : toggle) {
            Block b = sign.getWorld().getBlockAt(bv.getBlockX(), bv.getBlockY(), bv.getBlockZ());
            if (b.getType() != type.getMaterial() && !BlockUtil.isBlockReplacable(b.getType())) continue;
            if (CraftBookPlugin.inst().getConfiguration().safeDestruction && b.getType() == type.getMaterial()) {
                CuboidToggleMechanic.addBlocks(s, other, 1);
            }
            b.setType(Material.AIR);
        }
        return true;
    }

    public static boolean close(Block sign, Block farSide, BlockData data, CuboidRegion toggle, CraftBookPlayer player) {
        ChangedSign s = CraftBookBukkitUtil.toChangedSign(sign);
        ChangedSign other = CraftBookBukkitUtil.toChangedSign(farSide);
        for (BlockVector3 bv : toggle) {
            Block b = sign.getWorld().getBlockAt(bv.getBlockX(), bv.getBlockY(), bv.getBlockZ());
            if (!BlockUtil.isBlockReplacable(b.getType())) continue;
            if (CraftBookPlugin.inst().getConfiguration().safeDestruction) {
                if (CuboidToggleMechanic.hasEnoughBlocks(s, other)) {
                    b.setBlockData(data);
                    CuboidToggleMechanic.removeBlocks(s, other, 1);
                    continue;
                }
                if (player != null) {
                    player.printError("mech.not-enough-blocks");
                }
                return false;
            }
            b.setBlockData(data);
        }
        return true;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPipeFinish(PipeFinishEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (!SignUtil.isSign(event.getOrigin())) {
            return;
        }
        ChangedSign sign = CraftBookBukkitUtil.toChangedSign(event.getOrigin());
        if (!this.isApplicableSign(sign.getLine(1))) {
            return;
        }
        ArrayList<ItemStack> leftovers = new ArrayList<ItemStack>();
        try {
            Block base = this.getBlockBase(event.getOrigin());
            for (ItemStack stack : event.getItems()) {
                if (stack.getType() != base.getType() || stack.getData().getData() != base.getData()) {
                    leftovers.add(stack);
                    continue;
                }
                CuboidToggleMechanic.addBlocks(sign, null, stack.getAmount());
            }
            event.setItems(leftovers);
        }
        catch (InvalidMechanismException invalidMechanismException) {
            // empty catch block
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPipePut(PipePutEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (!SignUtil.isSign(event.getPuttingBlock())) {
            return;
        }
        ChangedSign sign = CraftBookBukkitUtil.toChangedSign(event.getPuttingBlock());
        if (!this.isApplicableSign(sign.getLine(1))) {
            return;
        }
        ArrayList<ItemStack> leftovers = new ArrayList<ItemStack>();
        try {
            Block base = this.getBlockBase(event.getPuttingBlock());
            for (ItemStack stack : event.getItems()) {
                if (stack.getType() != base.getType() || stack.getData().getData() != base.getData()) {
                    leftovers.add(stack);
                    continue;
                }
                CuboidToggleMechanic.addBlocks(sign, null, stack.getAmount());
            }
            event.setItems(leftovers);
        }
        catch (InvalidMechanismException invalidMechanismException) {
            // empty catch block
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPipeSuck(PipeSuckEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (!SignUtil.isSign(event.getSuckedBlock())) {
            return;
        }
        ChangedSign sign = CraftBookBukkitUtil.toChangedSign(event.getSuckedBlock());
        if (!this.isApplicableSign(sign.getLine(1))) {
            return;
        }
        List<ItemStack> items = event.getItems();
        try {
            Block base = this.getBlockBase(event.getSuckedBlock());
            int blocks = CuboidToggleMechanic.getBlocks(sign, null);
            if (blocks > 0) {
                items.add(new ItemStack(base.getType(), blocks, (short)base.getData()));
                CuboidToggleMechanic.setBlocks(sign, 0);
            }
            event.setItems(items);
        }
        catch (InvalidMechanismException invalidMechanismException) {
            // empty catch block
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockBreak(BlockBreakEvent event) {
        block9: {
            if (!EventUtil.passesFilter((Event)event)) {
                return;
            }
            if (!SignUtil.isSign(event.getBlock())) {
                return;
            }
            if (!this.isApplicableSign(CraftBookBukkitUtil.toChangedSign(event.getBlock()).getLine(1))) {
                return;
            }
            CraftBookPlayer player = CraftBookPlugin.inst().wrapPlayer(event.getPlayer());
            ChangedSign sign = null;
            if (SignUtil.isSign(event.getBlock())) {
                sign = CraftBookBukkitUtil.toChangedSign(event.getBlock());
            }
            if (sign == null) {
                return;
            }
            ChangedSign other = CraftBookBukkitUtil.toChangedSign(this.getFarSign(event.getBlock()));
            int amount = CuboidToggleMechanic.getBlocks(sign, other);
            if (amount > 0) {
                try {
                    BlockData base = this.getBlockType(event.getBlock());
                    while (amount > 0) {
                        ItemStack toDrop = new ItemStack(base.getMaterial(), Math.min(amount, 64));
                        event.getBlock().getWorld().dropItemNaturally(event.getBlock().getLocation(), toDrop);
                        amount -= 64;
                    }
                }
                catch (InvalidMechanismException e) {
                    if (e.getMessage() == null) break block9;
                    player.printError(e.getMessage());
                }
            }
        }
    }

    public static boolean removeBlocks(ChangedSign s, ChangedSign other, int amount) {
        if (s.getLine(0).equalsIgnoreCase("infinite")) {
            return true;
        }
        int curBlocks = CuboidToggleMechanic.getBlocks(s, other) - amount;
        if (s.getLine(0).contains(",")) {
            s.setLine(0, String.valueOf(curBlocks) + ',' + s.getLine(0).split(",")[1]);
        } else {
            s.setLine(0, String.valueOf(curBlocks));
        }
        s.update(false);
        return curBlocks >= 0;
    }

    public static boolean addBlocks(ChangedSign s, ChangedSign other, int amount) {
        if (s.getLine(0).equalsIgnoreCase("infinite")) {
            return true;
        }
        int curBlocks = CuboidToggleMechanic.getBlocks(s, other) + amount;
        if (s.getLine(0).contains(",")) {
            s.setLine(0, String.valueOf(curBlocks) + ',' + s.getLine(0).split(",")[1]);
        } else {
            s.setLine(0, String.valueOf(curBlocks));
        }
        s.update(false);
        return curBlocks >= 0;
    }

    public static void setBlocks(ChangedSign s, int amount) {
        if (s.getLine(0).split(",")[0].equalsIgnoreCase("infinite")) {
            return;
        }
        if (s.getLine(0).contains(",")) {
            s.setLine(0, String.valueOf(amount) + ',' + s.getLine(0).split(",")[1]);
        } else {
            s.setLine(0, String.valueOf(amount));
        }
        s.update(false);
    }

    public static int getBlocks(ChangedSign s, ChangedSign other) {
        if (s.getLine(0).split(",")[0].equalsIgnoreCase("infinite") || other != null && other.getLine(0).split(",")[0].equalsIgnoreCase("infinite")) {
            return 0;
        }
        int curBlocks = 0;
        try {
            curBlocks = Integer.parseInt(s.getLine(0).split(",")[0]);
            if (other != null && Objects.equals(CuboidToggleMechanic.getStoredType(other), CuboidToggleMechanic.getStoredType(s))) {
                try {
                    CuboidToggleMechanic.setBlocks(s, curBlocks += Integer.parseInt(other.getLine(0).split(",")[0]));
                    CuboidToggleMechanic.setBlocks(other, 0);
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception e) {
            curBlocks = 0;
        }
        return curBlocks;
    }

    public static boolean hasEnoughBlocks(ChangedSign s, ChangedSign other) {
        return s.getLine(0).split(",")[0].equalsIgnoreCase("infinite") || CuboidToggleMechanic.getBlocks(s, other) > 0;
    }

    public static BlockData getStoredType(ChangedSign sign) {
        if (sign.getLine(0).contains(",")) {
            return BlockSyntax.getBukkitBlock(sign.getLine(0).split(",")[1]);
        }
        return null;
    }

    public BlockData getBlockType(Block block) throws InvalidMechanismException {
        if (this.enforceType) {
            ChangedSign sign = CraftBookBukkitUtil.toChangedSign(block);
            BlockData type = null;
            if (sign.getLine(0).contains(",")) {
                type = BlockSyntax.getBukkitBlock(sign.getLine(0).split(",")[1]);
                BlockData realType = this.getBlockBase(block).getBlockData();
                if (type != null && realType.getMaterial() == type.getMaterial()) {
                    return realType;
                }
            }
            if (type == null) {
                type = this.getBlockBase(block).getBlockData();
                sign.setLine(0, sign.getLine(0) + ',' + BlockSyntax.toMinifiedId((BlockStateHolder)BukkitAdapter.adapt((BlockData)type).getBlockType().getFuzzyMatcher()));
                sign.update(false);
            }
            return type;
        }
        return this.getBlockBase(block).getBlockData();
    }

    @Override
    public void loadConfiguration(YAMLProcessor config, String path) {
        config.setComment(path + "enforce-type", "Allow doors to be toggled via redstone.");
        this.enforceType = config.getBoolean(path + "enforce-type", true);
    }
}

