/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics;

import com.sk89q.craftbook.AbstractCraftBookMechanic;
import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.CraftBookPlayer;
import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import com.sk89q.craftbook.bukkit.util.CraftBookBukkitUtil;
import com.sk89q.craftbook.util.BlockSyntax;
import com.sk89q.craftbook.util.EventUtil;
import com.sk89q.craftbook.util.InventoryUtil;
import com.sk89q.craftbook.util.ItemUtil;
import com.sk89q.craftbook.util.LocationUtil;
import com.sk89q.craftbook.util.ProtectionUtil;
import com.sk89q.craftbook.util.SignUtil;
import com.sk89q.craftbook.util.TernaryState;
import com.sk89q.craftbook.util.events.SelfTriggerPingEvent;
import com.sk89q.craftbook.util.events.SelfTriggerThinkEvent;
import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.util.HandSide;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockTypes;
import com.sk89q.worldedit.world.item.ItemTypes;
import java.util.ArrayList;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class XPStorer
extends AbstractCraftBookMechanic {
    private boolean requireBottle;
    private int xpPerBottle;
    private BlockStateHolder block;
    private TernaryState sneakingState;
    private boolean autonomousMode;
    private int radius;

    @EventHandler
    public void onRightClick(PlayerInteractEvent event) {
        float levelPercentage;
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK && event.getAction() != Action.RIGHT_CLICK_AIR) {
            return;
        }
        if (this.block.getBlockType() != BlockTypes.AIR && event.getAction() == Action.RIGHT_CLICK_AIR) {
            return;
        }
        if (this.block.getBlockType() != BlockTypes.AIR && !this.block.equalsFuzzy((BlockStateHolder)BukkitAdapter.adapt((BlockData)event.getClickedBlock().getBlockData()))) {
            return;
        }
        if (!EventUtil.passesFilter((Event)event) || event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        CraftBookPlayer player = CraftBookPlugin.inst().wrapPlayer(event.getPlayer());
        if (!this.sneakingState.doesPass(player.isSneaking()) || event.getPlayer().getLevel() < 1) {
            return;
        }
        int max = Integer.MAX_VALUE;
        if (this.requireBottle) {
            if (player.getItemInHand(HandSide.MAIN_HAND).getType() != ItemTypes.GLASS_BOTTLE && this.block.getBlockType() != BlockTypes.AIR) {
                player.printError("mech.xp-storer.bottle");
                return;
            }
            max = event.getPlayer().getInventory().getItemInMainHand().getAmount();
        }
        if (!player.hasPermission("craftbook.mech.xpstore.use")) {
            if (CraftBookPlugin.inst().getConfiguration().showPermissionMessages) {
                player.printError("mech.use-permission");
            }
            return;
        }
        if (event.getClickedBlock() != null && !ProtectionUtil.canUse(event.getPlayer(), event.getClickedBlock().getLocation(), event.getBlockFace(), event.getAction())) {
            if (CraftBookPlugin.inst().getConfiguration().showPermissionMessages) {
                player.printError("area.use-permissions");
            }
            return;
        }
        int xp = 0;
        float pcnt = event.getPlayer().getExp();
        int level = event.getPlayer().getLevel();
        CraftBookPlugin.logDebugMessage("Percent: " + pcnt + ". Level: " + level, "xpstorer");
        event.getPlayer().setExp(0.0f);
        CraftBookPlugin.logDebugMessage("XP: " + (xp += (int)((float)event.getPlayer().getExpToLevel() * pcnt)), "xpstorer");
        while (event.getPlayer().getLevel() > 0) {
            event.getPlayer().setLevel(event.getPlayer().getLevel() - 1);
            CraftBookPlugin.logDebugMessage("XP: " + (xp += event.getPlayer().getExpToLevel()) + ". Level: " + event.getPlayer().getLevel(), "xpstorer");
        }
        event.getPlayer().setLevel(level);
        event.getPlayer().setExp(pcnt);
        if (xp < this.xpPerBottle) {
            player.print("mech.xp-storer.not-enough-xp");
            return;
        }
        int bottleCount = (int)Math.min((double)max, Math.floor((double)xp / (double)this.xpPerBottle));
        CraftBookPlugin.logDebugMessage("Bottles: " + bottleCount, "xpstorer");
        if (this.requireBottle) {
            event.getPlayer().getInventory().removeItem(new ItemStack[]{new ItemStack(Material.GLASS_BOTTLE, bottleCount)});
        }
        for (int tempBottles = bottleCount; tempBottles > 0; tempBottles -= 64) {
            ItemStack bottles = new ItemStack(Material.EXPERIENCE_BOTTLE, Math.min(tempBottles, 64));
            if (event.getClickedBlock() == null) {
                for (ItemStack leftOver : event.getPlayer().getInventory().addItem(new ItemStack[]{bottles}).values()) {
                    event.getPlayer().getWorld().dropItemNaturally(event.getPlayer().getLocation(), leftOver);
                }
                continue;
            }
            event.getClickedBlock().getWorld().dropItemNaturally(event.getClickedBlock().getLocation(), bottles);
        }
        event.getPlayer().setLevel(0);
        event.getPlayer().setExp(0.0f);
        int remainingXP = xp - bottleCount * this.xpPerBottle;
        CraftBookPlugin.logDebugMessage("Leftover XP: " + remainingXP, "xpstorer");
        do {
            if ((levelPercentage = (float)remainingXP / (float)event.getPlayer().getExpToLevel()) > 1.0f) {
                remainingXP -= event.getPlayer().getExpToLevel();
                event.getPlayer().setLevel(event.getPlayer().getLevel() + 1);
                continue;
            }
            if (levelPercentage == 1.0f) {
                event.getPlayer().setLevel(event.getPlayer().getLevel() + 1);
                event.getPlayer().setExp(0.0f);
                remainingXP = 0;
                continue;
            }
            event.getPlayer().setExp(levelPercentage);
            remainingXP = 0;
        } while (levelPercentage > 1.0f);
        player.print("mech.xp-storer.success");
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onSignChange(SignChangeEvent event) {
        if (!this.autonomousMode) {
            return;
        }
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (!event.getLine(1).equalsIgnoreCase("[XP]") || !this.block.equalsFuzzy((BlockStateHolder)BukkitAdapter.adapt((BlockData)SignUtil.getBackBlock(event.getBlock()).getBlockData()))) {
            return;
        }
        CraftBookPlayer player = CraftBookPlugin.inst().wrapPlayer(event.getPlayer());
        if (!player.hasPermission("craftbook.mech.xpstore")) {
            if (CraftBookPlugin.inst().getConfiguration().showPermissionMessages) {
                player.printError("mech.create-permission");
            }
            SignUtil.cancelSign(event);
            return;
        }
        int signRadius = this.radius;
        try {
            signRadius = Math.max(this.radius, Integer.parseInt(event.getLine(2)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        event.setLine(1, "[XP]");
        event.setLine(2, String.valueOf(signRadius));
        player.print("mech.xp-storer.create");
        CraftBookPlugin.inst().getSelfTriggerManager().registerSelfTrigger(event.getBlock().getLocation());
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPing(SelfTriggerPingEvent event) {
        if (!this.autonomousMode) {
            return;
        }
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (!SignUtil.isSign(event.getBlock()) || !this.block.equalsFuzzy((BlockStateHolder)BukkitAdapter.adapt((BlockData)SignUtil.getBackBlock(event.getBlock()).getBlockData()))) {
            return;
        }
        ChangedSign sign = CraftBookBukkitUtil.toChangedSign(event.getBlock());
        if (!sign.getLine(1).equals("[XP]")) {
            return;
        }
        CraftBookPlugin.inst().getSelfTriggerManager().registerSelfTrigger(event.getBlock().getLocation());
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onThink(SelfTriggerThinkEvent event) {
        int bottleCount;
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (!SignUtil.isSign(event.getBlock())) {
            return;
        }
        ChangedSign sign = CraftBookBukkitUtil.toChangedSign(event.getBlock());
        if (!sign.getLine(1).equals("[XP]")) {
            return;
        }
        event.setHandled(true);
        int signRadius = this.radius;
        try {
            signRadius = Math.max(this.radius, Integer.parseInt(sign.getLine(2)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        int xp = 0;
        ArrayList<ExperienceOrb> orbs = new ArrayList<ExperienceOrb>();
        for (Entity entity : LocationUtil.getNearbyEntities(SignUtil.getBackBlock(event.getBlock()).getLocation(), Vector3.at((double)signRadius, (double)signRadius, (double)signRadius))) {
            if (!(entity instanceof ExperienceOrb) || entity.getTicksLived() <= 20) continue;
            xp += ((ExperienceOrb)entity).getExperience();
            orbs.add((ExperienceOrb)entity);
        }
        int max = Integer.MAX_VALUE;
        Inventory inventory = null;
        if (InventoryUtil.doesBlockHaveInventory(SignUtil.getBackBlock(event.getBlock()).getRelative(BlockFace.UP))) {
            inventory = ((InventoryHolder)SignUtil.getBackBlock(event.getBlock()).getRelative(BlockFace.UP).getState()).getInventory();
            if (this.requireBottle) {
                max = 0;
                for (ItemStack stack : inventory.getContents()) {
                    if (!ItemUtil.isStackValid(stack) || stack.getType() != Material.GLASS_BOTTLE) continue;
                    max += stack.getAmount();
                }
            }
        } else if (this.requireBottle) {
            return;
        }
        for (int tempBottles = bottleCount = (int)Math.min((double)max, Math.floor((double)xp / (double)this.xpPerBottle)); tempBottles > 0; tempBottles -= 64) {
            ItemStack bottles = new ItemStack(Material.EXPERIENCE_BOTTLE, Math.min(tempBottles, 64));
            if (inventory != null) {
                for (ItemStack leftover : inventory.addItem(new ItemStack[]{bottles}).values()) {
                    event.getBlock().getWorld().dropItemNaturally(LocationUtil.getCenterOfBlock(SignUtil.getBackBlock(event.getBlock())), leftover);
                }
                continue;
            }
            event.getBlock().getWorld().dropItemNaturally(LocationUtil.getCenterOfBlock(SignUtil.getBackBlock(event.getBlock())), bottles);
        }
        if (this.requireBottle && inventory != null) {
            inventory.removeItem(new ItemStack[]{new ItemStack(Material.GLASS_BOTTLE, bottleCount)});
        }
        int remainingXP = xp - bottleCount * this.xpPerBottle;
        for (ExperienceOrb orb : orbs) {
            if (remainingXP > 0) {
                orb.setExperience(Math.min(5, remainingXP));
                remainingXP -= 5;
                continue;
            }
            orb.remove();
        }
    }

    @Override
    public void loadConfiguration(YAMLProcessor config, String path) {
        config.setComment(path + "require-bottle", "Requires the player to be holding a glass bottle to use.");
        this.requireBottle = config.getBoolean(path + "require-bottle", false);
        config.setComment(path + "xp-per-bottle", "Sets the amount of XP points required per each bottle.");
        this.xpPerBottle = config.getInt(path + "xp-per-bottle", 16);
        config.setComment(path + "block", "The block that is an XP Storer.");
        this.block = BlockSyntax.getBlock(config.getString(path + "block", BlockTypes.SPAWNER.getId()), true);
        config.setComment(path + "require-sneaking-state", "Sets how the player must be sneaking in order to use the XP Storer.");
        this.sneakingState = TernaryState.getFromString(config.getString(path + "require-sneaking-state", "no"));
        config.setComment(path + "radius-mode", "Allows XP Storer mechanics with a sign attached to work in a radius.");
        this.autonomousMode = config.getBoolean(path + "radius-mode", false);
        config.setComment(path + "radius", "The radius for radius-mode.");
        this.radius = config.getInt(path + "radius", 5);
    }
}

