/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics;

import com.sk89q.craftbook.AbstractCraftBookMechanic;
import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.CraftBookPlayer;
import com.sk89q.craftbook.bukkit.BukkitCraftBookPlayer;
import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import com.sk89q.craftbook.bukkit.util.CraftBookBukkitUtil;
import com.sk89q.craftbook.util.EventUtil;
import com.sk89q.craftbook.util.ParsingUtil;
import com.sk89q.craftbook.util.ProtectionUtil;
import com.sk89q.craftbook.util.RegexUtil;
import com.sk89q.craftbook.util.SignUtil;
import com.sk89q.craftbook.util.events.SignClickEvent;
import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Directional;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;

public class Teleporter
extends AbstractCraftBookMechanic {
    private boolean requireSign;
    private int maxRange;

    @EventHandler(priority=EventPriority.HIGH)
    public void onSignChange(SignChangeEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (!event.getLine(1).equalsIgnoreCase("[Teleporter]")) {
            return;
        }
        CraftBookPlayer localPlayer = CraftBookPlugin.inst().wrapPlayer(event.getPlayer());
        if (!localPlayer.hasPermission("craftbook.mech.teleporter")) {
            if (CraftBookPlugin.inst().getConfiguration().showPermissionMessages) {
                localPlayer.printError("mech.create-permission");
            }
            SignUtil.cancelSign(event);
            return;
        }
        String[] pos = RegexUtil.COLON_PATTERN.split(ParsingUtil.parseLine(event.getLine(2), event.getPlayer()));
        if (pos.length <= 2) {
            localPlayer.printError("mech.teleport.invalidcoords");
            SignUtil.cancelSign(event);
            return;
        }
        localPlayer.print("mech.teleport.create");
        event.setLine(1, "[Teleporter]");
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onRightClick(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (SignUtil.isSign(event.getClickedBlock())) {
            return;
        }
        this.onCommonClick(event);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onRightClick(SignClickEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        this.onCommonClick(event);
    }

    public void onCommonClick(PlayerInteractEvent event) {
        if (!EventUtil.passesFilter((Event)event) || event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        CraftBookPlayer localPlayer = CraftBookPlugin.inst().wrapPlayer(event.getPlayer());
        Block trigger = null;
        if (SignUtil.isSign(event.getClickedBlock())) {
            ChangedSign s = CraftBookBukkitUtil.toChangedSign(event.getClickedBlock());
            if (!s.getLine(1).equals("[Teleporter]")) {
                return;
            }
            String[] pos = RegexUtil.COLON_PATTERN.split(s.getLine(2));
            if (pos.length <= 2) {
                localPlayer.printError("mech.teleport.invalidcoords");
                return;
            }
            trigger = event.getClickedBlock();
        } else if (Tag.BUTTONS.isTagged((Keyed)event.getClickedBlock().getType())) {
            Directional b = (Directional)event.getClickedBlock().getBlockData();
            if (b == null || b.getFacing() == null) {
                return;
            }
            Block sign = event.getClickedBlock().getRelative(b.getFacing().getOppositeFace(), 2);
            if (SignUtil.isSign(sign)) {
                ChangedSign s = CraftBookBukkitUtil.toChangedSign(sign);
                if (!s.getLine(1).equals("[Teleporter]")) {
                    return;
                }
                String[] pos = RegexUtil.COLON_PATTERN.split(s.getLine(2));
                if (pos.length <= 2) {
                    localPlayer.printError("mech.teleport.invalidcoords");
                    return;
                }
                trigger = sign;
            }
        } else {
            return;
        }
        if (trigger == null) {
            return;
        }
        if (!localPlayer.hasPermission("craftbook.mech.teleporter.use")) {
            if (CraftBookPlugin.inst().getConfiguration().showPermissionMessages) {
                localPlayer.printError("mech.use-permission");
            }
            return;
        }
        if (!ProtectionUtil.canUse(event.getPlayer(), event.getClickedBlock().getLocation(), event.getBlockFace(), event.getAction())) {
            if (CraftBookPlugin.inst().getConfiguration().showPermissionMessages) {
                localPlayer.printError("area.use-permissions");
            }
            return;
        }
        this.makeItSo(localPlayer, trigger);
        event.setCancelled(true);
    }

    private void makeItSo(CraftBookPlayer player, Block trigger) {
        Block floor;
        double toX = 0.0;
        double toY = 0.0;
        double toZ = 0.0;
        if (SignUtil.isSign(trigger)) {
            ChangedSign s = CraftBookBukkitUtil.toChangedSign(trigger);
            String[] pos = RegexUtil.COLON_PATTERN.split(s.getLine(2));
            if (pos.length > 2) {
                try {
                    toX = Double.parseDouble(pos[0]);
                    toY = Double.parseDouble(pos[1]);
                    toZ = Double.parseDouble(pos[2]);
                }
                catch (Exception e) {
                    player.printError("mech.teleport.arriveonly");
                    return;
                }
            } else {
                player.printError("mech.teleport.arriveonly");
                return;
            }
        }
        if (this.requireSign) {
            Block location = trigger.getWorld().getBlockAt((int)toX, (int)toY, (int)toZ);
            if (SignUtil.isSign(location)) {
                if (!Teleporter.checkTeleportSign(player, location)) {
                    return;
                }
            } else if (Tag.BUTTONS.isTagged((Keyed)location.getType())) {
                Directional b = (Directional)location.getBlockData();
                Block sign = location.getRelative(b.getFacing(), 2);
                if (!Teleporter.checkTeleportSign(player, sign)) {
                    return;
                }
            } else {
                player.printError("mech.teleport.sign");
                return;
            }
        }
        if ((floor = trigger.getWorld().getBlockAt((int)Math.floor(toX), (int)(Math.floor(toY) + 1.0), (int)Math.floor(toZ))).getType().isSolid()) {
            floor = floor.getRelative(BlockFace.DOWN);
        }
        int foundFree = 0;
        for (int i = 0; i < 5 && (!floor.getType().isSolid() || SignUtil.isSign(floor)); ++i) {
            ++foundFree;
            if (floor.getY() == 0) break;
            floor = floor.getRelative(BlockFace.DOWN);
        }
        if (foundFree < 2) {
            player.printError("mech.teleport.obstruct");
            return;
        }
        com.sk89q.worldedit.util.Location subspaceRift = player.getLocation();
        subspaceRift = subspaceRift.setX((double)floor.getX() + 0.5);
        subspaceRift = subspaceRift.setY((double)floor.getY() + 1.0);
        subspaceRift = subspaceRift.setZ((double)floor.getZ() + 0.5);
        if (player.isInsideVehicle()) {
            subspaceRift = BukkitAdapter.adapt((Location)((BukkitCraftBookPlayer)player).getPlayer().getVehicle().getLocation());
            subspaceRift = subspaceRift.setX((double)floor.getX() + 0.5);
            subspaceRift = subspaceRift.setY((double)floor.getY() + 2.0);
            subspaceRift = subspaceRift.setZ((double)floor.getZ() + 0.5);
            ((BukkitCraftBookPlayer)player).getPlayer().getVehicle().teleport(CraftBookBukkitUtil.toLocation(subspaceRift));
        }
        if (this.maxRange > 0 && subspaceRift.toVector().distanceSq(player.getLocation().toVector()) > (double)(this.maxRange * this.maxRange)) {
            player.print("mech.teleport.range");
            return;
        }
        player.teleport(subspaceRift);
        player.print("mech.teleport.alert");
    }

    private static boolean checkTeleportSign(CraftBookPlayer player, Block sign) {
        if (!SignUtil.isSign(sign)) {
            player.printError("mech.teleport.sign");
            return false;
        }
        ChangedSign s = CraftBookBukkitUtil.toChangedSign(sign);
        if (!s.getLine(1).equals("[Teleporter]")) {
            player.printError("mech.teleport.sign");
            return false;
        }
        return true;
    }

    @Override
    public void loadConfiguration(YAMLProcessor config, String path) {
        config.setComment(path + "require-sign", "Require a sign to be at the destination of the teleportation.");
        this.requireSign = config.getBoolean(path + "require-sign", false);
        config.setComment(path + "max-range", "The maximum distance between the start and end of a teleporter. Set to 0 for infinite.");
        this.maxRange = config.getInt(path + "max-range", 0);
    }
}

