/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics;

import com.sk89q.craftbook.AbstractCraftBookMechanic;
import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import com.sk89q.craftbook.util.BlockUtil;
import com.sk89q.craftbook.util.EventUtil;
import com.sk89q.craftbook.util.LocationUtil;
import com.sk89q.craftbook.util.events.SourcedBlockRedstoneEvent;
import com.sk89q.util.yaml.YAMLProcessor;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.plugin.Plugin;

public class Sponge
extends AbstractCraftBookMechanic {
    private int radius;
    private boolean circularRadius;
    private boolean redstone;
    private boolean includeWet;

    private boolean isValidSponge(Block block) {
        return block.getType() == Material.SPONGE || this.includeWet && block.getType() == Material.WET_SPONGE;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockFromTo(BlockFromToEvent event) {
        if (event.getBlock().getType() != Material.WATER) {
            return;
        }
        if (!BlockUtil.isBlockReplacable(event.getToBlock().getType())) {
            return;
        }
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        for (int cx = -this.radius; cx <= this.radius; ++cx) {
            for (int cy = -this.radius; cy <= this.radius; ++cy) {
                for (int cz = -this.radius; cz <= this.radius; ++cz) {
                    Block sponge = event.getToBlock().getRelative(cx, cy, cz);
                    if (this.circularRadius && !LocationUtil.isWithinSphericalRadius(sponge.getLocation(), event.getToBlock().getLocation(), this.radius) || this.redstone && !sponge.isBlockIndirectlyPowered() || !this.isValidSponge(sponge)) continue;
                    event.setCancelled(true);
                    return;
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockPlace(BlockPlaceEvent event) {
        if (!this.isValidSponge(event.getBlock())) {
            return;
        }
        if (this.redstone && !event.getBlock().isBlockIndirectlyPowered()) {
            return;
        }
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        this.removeWater(event.getBlock());
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockBreak(BlockBreakEvent event) {
        if (!this.isValidSponge(event.getBlock())) {
            return;
        }
        if (this.redstone && !event.getBlock().isBlockIndirectlyPowered()) {
            return;
        }
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        Bukkit.getScheduler().runTask((Plugin)CraftBookPlugin.inst(), () -> this.addWater(event.getBlock()));
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onRedstoneChange(SourcedBlockRedstoneEvent event) {
        if (!this.redstone) {
            return;
        }
        if (!this.isValidSponge(event.getBlock())) {
            return;
        }
        if (event.isMinor()) {
            return;
        }
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (!event.isOn()) {
            this.addWater(event.getBlock());
        } else {
            this.removeWater(event.getBlock());
        }
    }

    public void removeWater(Block block) {
        for (int cx = -this.radius; cx <= this.radius; ++cx) {
            for (int cy = -this.radius; cy <= this.radius; ++cy) {
                for (int cz = -this.radius; cz <= this.radius; ++cz) {
                    Block water = block.getRelative(cx, cy, cz);
                    if (this.circularRadius && !LocationUtil.isWithinSphericalRadius(water.getLocation(), block.getLocation(), this.radius) || water.getType() != Material.WATER) continue;
                    water.setType(Material.AIR);
                }
            }
        }
    }

    public void addWater(Block block) {
        BlockFromToEvent event;
        Block water;
        int cz;
        int cy;
        int cx = block.getX() - this.radius - 1;
        for (cy = block.getY() - this.radius - 1; cy <= block.getY() + this.radius + 1; ++cy) {
            for (cz = block.getZ() - this.radius - 1; cz <= block.getZ() + this.radius + 1; ++cz) {
                water = block.getWorld().getBlockAt(cx, cy, cz);
                if (this.circularRadius && !LocationUtil.isWithinSphericalRadius(water.getLocation(), block.getLocation(), (double)this.radius + 1.5) || water.getType() != Material.WATER || !BlockUtil.isBlockReplacable(water.getRelative(1, 0, 0).getType())) continue;
                event = new BlockFromToEvent(water, water.getRelative(1, 0, 0));
                Bukkit.getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) continue;
                water.getRelative(1, 0, 0).setType(Material.WATER);
            }
        }
        cx = block.getX() + this.radius + 1;
        for (cy = block.getY() - this.radius - 1; cy <= block.getY() + this.radius + 1; ++cy) {
            for (cz = block.getZ() - this.radius - 1; cz <= block.getZ() + this.radius + 1; ++cz) {
                water = block.getWorld().getBlockAt(cx, cy, cz);
                if (this.circularRadius && !LocationUtil.isWithinSphericalRadius(water.getLocation(), block.getLocation(), (double)this.radius + 1.5) || water.getType() != Material.WATER || !BlockUtil.isBlockReplacable(water.getRelative(-1, 0, 0).getType())) continue;
                event = new BlockFromToEvent(water, water.getRelative(-1, 0, 0));
                Bukkit.getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) continue;
                water.getRelative(-1, 0, 0).setType(Material.WATER);
            }
        }
        cy = block.getY() + this.radius + 1;
        for (cx = block.getX() - this.radius - 1; cx <= block.getX() + this.radius + 1; ++cx) {
            for (cz = block.getZ() - this.radius - 1; cz <= block.getZ() + this.radius + 1; ++cz) {
                water = block.getWorld().getBlockAt(cx, cy, cz);
                if (this.circularRadius && !LocationUtil.isWithinSphericalRadius(water.getLocation(), block.getLocation(), (double)this.radius + 1.5) || water.getType() != Material.WATER || !BlockUtil.isBlockReplacable(water.getRelative(0, -1, 0).getType())) continue;
                event = new BlockFromToEvent(water, water.getRelative(0, -1, 0));
                Bukkit.getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) continue;
                water.getRelative(0, -1, 0).setType(Material.WATER);
            }
        }
        cz = block.getZ() - this.radius - 1;
        for (cx = block.getX() - this.radius - 1; cx <= block.getX() + this.radius + 1; ++cx) {
            for (cy = block.getY() - this.radius - 1; cy <= block.getY() + this.radius + 1; ++cy) {
                water = block.getWorld().getBlockAt(cx, cy, cz);
                if (this.circularRadius && !LocationUtil.isWithinSphericalRadius(water.getLocation(), block.getLocation(), (double)this.radius + 1.5) || water.getType() != Material.WATER || !BlockUtil.isBlockReplacable(water.getRelative(0, 0, 1).getType())) continue;
                event = new BlockFromToEvent(water, water.getRelative(0, 0, 1));
                Bukkit.getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) continue;
                water.getRelative(0, 0, 1).setType(Material.WATER);
            }
        }
        cz = block.getZ() + this.radius + 1;
        for (cx = block.getX() - this.radius - 1; cx <= block.getX() + this.radius + 1; ++cx) {
            for (cy = block.getY() - this.radius - 1; cy <= block.getY() + this.radius + 1; ++cy) {
                water = block.getWorld().getBlockAt(cx, cy, cz);
                if (this.circularRadius && !LocationUtil.isWithinSphericalRadius(water.getLocation(), block.getLocation(), (double)this.radius + 1.5) || water.getType() != Material.WATER || !BlockUtil.isBlockReplacable(water.getRelative(0, 0, -1).getType())) continue;
                event = new BlockFromToEvent(water, water.getRelative(0, 0, -1));
                Bukkit.getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) continue;
                water.getRelative(0, 0, -1).setType(Material.WATER);
            }
        }
    }

    @Override
    public void loadConfiguration(YAMLProcessor config, String path) {
        config.setComment(path + "radius", "The maximum radius of the sponge.");
        this.radius = config.getInt(path + "radius", 5);
        config.setComment(path + "circular-radius", "Whether the radius should be circular or square.");
        this.circularRadius = config.getBoolean(path + "circular-radius", true);
        config.setComment(path + "require-redstone", "Whether to require redstone to suck up water or not.");
        this.redstone = config.getBoolean(path + "require-redstone", false);
        config.setComment(path + "include-wet", "Whether to include wet sponges or not.");
        this.includeWet = config.getBoolean(path + "include-wet", false);
    }
}

