/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.sk89q.craftbook.AbstractCraftBookMechanic;
import com.sk89q.craftbook.CraftBookPlayer;
import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import com.sk89q.craftbook.util.BlockSyntax;
import com.sk89q.craftbook.util.BlockUtil;
import com.sk89q.craftbook.util.EventUtil;
import com.sk89q.craftbook.util.LocationUtil;
import com.sk89q.craftbook.util.ProtectionUtil;
import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.worldedit.blocks.Blocks;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Slab;
import org.bukkit.block.data.type.Stairs;
import org.bukkit.entity.Player;
import org.bukkit.entity.Snowball;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.BlockVector;

public class Snow
extends AbstractCraftBookMechanic {
    private static final BlockFace[] UPDATE_FACES = new BlockFace[]{BlockFace.UP, BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST};
    private Set<SnowBlock> queue = new HashSet<SnowBlock>();
    private boolean piling;
    private boolean trample;
    private boolean partialTrample;
    private boolean place;
    private boolean slowdown;
    private boolean realistic;
    private boolean pileHigh;
    private int maxPileHeight;
    private boolean jumpTrample;
    private List<BaseBlock> realisticReplacables;
    private int animationTicks;
    private boolean freezeWater;
    private boolean meltSunlight;
    private boolean meltPartial;
    private boolean animateFalling;

    @Override
    public boolean enable() {
        if (this.meltSunlight || this.piling) {
            for (World world : Bukkit.getWorlds()) {
                for (Chunk chunk : world.getLoadedChunks()) {
                    boolean isChunkUseful = false;
                    block2: for (int x = 0; x < 16; ++x) {
                        for (int z = 0; z < 16; ++z) {
                            if (!(chunk.getBlock(x, world.getMaxHeight() - 1, z).getTemperature() < 0.15)) continue;
                            isChunkUseful = true;
                            continue block2;
                        }
                    }
                    if (!isChunkUseful) continue;
                    Bukkit.getScheduler().runTaskLater((Plugin)CraftBookPlugin.inst(), (Runnable)new SnowChunkHandler(chunk), Snow.getRandomDelay() * 20L);
                }
            }
        }
        return true;
    }

    private boolean canLandOn(Block block) {
        switch (block.getType()) {
            case CAKE: 
            case DAYLIGHT_DETECTOR: 
            case REPEATER: 
            case COMPARATOR: 
            case TORCH: 
            case AIR: {
                return false;
            }
        }
        if (Tag.STAIRS.isTagged((Keyed)block.getType())) {
            return ((Stairs)block.getBlockData()).getHalf() == Bisected.Half.TOP;
        }
        if (Tag.SLABS.isTagged((Keyed)block.getType())) {
            return ((Slab)block.getBlockData()).getType() != Slab.Type.BOTTOM;
        }
        if (Tag.CARPETS.isTagged((Keyed)block.getType()) || Tag.RAILS.isTagged((Keyed)block.getType()) || Tag.SAPLINGS.isTagged((Keyed)block.getType())) {
            return false;
        }
        return (this.freezeWater || block.getType() != Material.WATER) && !this.isReplacable(block);
    }

    private boolean isReplacable(Block block) {
        return block.getType() != Material.WATER && (BlockUtil.isBlockReplacable(block.getType()) || Blocks.containsFuzzy(this.realisticReplacables, (BlockStateHolder)BukkitAdapter.adapt((BlockData)block.getBlockData())));
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onSnowballHit(ProjectileHitEvent event) {
        if (!this.place) {
            return;
        }
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (event.getEntity() instanceof Snowball) {
            Block block = event.getEntity().getLocation().getBlock();
            if (event.getEntity().getShooter() != null && event.getEntity().getShooter() instanceof Player) {
                if (CraftBookPlugin.inst().getConfiguration().pedanticBlockChecks && !ProtectionUtil.canBuild((Player)event.getEntity().getShooter(), block.getLocation(), true)) {
                    return;
                }
                CraftBookPlayer player = CraftBookPlugin.inst().wrapPlayer((Player)event.getEntity().getShooter());
                if (!player.hasPermission("craftbook.mech.snow.place")) {
                    return;
                }
            }
            Bukkit.getScheduler().runTask((Plugin)CraftBookPlugin.inst(), (Runnable)new SnowHandler(block, 1));
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockPlace(BlockPlaceEvent event) {
        if (!this.realistic) {
            return;
        }
        if (event.getBlock().getType() != Material.SNOW) {
            return;
        }
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        Bukkit.getScheduler().runTask((Plugin)CraftBookPlugin.inst(), (Runnable)new SnowHandler(event.getBlock(), 0));
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerMove(PlayerMoveEvent event) {
        if (!this.trample && !this.slowdown) {
            return;
        }
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        CraftBookPlayer player = CraftBookPlugin.inst().wrapPlayer(event.getPlayer());
        if (event.getTo().getBlock().getType() == Material.SNOW) {
            org.bukkit.block.data.type.Snow levelled = (org.bukkit.block.data.type.Snow)event.getTo().getBlock().getBlockData();
            if (this.slowdown) {
                if (levelled.getLayers() > 4) {
                    event.getPlayer().addPotionEffect(new PotionEffect(PotionEffectType.SLOW, 20, 2), true);
                } else if (levelled.getLayers() > levelled.getMinimumLayers()) {
                    event.getPlayer().addPotionEffect(new PotionEffect(PotionEffectType.SLOW, 20, 1), true);
                }
            }
            if (this.trample) {
                if (this.jumpTrample && !(event.getFrom().getY() - event.getTo().getY() >= 0.1)) {
                    return;
                }
                if (CraftBookPlugin.inst().getRandom().nextInt(20) == 0) {
                    if (levelled.getLayers() == levelled.getMinimumLayers() && this.partialTrample) {
                        return;
                    }
                    if (!player.hasPermission("craftbook.mech.snow.trample")) {
                        return;
                    }
                    if (CraftBookPlugin.inst().getConfiguration().pedanticBlockChecks && !ProtectionUtil.canBuild(event.getPlayer(), event.getPlayer().getLocation(), false)) {
                        return;
                    }
                    Bukkit.getScheduler().runTask((Plugin)CraftBookPlugin.inst(), (Runnable)new SnowHandler(event.getTo().getBlock(), -1));
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockBreak(BlockBreakEvent event) {
        if (event.getBlock().getType() == Material.SNOW) {
            if (!EventUtil.passesFilter((Event)event)) {
                return;
            }
            event.setCancelled(true);
            event.getBlock().setType(Material.AIR, false);
            for (ItemStack itemStack : BlockUtil.getBlockDrops(event.getBlock(), event.getPlayer().getInventory().getItemInMainHand())) {
                event.getBlock().getWorld().dropItemNaturally(BlockUtil.getBlockCentre(event.getBlock()), itemStack);
            }
            if (this.realistic) {
                for (ItemStack itemStack : UPDATE_FACES) {
                    Bukkit.getScheduler().runTaskLater((Plugin)CraftBookPlugin.inst(), (Runnable)new SnowHandler(event.getBlock().getRelative((BlockFace)itemStack), 0, event.getBlock().getLocation().toVector().toBlockVector()), (long)this.animationTicks);
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPhysicsUpdate(BlockPhysicsEvent event) {
        if (!this.realistic) {
            return;
        }
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if ((event.getBlock().getType() == Material.SNOW || event.getBlock().getType() == Material.SNOW_BLOCK) && CraftBookPlugin.inst().getRandom().nextInt(10) == 0) {
            Bukkit.getScheduler().runTaskLater((Plugin)CraftBookPlugin.inst(), (Runnable)new SnowHandler(event.getBlock(), 0), (long)this.animationTicks);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onChunkLoad(ChunkLoadEvent event) {
        if (!this.piling) {
            return;
        }
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        boolean isChunkUseful = false;
        block0: for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                if (!this.meltSunlight && !(event.getChunk().getBlock(x, event.getWorld().getMaxHeight() - 1, z).getTemperature() < 0.15)) continue;
                isChunkUseful = true;
                continue block0;
            }
        }
        if (!isChunkUseful) {
            return;
        }
        Bukkit.getScheduler().runTaskLater((Plugin)CraftBookPlugin.inst(), (Runnable)new SnowChunkHandler(event.getChunk()), Snow.getRandomDelay() * (event.getWorld().hasStorm() ? 20L : 10L));
    }

    private static long getRandomDelay() {
        return CraftBookPlugin.inst().getRandom().nextInt(4) + 1;
    }

    private static List<String> getDefaultReplacables() {
        return Lists.newArrayList((Object[])new String[]{BlockTypes.DEAD_BUSH.getId(), BlockTypes.GRASS.getId(), BlockTypes.DANDELION.getId(), BlockTypes.POPPY.getId(), BlockTypes.BROWN_MUSHROOM.getId(), BlockTypes.RED_MUSHROOM.getId(), BlockTypes.FIRE.getId(), BlockTypes.FERN.getId()});
    }

    @Override
    public void loadConfiguration(YAMLProcessor config, String path) {
        config.setComment(path + "piling", "Enables the piling feature of the Snow mechanic.");
        this.piling = config.getBoolean(path + "piling", false);
        config.setComment(path + "trample", "Enables the trampling feature of the Snow mechanic.");
        this.trample = config.getBoolean(path + "trample", false);
        config.setComment(path + "partial-trample-only", "If trampling is enabled, only trample it down to the smallest snow.");
        this.partialTrample = config.getBoolean(path + "partial-trample-only", false);
        config.setComment(path + "jump-trample", "Require jumping to trample snow.");
        this.jumpTrample = config.getBoolean(path + "jump-trample", false);
        config.setComment(path + "place", "Allow snowballs to create snow when they land.");
        this.place = config.getBoolean(path + "place", false);
        config.setComment(path + "slowdown", "Slows down entities as they walk through thick snow.");
        this.slowdown = config.getBoolean(path + "slowdown", false);
        config.setComment(path + "realistic", "Realistically move snow around, creating an 'avalanche' or 'mound' effect.");
        this.realistic = config.getBoolean(path + "realistic", false);
        config.setComment(path + "high-piling", "Allow piling above the 1 block height.");
        this.pileHigh = config.getBoolean(path + "high-piling", false);
        config.setComment(path + "max-pile-height", "The maximum piling height of high piling snow.");
        this.maxPileHeight = config.getInt(path + "max-pile-height", 3);
        config.setComment(path + "replacable-blocks", "A list of blocks that can be replaced by realistic snow.");
        this.realisticReplacables = BlockSyntax.getBlocks(config.getStringList(path + "replacable-blocks", Snow.getDefaultReplacables()), true);
        config.setComment(path + "animate-falling", "Cause the snow to fall slowly (May be intensive).");
        this.animateFalling = config.getBoolean(path + "animate-falling", false);
        config.setComment(path + "falldown-animation-speed", "The animation delay of all snow interactions in ticks.");
        this.animationTicks = config.getInt(path + "falldown-animation-speed", 5);
        config.setComment(path + "freeze-water", "Should snow freeze water?");
        this.freezeWater = config.getBoolean(path + "freeze-water", false);
        config.setComment(path + "melt-in-sunlight", "Enables snow to melt in sunlight.");
        this.meltSunlight = config.getBoolean(path + "melt-in-sunlight", false);
        config.setComment(path + "partial-melt-only", "If melt in sunlight is enabled, only melt it down to the smallest snow.");
        this.meltPartial = config.getBoolean(path + "partial-melt-only", false);
    }

    private static class SnowBlock {
        int x;
        int y;
        int z;
        char[] worldname;

        SnowBlock(String worldname, int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.worldname = worldname.toCharArray();
        }

        public boolean equals(Object o) {
            return o instanceof SnowBlock && ((SnowBlock)o).x == this.x && ((SnowBlock)o).y == this.y && ((SnowBlock)o).z == this.z && Arrays.equals(((SnowBlock)o).worldname, this.worldname);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.worldname, this.x, this.y, this.z});
        }
    }

    private class SnowHandler
    implements Runnable {
        Block block;
        SnowBlock snowblock;
        int amount;
        BlockVector from;

        SnowHandler(Block block, int amount) {
            this.snowblock = new SnowBlock(block.getWorld().getName(), block.getX(), block.getY(), block.getZ());
            if (Snow.this.queue.contains(this.snowblock)) {
                this.snowblock = null;
                return;
            }
            this.block = block;
            this.amount = amount;
            Snow.this.queue.add(this.snowblock);
        }

        SnowHandler(Block block, int amount, BlockVector from) {
            this(block, amount);
            this.from = from;
        }

        @Override
        public void run() {
            if (this.snowblock == null || !Snow.this.queue.contains(this.snowblock)) {
                return;
            }
            Snow.this.queue.remove(this.snowblock);
            if (this.amount == 0) {
                if (Snow.this.realistic && !this.disperse(this.block) && !Snow.this.canLandOn(this.block.getRelative(0, -1, 0))) {
                    this.decreaseSnow(this.block, false);
                }
            } else if (this.amount < 0) {
                if (this.decreaseSnow(this.block, true)) {
                    ++this.amount;
                }
                if (this.amount < 0) {
                    Bukkit.getScheduler().runTaskLater((Plugin)CraftBookPlugin.inst(), (Runnable)new SnowHandler(this.block, this.amount), (long)Snow.this.animationTicks);
                }
            } else {
                if (this.increaseSnow(this.block, Snow.this.realistic)) {
                    --this.amount;
                }
                if (this.amount > 0) {
                    Bukkit.getScheduler().runTaskLater((Plugin)CraftBookPlugin.inst(), (Runnable)new SnowHandler(this.block, this.amount), (long)Snow.this.animationTicks);
                }
            }
        }

        boolean disperse(Block snow) {
            if (!Snow.this.realistic) {
                return false;
            }
            LinkedList<BlockFace> faces = new LinkedList<BlockFace>(Arrays.asList(BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST));
            if (snow.getType() == Material.SNOW && Snow.this.canLandOn(snow.getRelative(0, -2, 0)) && Snow.this.isReplacable(snow.getRelative(0, -1, 0))) {
                faces = new LinkedList<BlockFace>(Collections.singletonList(BlockFace.DOWN));
            } else {
                Collections.shuffle(faces, CraftBookPlugin.inst().getRandom());
                faces.add(0, BlockFace.DOWN);
            }
            BlockFace best = null;
            int bestDiff = 0;
            for (BlockFace dir : faces) {
                int diff;
                Block block = snow.getRelative(dir);
                if (this.from != null && block.getLocation().getBlockX() == this.from.getBlockX() && block.getLocation().getBlockY() == this.from.getBlockY() && block.getLocation().getBlockZ() == this.from.getBlockZ() || !Snow.this.isReplacable(block) || Snow.this.queue.contains(new SnowBlock(block.getWorld().getName(), block.getX(), block.getY(), block.getZ()))) continue;
                if (block.getType() == Material.SNOW && snow.getType() == Material.SNOW && block.getData() >= snow.getData() && dir != BlockFace.DOWN && dir != BlockFace.UP) {
                    if (block.getData() <= snow.getData() + 1) continue;
                    Bukkit.getScheduler().runTaskLater((Plugin)CraftBookPlugin.inst(), (Runnable)new SnowHandler(block, 0, snow.getLocation().toVector().toBlockVector()), (long)Snow.this.animationTicks);
                    continue;
                }
                if (Snow.this.isReplacable(block) && snow.getType() == Material.SNOW && (snow.getData() == 0 || block.getType() == Material.SNOW && block.getData() == snow.getData() - 1) && dir != BlockFace.DOWN && dir != BlockFace.UP && Snow.this.canLandOn(block.getRelative(0, -1, 0)) && CraftBookPlugin.inst().getRandom().nextInt(10) != 0) continue;
                if (block.getType() == Material.SNOW) {
                    if (snow.getData() == 2 && block.getData() == 1 && dir != BlockFace.DOWN) continue;
                    diff = snow.getData() - block.getData();
                } else {
                    int n = diff = block.getType() == Material.AIR ? 100 : 99;
                }
                if (diff <= bestDiff && dir != BlockFace.DOWN) continue;
                best = dir;
                bestDiff = diff;
                if (dir != BlockFace.DOWN) continue;
                break;
            }
            if (best != null) {
                Block block = snow.getRelative(best);
                if (snow.getLocation().equals((Object)block.getLocation())) {
                    return false;
                }
                boolean success = false;
                if (this.amount < 0) {
                    if (this.decreaseSnow(block, false)) {
                        success = this.increaseSnow(snow, true);
                    }
                } else if (this.decreaseSnow(snow, false)) {
                    success = this.increaseSnow(block, true);
                }
                return success;
            }
            return false;
        }

        boolean increaseSnow(Block snow, boolean disperse) {
            Block below;
            if (!Snow.this.animateFalling) {
                while (snow.getRelative(0, -1, 0).getType() == Material.AIR) {
                    snow = snow.getRelative(0, -1, 0);
                }
            }
            if ((below = snow.getRelative(0, -1, 0)).getType() != Material.AIR && Snow.this.isReplacable(below) && (below.getType() != Material.SNOW || below.getData() < 7)) {
                return this.increaseSnow(below, disperse);
            }
            if (Snow.this.freezeWater && below.getType() == Material.WATER) {
                if (below.getData() == 0) {
                    BlockState state = below.getState();
                    state.setType(Material.ICE);
                    if (ProtectionUtil.canBlockForm(state.getBlock(), state)) {
                        below.setType(Material.ICE);
                    }
                } else {
                    below.setType(Material.AIR);
                }
            } else if (below.getType() == Material.WATER) {
                return true;
            }
            if (snow.getType() != Material.SNOW && snow.getType() != Material.SNOW_BLOCK) {
                if (below.getType() == Material.SNOW_BLOCK) {
                    boolean allowed = false;
                    if (Snow.this.pileHigh) {
                        for (int i = 0; i < Snow.this.maxPileHeight + 1; ++i) {
                            if (below.getRelative(0, -i, 0).getType() == Material.SNOW_BLOCK) continue;
                            allowed = true;
                            break;
                        }
                    }
                    if (!allowed) {
                        return false;
                    }
                }
                if (Snow.this.isReplacable(snow)) {
                    snow.setType(Material.SNOW, false);
                    if (disperse) {
                        Bukkit.getScheduler().runTaskLater((Plugin)CraftBookPlugin.inst(), (Runnable)new SnowHandler(snow, 0, this.from), (long)Snow.this.animationTicks);
                    }
                    return true;
                }
                return false;
            }
            org.bukkit.block.data.type.Snow snowData = (org.bukkit.block.data.type.Snow)snow.getBlockData();
            if (snowData.getLayers() + 1 > snowData.getMaximumLayers()) {
                if (Snow.this.pileHigh) {
                    boolean allowed = false;
                    for (int i = 0; i < Snow.this.maxPileHeight + 1; ++i) {
                        if (below.getRelative(0, -i, 0).getType() == Material.SNOW_BLOCK) continue;
                        allowed = true;
                        break;
                    }
                    if (allowed) {
                        snow.setType(Material.SNOW_BLOCK);
                        if (disperse) {
                            Bukkit.getScheduler().runTaskLater((Plugin)CraftBookPlugin.inst(), (Runnable)new SnowHandler(snow, 0, this.from), (long)Snow.this.animationTicks);
                        }
                        return true;
                    }
                    return false;
                }
                return false;
            }
            snowData.setLayers(snowData.getLayers() + 1);
            snow.setBlockData((BlockData)snowData);
            if (disperse) {
                Bukkit.getScheduler().runTaskLater((Plugin)CraftBookPlugin.inst(), (Runnable)new SnowHandler(snow, 0, this.from), (long)Snow.this.animationTicks);
            }
            return true;
        }

        boolean decreaseSnow(Block snow, boolean disperse) {
            org.bukkit.block.data.type.Snow snowData;
            if (snow.getType() == Material.ICE) {
                snow.setType(Material.WATER);
                return true;
            }
            if (snow.getType() != Material.SNOW && snow.getType() != Material.SNOW_BLOCK) {
                return false;
            }
            if (snow.getRelative(0, 1, 0).getType() == Material.SNOW || snow.getRelative(0, 1, 0).getType() == Material.SNOW_BLOCK) {
                return this.decreaseSnow(snow.getRelative(0, 1, 0), disperse);
            }
            if (snow.getType() == Material.SNOW_BLOCK) {
                snowData = (org.bukkit.block.data.type.Snow)Material.SNOW.createBlockData();
                snowData.setLayers(snowData.getMaximumLayers() - 1);
                snow.setBlockData((BlockData)snowData, false);
            } else {
                snowData = (org.bukkit.block.data.type.Snow)snow.getBlockData();
                if (snowData.getLayers() == snowData.getMinimumLayers()) {
                    snow.setType(Material.AIR, false);
                } else {
                    snowData.setLayers(snowData.getLayers() - 1);
                }
                snow.setBlockData((BlockData)snowData);
            }
            if (disperse && Snow.this.realistic) {
                for (BlockFace dir : UPDATE_FACES) {
                    Bukkit.getScheduler().runTaskLater((Plugin)CraftBookPlugin.inst(), (Runnable)new SnowHandler(snow.getRelative(dir), 0, snow.getLocation().toVector().toBlockVector()), (long)Snow.this.animationTicks);
                }
            }
            return true;
        }
    }

    private class SnowChunkHandler
    implements Runnable {
        public Chunk chunk;

        SnowChunkHandler(Chunk chunk) {
            this.chunk = chunk;
        }

        @Override
        public void run() {
            long delay;
            if (!this.chunk.isLoaded()) {
                return;
            }
            boolean meltMode = !this.chunk.getWorld().hasStorm() && Snow.this.meltSunlight;
            long l = delay = meltMode ? 5L : 20L;
            if (!LocationUtil.isBorderChunk(this.chunk)) {
                Block chunkBase = this.chunk.getBlock(0, 0, 0);
                Block highest = this.chunk.getWorld().getHighestBlockAt(chunkBase.getX() + CraftBookPlugin.inst().getRandom().nextInt(16), chunkBase.getZ() + CraftBookPlugin.inst().getRandom().nextInt(16));
                if (highest.getType() == Material.SNOW || highest.getType() == Material.SNOW_BLOCK || highest.getType() == Material.ICE || Snow.this.isReplacable(highest)) {
                    if (highest.getWorld().hasStorm() && highest.getType() != Material.ICE) {
                        if (highest.getTemperature() < 0.15) {
                            Bukkit.getScheduler().runTaskLater((Plugin)CraftBookPlugin.inst(), (Runnable)new SnowHandler(highest, 1), (long)Snow.this.animationTicks);
                        }
                    } else if (meltMode) {
                        if (highest.getType() == Material.SNOW && Snow.this.meltPartial && ((org.bukkit.block.data.type.Snow)highest.getBlockData()).getLayers() == 0) {
                            return;
                        }
                        if (highest.getTemperature() > 0.05) {
                            Bukkit.getScheduler().runTaskLater((Plugin)CraftBookPlugin.inst(), (Runnable)new SnowHandler(highest, -1), (long)Snow.this.animationTicks);
                        }
                    }
                }
                delay *= Snow.getRandomDelay();
            } else {
                delay *= 50L;
            }
            Bukkit.getScheduler().runTaskLater((Plugin)CraftBookPlugin.inst(), (Runnable)this, delay);
        }
    }
}

