/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics;

import com.sk89q.craftbook.AbstractCraftBookMechanic;
import com.sk89q.craftbook.util.EventUtil;
import com.sk89q.craftbook.util.events.SourcedBlockRedstoneEvent;
import com.sk89q.util.yaml.YAMLProcessor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;

public class Netherrack
extends AbstractCraftBookMechanic {
    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockRedstoneChange(SourcedBlockRedstoneEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (event.isMinor()) {
            return;
        }
        if (event.getBlock().getType() != Material.NETHERRACK) {
            return;
        }
        Block above = event.getBlock().getRelative(0, 1, 0);
        if (event.isOn() && Netherrack.canReplaceWithFire(above.getType())) {
            above.setType(Material.FIRE);
        } else if (!event.isOn() && above != null && above.getType() == Material.FIRE) {
            above.setType(Material.AIR);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onLeftClick(PlayerInteractEvent event) {
        Block fire;
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (event.getAction() != Action.LEFT_CLICK_BLOCK || event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        if (event.getClickedBlock().getType() != Material.NETHERRACK) {
            return;
        }
        if (event.getBlockFace() == BlockFace.UP && (fire = event.getClickedBlock().getRelative(event.getBlockFace())).getType() == Material.FIRE && fire.getRelative(BlockFace.DOWN).isBlockPowered()) {
            event.setCancelled(true);
        }
    }

    private static boolean canReplaceWithFire(Material t) {
        switch (t) {
            case SNOW: 
            case GRASS: 
            case VINE: 
            case DEAD_BUSH: 
            case AIR: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void loadConfiguration(YAMLProcessor config, String path) {
    }
}

