/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics;

import com.sk89q.craftbook.AbstractCraftBookMechanic;
import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.CraftBookPlayer;
import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import com.sk89q.craftbook.bukkit.util.CraftBookBukkitUtil;
import com.sk89q.craftbook.util.EventUtil;
import com.sk89q.craftbook.util.HistoryHashMap;
import com.sk89q.craftbook.util.ProtectionUtil;
import com.sk89q.craftbook.util.SignUtil;
import com.sk89q.craftbook.util.events.SignClickEvent;
import com.sk89q.util.yaml.YAMLProcessor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.SignChangeEvent;

public class LightSwitch
extends AbstractCraftBookMechanic {
    private HistoryHashMap<Location, Long> recentLightToggles;
    private int maxRange;
    private int maxLights;

    @Override
    public boolean enable() {
        this.recentLightToggles = new HistoryHashMap(20);
        return true;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onSignChange(SignChangeEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (!event.getLine(1).equalsIgnoreCase("[i]") && !event.getLine(1).equalsIgnoreCase("[|]")) {
            return;
        }
        CraftBookPlayer lplayer = CraftBookPlugin.inst().wrapPlayer(event.getPlayer());
        if (!lplayer.hasPermission("craftbook.mech.light-switch")) {
            if (CraftBookPlugin.inst().getConfiguration().showPermissionMessages) {
                lplayer.printError("You don't have permission for this.");
            }
            SignUtil.cancelSign(event);
            return;
        }
        event.setLine(1, "[I]");
        lplayer.print("mech.lightswitch.create");
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onRightClick(SignClickEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        ChangedSign sign = event.getSign();
        if (!sign.getLine(1).equalsIgnoreCase("[I]") && !sign.getLine(1).equalsIgnoreCase("[|]")) {
            return;
        }
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        CraftBookPlayer player = event.getWrappedPlayer();
        if (!player.hasPermission("craftbook.mech.light-switch.use")) {
            if (CraftBookPlugin.inst().getConfiguration().showPermissionMessages) {
                player.printError("mech.use-permission");
            }
            return;
        }
        if (!ProtectionUtil.canUse(event.getPlayer(), event.getClickedBlock().getLocation(), event.getBlockFace(), event.getAction())) {
            if (CraftBookPlugin.inst().getConfiguration().showPermissionMessages) {
                player.printError("area.use-permissions");
            }
            return;
        }
        this.toggleLights(event.getClickedBlock(), player);
        event.setCancelled(true);
    }

    private boolean toggleLights(Block block, CraftBookPlayer player) {
        if (!SignUtil.isSign(block)) {
            return false;
        }
        int radius = Math.min(10, this.maxRange);
        int maximum = Math.min(this.maxLights, 20);
        ChangedSign sign = CraftBookBukkitUtil.toChangedSign(block);
        try {
            radius = Math.min(Integer.parseInt(sign.getLine(2)), this.maxRange);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            maximum = Math.min(Integer.parseInt(sign.getLine(3)), this.maxLights);
        }
        catch (Exception exception) {
            // empty catch block
        }
        int wx = block.getX();
        int wy = block.getY();
        int wz = block.getZ();
        Material aboveID = block.getRelative(0, 1, 0).getType();
        if (aboveID == Material.WALL_TORCH || aboveID == Material.REDSTONE_WALL_TORCH) {
            boolean on = aboveID != Material.WALL_TORCH;
            Long lastUse = (Long)this.recentLightToggles.remove(block.getLocation());
            long currTime = System.currentTimeMillis();
            if (lastUse != null && currTime - lastUse < 500L) {
                this.recentLightToggles.put(block.getLocation(), lastUse);
                return true;
            }
            this.recentLightToggles.put(block.getLocation(), currTime);
            int changed = 0;
            for (int x = -radius + wx; x <= radius + wx; ++x) {
                for (int y = -radius + wy; y <= radius + wy; ++y) {
                    for (int z = -radius + wz; z <= radius + wz; ++z) {
                        boolean wall;
                        Block relBlock = block.getWorld().getBlockAt(x, y, z);
                        Material id = relBlock.getType();
                        boolean bl = wall = id == Material.WALL_TORCH || id == Material.REDSTONE_WALL_TORCH;
                        if (id != Material.TORCH && id != Material.WALL_TORCH && id != Material.REDSTONE_TORCH && id != Material.REDSTONE_WALL_TORCH) continue;
                        if (changed >= maximum) {
                            return true;
                        }
                        if (wall) {
                            Directional directional = (Directional)(on ? Material.WALL_TORCH : Material.REDSTONE_WALL_TORCH).createBlockData();
                            relBlock.setBlockData((BlockData)directional, false);
                        } else {
                            relBlock.setType(on ? Material.TORCH : Material.REDSTONE_TORCH, false);
                        }
                        ++changed;
                    }
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void loadConfiguration(YAMLProcessor config, String path) {
        config.setComment(path + "max-range", "The maximum range that the mechanic searches for lights in.");
        this.maxRange = config.getInt(path + "max-range", 10);
        config.setComment(path + "max-lights", "The maximum amount of lights that a Light Switch can toggle per usage.");
        this.maxLights = config.getInt(path + "max-lights", 20);
    }
}

