/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics;

import com.sk89q.craftbook.AbstractCraftBookMechanic;
import com.sk89q.craftbook.CraftBookPlayer;
import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import com.sk89q.craftbook.util.EventUtil;
import com.sk89q.craftbook.util.ItemSyntax;
import com.sk89q.craftbook.util.ProtectionUtil;
import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.util.HandSide;
import com.sk89q.worldedit.world.item.ItemType;
import com.sk89q.worldedit.world.item.ItemTypes;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;

public class LightStone
extends AbstractCraftBookMechanic {
    public ItemType item;

    @EventHandler(priority=EventPriority.NORMAL)
    public void onRightClick(PlayerInteractEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK || event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        CraftBookPlayer player = CraftBookPlugin.inst().wrapPlayer(event.getPlayer());
        if (player.getItemInHand(HandSide.MAIN_HAND).getType() != this.item) {
            return;
        }
        if (!player.hasPermission("craftbook.mech.lightstone.use")) {
            if (CraftBookPlugin.inst().getConfiguration().showPermissionMessages) {
                player.printError("mech.use-permission");
            }
            return;
        }
        if (!ProtectionUtil.canUse(event.getPlayer(), event.getClickedBlock().getLocation(), event.getBlockFace(), event.getAction())) {
            if (CraftBookPlugin.inst().getConfiguration().showPermissionMessages) {
                player.printError("area.use-permissions");
            }
            return;
        }
        Block block = event.getClickedBlock().getRelative(event.getBlockFace());
        player.printRaw(ChatColor.YELLOW + player.translate("mech.lightstone.lightstone") + " [" + LightStone.getLightLine(block.getLightLevel()) + ChatColor.YELLOW + "] " + block.getLightLevel() + " L");
    }

    private static String getLightLine(int data) {
        int i;
        StringBuilder line = new StringBuilder(25);
        if (data >= 9) {
            line.append(ChatColor.GREEN);
        } else {
            line.append(ChatColor.DARK_RED);
        }
        for (i = 0; i < data; ++i) {
            line.append('|');
        }
        line.append(ChatColor.BLACK);
        for (i = data; i < 15; ++i) {
            line.append('|');
        }
        return line.toString();
    }

    @Override
    public void loadConfiguration(YAMLProcessor config, String path) {
        config.setComment(path + "item", "The item that the lightstone mechanic uses.");
        this.item = BukkitAdapter.asItemType((Material)ItemSyntax.getItem(config.getString(path + "item", ItemTypes.GLOWSTONE_DUST.getId())).getType());
    }
}

