/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics;

import com.sk89q.craftbook.AbstractCraftBookMechanic;
import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.CraftBookPlayer;
import com.sk89q.craftbook.bukkit.BukkitCraftBookPlayer;
import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import com.sk89q.craftbook.bukkit.util.CraftBookBukkitUtil;
import com.sk89q.craftbook.util.EventUtil;
import com.sk89q.craftbook.util.LocationUtil;
import com.sk89q.craftbook.util.ProtectionUtil;
import com.sk89q.craftbook.util.RegexUtil;
import com.sk89q.craftbook.util.SignUtil;
import com.sk89q.craftbook.util.events.SignClickEvent;
import com.sk89q.craftbook.util.events.SourcedBlockRedstoneEvent;
import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.type.Switch;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class Elevator
extends AbstractCraftBookMechanic {
    private HashSet<UUID> flyingPlayers;
    private boolean elevatorAllowRedstone;
    private int elevatorRedstoneRadius;
    private boolean elevatorButtonEnabled;
    private boolean elevatorLoop;
    private boolean elevatorSlowMove;
    private double elevatorMoveSpeed;

    @Override
    public boolean enable() {
        if (this.elevatorSlowMove) {
            this.flyingPlayers = new HashSet();
        }
        return true;
    }

    @Override
    public void disable() {
        if (this.flyingPlayers != null) {
            Iterator<UUID> it = this.flyingPlayers.iterator();
            while (it.hasNext()) {
                OfflinePlayer op = Bukkit.getOfflinePlayer((UUID)it.next());
                if (!op.isOnline()) {
                    it.remove();
                    continue;
                }
                op.getPlayer().setFlying(false);
                op.getPlayer().setAllowFlight(op.getPlayer().getGameMode() == GameMode.CREATIVE);
                it.remove();
            }
            this.flyingPlayers = null;
        }
    }

    @EventHandler
    public void onPlayerDamage(EntityDamageEvent event) {
        if (!this.elevatorSlowMove) {
            return;
        }
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        if (!this.flyingPlayers.contains(event.getEntity().getUniqueId())) {
            return;
        }
        if (event instanceof EntityDamageByEntityEvent) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler
    public void onPlayerLeave(PlayerQuitEvent event) {
        if (!this.elevatorSlowMove) {
            return;
        }
        Iterator<UUID> it = this.flyingPlayers.iterator();
        while (it.hasNext()) {
            UUID p = it.next();
            if (!event.getPlayer().getUniqueId().equals(p)) continue;
            event.getPlayer().setFlying(false);
            event.getPlayer().setAllowFlight(event.getPlayer().getGameMode() == GameMode.CREATIVE);
            it.remove();
            break;
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onSignChange(SignChangeEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        Direction dir = Direction.NONE;
        if (event.getLine(1).equalsIgnoreCase("[lift down]")) {
            dir = Direction.DOWN;
        }
        if (event.getLine(1).equalsIgnoreCase("[lift up]")) {
            dir = Direction.UP;
        }
        if (event.getLine(1).equalsIgnoreCase("[lift]")) {
            dir = Direction.RECV;
        }
        if (dir == Direction.NONE) {
            return;
        }
        CraftBookPlayer player = CraftBookPlugin.inst().wrapPlayer(event.getPlayer());
        if (!player.hasPermission("craftbook.mech.elevator")) {
            if (CraftBookPlugin.inst().getConfiguration().showPermissionMessages) {
                player.printError("mech.create-permission");
            }
            SignUtil.cancelSign(event);
            return;
        }
        switch (dir) {
            case UP: {
                player.print("mech.lift.up-sign-created");
                event.setLine(1, "[Lift Up]");
                break;
            }
            case DOWN: {
                player.print("mech.lift.down-sign-created");
                event.setLine(1, "[Lift Down]");
                break;
            }
            case RECV: {
                player.print("mech.lift.target-sign-created");
                event.setLine(1, "[Lift]");
                break;
            }
            default: {
                SignUtil.cancelSign(event);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockRedstoneChange(SourcedBlockRedstoneEvent event) {
        if (!this.elevatorAllowRedstone || event.isMinor() || !event.isOn()) {
            return;
        }
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        Direction dir = this.isLift(event.getBlock());
        switch (dir) {
            case UP: 
            case DOWN: {
                break;
            }
            case RECV: {
                return;
            }
            default: {
                return;
            }
        }
        BlockFace shift = dir == Direction.UP ? BlockFace.UP : BlockFace.DOWN;
        Block destination = this.findDestination(dir, shift, event.getBlock());
        if (destination == null) {
            return;
        }
        for (Player player : LocationUtil.getNearbyPlayers(event.getBlock().getLocation(), this.elevatorRedstoneRadius)) {
            CraftBookPlayer localPlayer = CraftBookPlugin.inst().wrapPlayer(player);
            if (this.flyingPlayers != null && this.flyingPlayers.contains(localPlayer.getUniqueId())) {
                localPlayer.printError("mech.lift.busy");
                continue;
            }
            if (!localPlayer.hasPermission("craftbook.mech.elevator.use")) {
                if (!CraftBookPlugin.inst().getConfiguration().showPermissionMessages) continue;
                localPlayer.printError("mech.use-permission");
                continue;
            }
            this.makeItSo(localPlayer, destination, shift);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onRightClick(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (!this.elevatorButtonEnabled) {
            return;
        }
        if (SignUtil.isSign(event.getClickedBlock())) {
            return;
        }
        this.onCommonClick(event);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onRightClick(SignClickEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        this.onCommonClick(event);
    }

    public void onCommonClick(PlayerInteractEvent event) {
        if (!EventUtil.passesFilter((Event)event) || event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        CraftBookPlayer localPlayer = CraftBookPlugin.inst().wrapPlayer(event.getPlayer());
        Direction dir = this.isLift(event.getClickedBlock());
        switch (dir) {
            case UP: 
            case DOWN: {
                break;
            }
            case RECV: {
                localPlayer.printError("mech.lift.no-depart");
                return;
            }
            default: {
                return;
            }
        }
        BlockFace shift = dir == Direction.UP ? BlockFace.UP : BlockFace.DOWN;
        Block destination = this.findDestination(dir, shift, event.getClickedBlock());
        if (destination == null) {
            localPlayer.printError("mech.lift.no-destination");
            return;
        }
        if (this.flyingPlayers != null && this.flyingPlayers.contains(localPlayer.getUniqueId())) {
            localPlayer.printError("mech.lift.busy");
            return;
        }
        if (!localPlayer.hasPermission("craftbook.mech.elevator.use")) {
            event.setCancelled(true);
            if (CraftBookPlugin.inst().getConfiguration().showPermissionMessages) {
                localPlayer.printError("mech.use-permission");
            }
            return;
        }
        if (!ProtectionUtil.canUse(event.getPlayer(), event.getClickedBlock().getLocation(), event.getBlockFace(), event.getAction())) {
            if (CraftBookPlugin.inst().getConfiguration().showPermissionMessages) {
                localPlayer.printError("area.use-permissions");
            }
            return;
        }
        this.makeItSo(localPlayer, destination, shift);
        event.setCancelled(true);
    }

    public Block findDestination(Direction dir, BlockFace shift, Block clickedBlock) {
        Direction derp;
        int f = dir == Direction.UP ? clickedBlock.getWorld().getMaxHeight() : 0;
        Block destination = clickedBlock;
        if (destination.getY() == f) {
            return null;
        }
        boolean loopd = false;
        while ((derp = this.isLift(destination = destination.getRelative(shift))) == Direction.NONE || !Elevator.isValidLift(CraftBookBukkitUtil.toChangedSign(clickedBlock), CraftBookBukkitUtil.toChangedSign(destination))) {
            if (destination.getY() == clickedBlock.getY()) {
                return null;
            }
            if (this.elevatorLoop && !loopd) {
                Location low;
                if (destination.getY() == clickedBlock.getWorld().getMaxHeight()) {
                    low = destination.getLocation();
                    low.setY(0.0);
                    destination = destination.getWorld().getBlockAt(low);
                    loopd = true;
                    continue;
                }
                if (destination.getY() != 0) continue;
                low = destination.getLocation();
                low.setY((double)clickedBlock.getWorld().getMaxHeight());
                destination = destination.getWorld().getBlockAt(low);
                loopd = true;
                continue;
            }
            if (destination.getY() == clickedBlock.getWorld().getMaxHeight()) {
                return null;
            }
            if (destination.getY() != 0) continue;
            return null;
        }
        return destination;
    }

    private void makeItSo(CraftBookPlayer player, Block destination, BlockFace shift) {
        Block floor = destination.getWorld().getBlockAt((int)Math.floor(player.getLocation().getX()), destination.getY() + 1, (int)Math.floor(player.getLocation().getZ()));
        if (floor.getType().isSolid()) {
            floor = floor.getRelative(BlockFace.DOWN);
        }
        int foundFree = 0;
        boolean foundGround = false;
        for (int i = 0; i < 5; ++i) {
            if (!floor.getType().isSolid() || SignUtil.isSign(floor)) {
                ++foundFree;
            } else {
                foundGround = true;
                break;
            }
            if (floor.getY() == 0) break;
            floor = floor.getRelative(BlockFace.DOWN);
        }
        if (!foundGround) {
            player.printError("mech.lift.no-floor");
            return;
        }
        if (foundFree < 2) {
            player.printError("mech.lift.obstruct");
            return;
        }
        this.teleportPlayer(player, floor, destination, shift);
    }

    public void teleportPlayer(final CraftBookPlayer player, Block floor, final Block destination, final BlockFace shift) {
        final Location newLocation = CraftBookBukkitUtil.toLocation(player.getLocation());
        newLocation.setY((double)(floor.getY() + 1));
        if (this.elevatorSlowMove) {
            final Location lastLocation = CraftBookBukkitUtil.toLocation(player.getLocation());
            new BukkitRunnable(){

                public void run() {
                    Player op = ((BukkitCraftBookPlayer)player).getPlayer();
                    if (!op.isOnline()) {
                        this.cancel();
                        return;
                    }
                    Player p = op.getPlayer();
                    if (!Elevator.this.flyingPlayers.contains(p.getUniqueId()) && !p.getAllowFlight()) {
                        Elevator.this.flyingPlayers.add(p.getUniqueId());
                    }
                    p.setAllowFlight(true);
                    p.setFlying(true);
                    p.setFallDistance(0.0f);
                    p.setNoDamageTicks(2);
                    double speed = Elevator.this.elevatorMoveSpeed;
                    newLocation.setPitch(p.getLocation().getPitch());
                    newLocation.setYaw(p.getLocation().getYaw());
                    if (Math.abs(newLocation.getY() - p.getLocation().getY()) < 0.7) {
                        p.teleport(newLocation);
                        Elevator.teleportFinish(player, destination, shift);
                        if (Elevator.this.flyingPlayers.contains(p.getUniqueId())) {
                            p.setFlying(false);
                            p.setAllowFlight(p.getGameMode() == GameMode.CREATIVE);
                            Elevator.this.flyingPlayers.remove(p.getUniqueId());
                        }
                        this.cancel();
                        return;
                    }
                    if (lastLocation.getBlockX() != p.getLocation().getBlockX() || lastLocation.getBlockZ() != p.getLocation().getBlockZ()) {
                        player.print("mech.lift.leave");
                        if (Elevator.this.flyingPlayers.contains(p.getUniqueId())) {
                            p.setFlying(false);
                            p.setAllowFlight(p.getGameMode() == GameMode.CREATIVE);
                            Elevator.this.flyingPlayers.remove(p.getUniqueId());
                        }
                        this.cancel();
                        return;
                    }
                    if (newLocation.getY() > p.getLocation().getY()) {
                        p.setVelocity(new Vector(0.0, speed, 0.0));
                        if (p.getLocation().add(0.0, 2.0, 0.0).getBlock().getType().isSolid()) {
                            p.teleport(p.getLocation().add(0.0, speed, 0.0));
                        }
                    } else if (newLocation.getY() < p.getLocation().getY()) {
                        p.setVelocity(new Vector(0.0, -speed, 0.0));
                        if (p.getLocation().add(0.0, -1.0, 0.0).getBlock().getType().isSolid()) {
                            p.teleport(p.getLocation().add(0.0, -speed, 0.0));
                        }
                    } else {
                        Elevator.teleportFinish(player, destination, shift);
                        if (Elevator.this.flyingPlayers.contains(p.getUniqueId())) {
                            p.setFlying(false);
                            p.setAllowFlight(p.getGameMode() == GameMode.CREATIVE);
                            Elevator.this.flyingPlayers.remove(p.getUniqueId());
                        }
                        this.cancel();
                        return;
                    }
                    lastLocation.setY(p.getLocation().getY());
                }
            }.runTaskTimer((Plugin)CraftBookPlugin.inst(), 1L, 1L);
        } else {
            if (player.isInsideVehicle()) {
                newLocation.setX(((BukkitCraftBookPlayer)player).getPlayer().getVehicle().getLocation().getX());
                newLocation.setY((double)(floor.getY() + 2));
                newLocation.setZ(((BukkitCraftBookPlayer)player).getPlayer().getVehicle().getLocation().getZ());
                newLocation.setYaw(((BukkitCraftBookPlayer)player).getPlayer().getVehicle().getLocation().getYaw());
                newLocation.setPitch(((BukkitCraftBookPlayer)player).getPlayer().getVehicle().getLocation().getPitch());
                ((BukkitCraftBookPlayer)player).getPlayer().getVehicle().teleport(newLocation);
            }
            player.setPosition(BukkitAdapter.adapt((Location)newLocation).toVector(), newLocation.getPitch(), newLocation.getYaw());
            Elevator.teleportFinish(player, destination, shift);
        }
    }

    public static void teleportFinish(CraftBookPlayer player, Block destination, BlockFace shift) {
        String title;
        ChangedSign info = null;
        if (!SignUtil.isSign(destination)) {
            Switch attachable;
            if (Tag.BUTTONS.isTagged((Keyed)destination.getType()) && SignUtil.isSign(destination.getRelative((attachable = (Switch)destination.getBlockData()).getFacing().getOppositeFace(), 2))) {
                info = CraftBookBukkitUtil.toChangedSign(destination.getRelative(attachable.getFacing().getOppositeFace(), 2));
            }
            if (info == null) {
                return;
            }
        } else {
            info = CraftBookBukkitUtil.toChangedSign(destination);
        }
        if (!(title = info.getLines()[0]).isEmpty()) {
            player.print(player.translate("mech.lift.floor") + ": " + title);
        } else {
            player.print(shift.getModY() > 0 ? "mech.lift.up" : "mech.lift.down");
        }
    }

    public static boolean isValidLift(ChangedSign start, ChangedSign stop) {
        if (start == null || stop == null) {
            return true;
        }
        if (start.getLine(2).toLowerCase(Locale.ENGLISH).startsWith("to:")) {
            try {
                return stop.getLine(0).equalsIgnoreCase(RegexUtil.COLON_PATTERN.split(start.getLine(2))[0].trim());
            }
            catch (Exception e) {
                start.setLine(2, "");
                return false;
            }
        }
        return true;
    }

    private Direction isLift(Block block) {
        if (!SignUtil.isSign(block)) {
            if (this.elevatorButtonEnabled && Tag.BUTTONS.isTagged((Keyed)block.getType())) {
                Switch b = (Switch)block.getBlockData();
                if (b == null || b.getFacing() == null) {
                    return Direction.NONE;
                }
                Block sign = block.getRelative(b.getFacing().getOppositeFace(), 2);
                if (SignUtil.isSign(sign)) {
                    return Elevator.isLift(CraftBookBukkitUtil.toChangedSign(sign));
                }
            }
            return Direction.NONE;
        }
        return Elevator.isLift(CraftBookBukkitUtil.toChangedSign(block));
    }

    private static Direction isLift(ChangedSign sign) {
        if (sign.getLine(1).equalsIgnoreCase("[Lift Up]")) {
            return Direction.UP;
        }
        if (sign.getLine(1).equalsIgnoreCase("[Lift Down]")) {
            return Direction.DOWN;
        }
        if (sign.getLine(1).equalsIgnoreCase("[Lift]")) {
            return Direction.RECV;
        }
        return Direction.NONE;
    }

    @Override
    public void loadConfiguration(YAMLProcessor config, String path) {
        config.setComment(path + "allow-redstone", "Allows elevators to be triggered by redstone, which will move all players in a radius.");
        this.elevatorAllowRedstone = config.getBoolean(path + "allow-redstone", false);
        config.setComment(path + "redstone-player-search-radius", "The radius that elevators will look for players in when triggered by redstone.");
        this.elevatorRedstoneRadius = config.getInt(path + "redstone-player-search-radius", 3);
        config.setComment(path + "enable-buttons", "Allow elevators to be used by a button on the other side of the block.");
        this.elevatorButtonEnabled = config.getBoolean(path + "enable-buttons", true);
        config.setComment(path + "allow-looping", "Allows elevators to loop the world height. The heighest lift up will go to the next lift on the bottom of the world and vice versa.");
        this.elevatorLoop = config.getBoolean(path + "allow-looping", false);
        config.setComment(path + "smooth-movement", "Causes the elevator to slowly move the player between floors instead of instantly.");
        this.elevatorSlowMove = config.getBoolean(path + "smooth-movement", false);
        config.setComment(path + "smooth-movement-speed", "The speed at which players move from floor to floor when smooth movement is enabled.");
        this.elevatorMoveSpeed = config.getDouble(path + "smooth-movement-speed", 0.5);
    }

    private static enum Direction {
        NONE,
        UP,
        DOWN,
        RECV;

    }
}

