/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics;

import com.sk89q.craftbook.AbstractCraftBookMechanic;
import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.CraftBookPlayer;
import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import com.sk89q.craftbook.bukkit.util.CraftBookBukkitUtil;
import com.sk89q.craftbook.util.EventUtil;
import com.sk89q.craftbook.util.SignUtil;
import com.sk89q.craftbook.util.events.SourcedBlockRedstoneEvent;
import com.sk89q.util.yaml.YAMLProcessor;
import org.bukkit.Chunk;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.plugin.Plugin;

public class ChunkAnchor
extends AbstractCraftBookMechanic {
    private boolean allowRedstone;
    private boolean checkChunks;

    @EventHandler(priority=EventPriority.HIGH)
    public void onSignChange(SignChangeEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (!event.getLine(1).equalsIgnoreCase("[chunk]")) {
            return;
        }
        CraftBookPlayer lplayer = CraftBookPlugin.inst().wrapPlayer(event.getPlayer());
        if (!lplayer.hasPermission("craftbook.mech.chunk")) {
            if (CraftBookPlugin.inst().getConfiguration().showPermissionMessages) {
                lplayer.printError("mech.create-permission");
            }
            SignUtil.cancelSign(event);
            return;
        }
        if (this.checkChunks) {
            for (BlockState state : event.getBlock().getChunk().getTileEntities()) {
                Sign s;
                if (!(state instanceof Sign) || !(s = (Sign)state).getLine(1).equalsIgnoreCase("[Chunk]")) continue;
                lplayer.printError("mech.anchor.already-anchored");
                SignUtil.cancelSign(event);
                return;
            }
        }
        event.setLine(1, "[Chunk]");
        lplayer.print("mech.anchor.create");
    }

    @EventHandler
    public void onChunkLoad(ChunkLoadEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        this.updateChunkTicket(event.getChunk());
    }

    @EventHandler
    public void onBlockRedstoneChange(SourcedBlockRedstoneEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (!this.allowRedstone) {
            return;
        }
        Block block = event.getBlock();
        if (SignUtil.isSign(block)) {
            ChangedSign sign = CraftBookBukkitUtil.toChangedSign(block);
            if (!sign.getLine(1).equals("[Chunk]")) {
                return;
            }
            sign.setLine(3, event.getNewCurrent() > event.getOldCurrent() ? "on" : "off");
            sign.update(false);
            this.updateChunkTicket(event.getBlock().getChunk());
        }
    }

    private void updateChunkTicket(Chunk chunk) {
        boolean shouldAnchor = false;
        for (BlockState state : chunk.getTileEntities()) {
            if (state == null || !(state instanceof Sign) || !((Sign)state).getLine(1).equals("[Chunk]") || this.allowRedstone && ((Sign)state).getLine(3).equalsIgnoreCase("off")) continue;
            shouldAnchor = true;
            break;
        }
        if (shouldAnchor) {
            chunk.addPluginChunkTicket((Plugin)CraftBookPlugin.inst());
        } else {
            chunk.removePluginChunkTicket((Plugin)CraftBookPlugin.inst());
        }
    }

    @Override
    public void loadConfiguration(YAMLProcessor config, String path) {
        config.setComment(path + "enable-redstone", "Enable toggling with redstone.");
        this.allowRedstone = config.getBoolean(path + "enable-redstone", true);
        config.setComment(path + "check-chunks", "On creation, check the chunk for already existing chunk anchors.");
        this.checkChunks = config.getBoolean(path + "check-chunks", true);
    }
}

