/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics;

import com.sk89q.craftbook.AbstractCraftBookMechanic;
import com.sk89q.craftbook.CraftBookPlayer;
import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import com.sk89q.craftbook.util.EventUtil;
import com.sk89q.craftbook.util.ProtectionUtil;
import com.sk89q.craftbook.util.TernaryState;
import com.sk89q.util.yaml.YAMLProcessor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedHashSet;
import org.bukkit.Material;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;

public class Bookcase
extends AbstractCraftBookMechanic {
    public static String[] lines;
    private boolean bookcaseReadHoldingBlock;
    private TernaryState bookcaseReadWhenSneaking;

    public static void read(CraftBookPlayer player) {
        try {
            String text = Bookcase.getBookLine();
            if (text != null) {
                player.print("mech.bookcase.read-line");
                player.printRaw(text);
            } else {
                player.printError("mech.bookcase.fail-line");
            }
        }
        catch (Exception e) {
            player.printError("mech.bookcase.fail-file");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean enable() {
        CraftBookPlugin.inst().createDefaultConfiguration(new File(CraftBookPlugin.inst().getDataFolder(), "books.txt"), "books.txt");
        BufferedReader reader = null;
        try {
            String l;
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(new File(CraftBookPlugin.inst().getDataFolder(), "books.txt")), "UTF-8"));
            LinkedHashSet<String> list = new LinkedHashSet<String>();
            while ((l = reader.readLine()) != null) {
                list.add(l);
            }
            lines = list.toArray(new String[list.size()]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return true;
    }

    @Override
    public void disable() {
        lines = null;
    }

    private static String getBookLine() throws Exception {
        return lines[CraftBookPlugin.inst().getRandom().nextInt(lines.length)];
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onRightClick(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK || event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        if (event.getClickedBlock().getType() != Material.BOOKSHELF) {
            return;
        }
        if (!this.bookcaseReadWhenSneaking.doesPass(event.getPlayer().isSneaking())) {
            return;
        }
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        CraftBookPlayer player = CraftBookPlugin.inst().wrapPlayer(event.getPlayer());
        if (!player.hasPermission("craftbook.mech.bookshelf.use")) {
            if (CraftBookPlugin.inst().getConfiguration().showPermissionMessages) {
                player.printError("mech.use-permission");
            }
            return;
        }
        if (!ProtectionUtil.canUse(event.getPlayer(), event.getClickedBlock().getLocation(), event.getBlockFace(), event.getAction())) {
            if (CraftBookPlugin.inst().getConfiguration().showPermissionMessages) {
                player.printError("area.use-permissions");
            }
            return;
        }
        if (this.bookcaseReadHoldingBlock || !player.isHoldingBlock()) {
            Bookcase.read(player);
        }
    }

    @Override
    public void loadConfiguration(YAMLProcessor config, String path) {
        config.setComment(path + "read-when-sneaking", "Enable reading while sneaking.");
        this.bookcaseReadWhenSneaking = TernaryState.getFromString(config.getString(path + "read-when-sneaking", "no"));
        config.setComment(path + "read-when-holding-block", "Allow bookshelves to work when the player is holding a block.");
        this.bookcaseReadHoldingBlock = config.getBoolean(path + "read-when-holding-block", false);
    }
}

