/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.bukkit;

import com.sk89q.craftbook.CraftBookMechanic;
import com.sk89q.craftbook.bukkit.BukkitConfiguration;
import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import com.sk89q.craftbook.mechanics.crafting.CraftingItemStack;
import com.sk89q.craftbook.mechanics.crafting.RecipeManager;
import com.sk89q.craftbook.mechanics.ic.IC;
import com.sk89q.craftbook.mechanics.ic.ICManager;
import com.sk89q.craftbook.util.LogListBlock;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.plugin.Plugin;

public class ReportWriter {
    private static final SimpleDateFormat dateFmt = new SimpleDateFormat("yyyy-MM-dd kk:mm Z");
    private Date date = new Date();
    private StringBuilder output = new StringBuilder();
    private String flags = "";
    private CraftBookPlugin plugin;

    public ReportWriter(CraftBookPlugin plugin) {
        this.plugin = plugin;
    }

    public void generate() {
        this.appendReportHeader(this.plugin);
        this.appendServerInformation(this.plugin.getServer());
        this.appendPluginInformation(this.plugin.getServer().getPluginManager().getPlugins());
        this.appendCraftBookInformation(this.plugin);
        this.appendCustomCraftingInformation(this.plugin);
        this.appendGlobalConfiguration(this.plugin.getConfiguration());
        this.appendMechanicConfiguration(this.plugin.getMechanics());
        this.appendln("-------------");
        this.appendln("END OF REPORT");
        this.appendln();
    }

    protected static String repeat(String str, int n) {
        if (str == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            sb.append(str);
        }
        return sb.toString();
    }

    protected void append(LogListBlock log) {
        this.output.append(log.toString());
    }

    protected void appendln(String text) {
        this.output.append(text);
        this.output.append("\r\n");
    }

    protected void appendln(String text, Object ... args) {
        this.output.append(String.format(text, args));
        this.output.append("\r\n");
    }

    protected void appendln() {
        this.output.append("\r\n");
    }

    protected void appendHeader(String text) {
        String rule = ReportWriter.repeat("-", text.length());
        this.output.append(rule);
        this.output.append("\r\n");
        this.appendln(text);
        this.output.append(rule);
        this.output.append("\r\n");
        this.appendln();
    }

    private void appendReportHeader(CraftBookPlugin plugin) {
        this.appendln("CraftBook Configuration Report");
        this.appendln("Generated " + dateFmt.format(this.date));
        this.appendln();
        this.appendln("Version: " + plugin.getDescription().getVersion());
        this.appendln();
    }

    private void appendGlobalConfiguration(BukkitConfiguration config) {
        this.appendHeader("Global Configuration");
        LogListBlock log = new LogListBlock();
        LogListBlock configLog = log.putChild("Configuration");
        Class<?> cls = config.getClass();
        for (Field field : cls.getFields()) {
            try {
                if (field.getName().equalsIgnoreCase("config") || field.getName().equalsIgnoreCase("plugin")) continue;
                Object val = field.get(config);
                configLog.put(field.getName(), val);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        this.append(log);
        this.appendln();
    }

    private void appendMechanicConfiguration(List<CraftBookMechanic> mechanics) {
        this.appendHeader("Mechanic Configurations");
        LogListBlock log = new LogListBlock();
        for (CraftBookMechanic mechanic : mechanics) {
            LogListBlock configLog = log.putChild(mechanic.getClass().getSimpleName());
            Class<?> cls = mechanic.getClass();
            for (Field field : cls.getDeclaredFields()) {
                try {
                    if (field.getName().equalsIgnoreCase("instance") || field.getName().equalsIgnoreCase("queue")) continue;
                    field.setAccessible(true);
                    Object val = field.get(mechanic);
                    configLog.put(field.getName(), val);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }
        this.append(log);
        this.appendln();
    }

    private void appendServerInformation(Server server) {
        this.appendHeader("Server Information");
        LogListBlock log = new LogListBlock();
        Runtime runtime = Runtime.getRuntime();
        log.put("Java", "%s %s (%s)", System.getProperty("java.vendor"), System.getProperty("java.version"), System.getProperty("java.vendor.url"));
        log.put("Operating system", "%s %s (%s)", System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"));
        log.put("Available processors", runtime.availableProcessors());
        log.put("Free memory", runtime.freeMemory() / 1024L / 1024L + " MB");
        log.put("Max memory", runtime.maxMemory() / 1024L / 1024L + " MB");
        log.put("Total memory", runtime.totalMemory() / 1024L / 1024L + " MB");
        log.put("Implementation", server.getVersion());
        log.put("Player count", "%d/%d", server.getOnlinePlayers().size(), server.getMaxPlayers());
        this.append(log);
        this.appendln();
    }

    private void appendCraftBookInformation(CraftBookPlugin plugin) {
        this.appendHeader("CraftBook Information");
        LogListBlock log = new LogListBlock();
        int i = CraftBookPlugin.inst().getMechanics().size();
        log.put("Mechanics Loaded", "%d", i);
        log.put("ST Mechanics Loaded", "%d", plugin.getSelfTriggerManager() == null ? 0 : plugin.getSelfTriggerManager().getSelfTriggeringMechanics().size());
        this.append(log);
        this.appendln();
        this.appendHeader("Loaded Mechanics");
        log = new LogListBlock();
        for (CraftBookMechanic craftBookMechanic : CraftBookPlugin.inst().getMechanics()) {
            log.put(craftBookMechanic.getClass().getSimpleName(), craftBookMechanic.getClass().getPackage().toString());
        }
        this.append(log);
        this.appendln();
        if (this.flags.contains("i")) {
            this.appendHeader("Loaded Self Triggering ICs");
            log = new LogListBlock();
            for (Map.Entry entry : ICManager.getCachedICs().entrySet()) {
                log.put(((Location)entry.getKey()).toString(), "%s", ((IC)entry.getValue()).getSign().toString());
            }
            this.append(log);
            this.appendln();
        }
    }

    private void appendCustomCraftingInformation(CraftBookPlugin plugin) {
        this.appendHeader("Custom Crafting");
        LogListBlock log = new LogListBlock();
        if (RecipeManager.INSTANCE == null) {
            log.put("CustomCrafting is disabled!", "");
            this.append(log);
            this.appendln();
            return;
        }
        for (RecipeManager.Recipe rec : RecipeManager.INSTANCE.getRecipes()) {
            log.put("Recipe ID", "%s", rec.getId());
            log.put("Recipe Type", "%s", rec.getType().name());
            if (rec.getType() == RecipeManager.RecipeType.SHAPED) {
                log.put("Recipe Shape", Arrays.toString(rec.getShape()));
                for (Map.Entry entry : rec.getShapedIngredients().entrySet()) {
                    log.put("Ingredient", "%s %c", ((CraftingItemStack)entry.getKey()).toString(), entry.getValue());
                }
            } else {
                for (CraftingItemStack craftingItemStack : rec.getIngredients()) {
                    log.put("Ingredient", "%s", craftingItemStack.toString());
                }
            }
            log.put("Result", "%s", rec.getResult().toString());
            log.put("Advanced-Data", rec.getAdvancedDataMap());
        }
        this.append(log);
        this.appendln();
    }

    private void appendPluginInformation(Plugin[] plugins) {
        this.appendHeader("Plugins (" + plugins.length + ")");
        LogListBlock log = new LogListBlock();
        for (Plugin plugin : plugins) {
            log.put(plugin.getDescription().getName(), plugin.getDescription().getVersion());
        }
        this.append(log);
        this.appendln();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File file) throws IOException {
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
            BufferedWriter out = new BufferedWriter(writer);
            out.write(this.output.toString());
            out.close();
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public String toString() {
        return this.output.toString();
    }

    public String getFlags() {
        return this.flags;
    }

    public void appendFlags(String flags) {
        this.flags = this.flags + flags;
    }
}

