/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.bukkit;

import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import com.sk89q.craftbook.bukkit.util.CraftBookBukkitUtil;
import com.sk89q.craftbook.mechanics.minecart.blocks.CartBlockMechanism;
import com.sk89q.craftbook.mechanics.minecart.blocks.CartMechanismBlocks;
import com.sk89q.craftbook.mechanics.minecart.events.CartBlockEnterEvent;
import com.sk89q.craftbook.mechanics.minecart.events.CartBlockImpactEvent;
import com.sk89q.craftbook.mechanics.minecart.events.CartBlockRedstoneEvent;
import com.sk89q.craftbook.util.EventUtil;
import com.sk89q.craftbook.util.LocationUtil;
import com.sk89q.craftbook.util.ProtectionUtil;
import com.sk89q.craftbook.util.SignUtil;
import com.sk89q.craftbook.util.events.SignClickEvent;
import com.sk89q.craftbook.util.events.SourcedBlockRedstoneEvent;
import com.sk89q.craftbook.util.exceptions.InvalidMechanismException;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.AnaloguePowerable;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.Powerable;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.plugin.Plugin;

final class MechanicListenerAdapter
implements Listener {
    private Set<String> signClickTimer = new HashSet<String>();

    MechanicListenerAdapter() {
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerInteract(PlayerInteractEvent event) {
        Action action;
        Block block;
        block10: {
            if (!EventUtil.passesFilter((Event)event)) {
                return;
            }
            block = null;
            action = null;
            if (event.getAction() == Action.RIGHT_CLICK_AIR) {
                try {
                    block = event.getPlayer().getTargetBlock(null, 5);
                    if (block != null && block.getType() != Material.AIR) {
                        action = Action.RIGHT_CLICK_BLOCK;
                        break block10;
                    }
                    action = Action.RIGHT_CLICK_AIR;
                }
                catch (Exception exception) {}
            } else {
                block = event.getClickedBlock();
                action = event.getAction();
            }
        }
        if (block != null && SignUtil.isSign(block) && event.getHand() == EquipmentSlot.HAND) {
            if (CraftBookPlugin.inst().getConfiguration().signClickTimeout > 0L) {
                if (this.signClickTimer.contains(event.getPlayer().getName())) {
                    return;
                }
                this.signClickTimer.add(event.getPlayer().getName());
                Bukkit.getScheduler().runTaskLater((Plugin)CraftBookPlugin.inst(), () -> this.signClickTimer.remove(event.getPlayer().getName()), CraftBookPlugin.inst().getConfiguration().signClickTimeout);
            }
            SignClickEvent ev = new SignClickEvent(event.getPlayer(), action, event.getItem(), block, event.getBlockFace());
            CraftBookPlugin.inst().getServer().getPluginManager().callEvent((Event)ev);
            if (ev.isCancelled()) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockBreak(BlockBreakEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (!CraftBookPlugin.inst().getConfiguration().advancedBlockChecks || !event.isCancelled()) {
            MechanicListenerAdapter.checkBlockChange(event.getPlayer(), event.getBlock(), false);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockPlace(BlockPlaceEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (!CraftBookPlugin.inst().getConfiguration().advancedBlockChecks || !event.isCancelled()) {
            MechanicListenerAdapter.checkBlockChange(event.getPlayer(), event.getBlock(), true);
        }
    }

    private static void checkBlockChange(Player player, Block block, boolean build) {
        switch (block.getType()) {
            case REDSTONE_TORCH: 
            case REDSTONE_WALL_TORCH: 
            case REDSTONE_BLOCK: {
                if (CraftBookPlugin.inst().getConfiguration().pedanticBlockChecks && !ProtectionUtil.canBuild(player, block.getLocation(), build)) break;
                MechanicListenerAdapter.handleRedstoneForBlock(block, build ? 0 : 15, build ? 15 : 0);
                break;
            }
            case ACACIA_BUTTON: 
            case BIRCH_BUTTON: 
            case DARK_OAK_BUTTON: 
            case JUNGLE_BUTTON: 
            case OAK_BUTTON: 
            case SPRUCE_BUTTON: 
            case STONE_BUTTON: 
            case LEVER: 
            case DETECTOR_RAIL: 
            case STONE_PRESSURE_PLATE: 
            case ACACIA_PRESSURE_PLATE: 
            case BIRCH_PRESSURE_PLATE: 
            case DARK_OAK_PRESSURE_PLATE: 
            case JUNGLE_PRESSURE_PLATE: 
            case OAK_PRESSURE_PLATE: 
            case SPRUCE_PRESSURE_PLATE: 
            case COMPARATOR: 
            case REPEATER: {
                Powerable powerable;
                if (CraftBookPlugin.inst().getConfiguration().pedanticBlockChecks && !ProtectionUtil.canBuild(player, block.getLocation(), build) || !(powerable = (Powerable)block.getBlockData()).isPowered()) break;
                MechanicListenerAdapter.handleRedstoneForBlock(block, build ? 0 : 15, build ? 15 : 0);
                break;
            }
            case HEAVY_WEIGHTED_PRESSURE_PLATE: 
            case LIGHT_WEIGHTED_PRESSURE_PLATE: 
            case REDSTONE_WIRE: {
                AnaloguePowerable analoguePowerable;
                if (CraftBookPlugin.inst().getConfiguration().pedanticBlockChecks && !ProtectionUtil.canBuild(player, block.getLocation(), build) || (analoguePowerable = (AnaloguePowerable)block.getBlockData()).getPower() <= 0) break;
                MechanicListenerAdapter.handleRedstoneForBlock(block, build ? 0 : analoguePowerable.getPower(), build ? analoguePowerable.getPower() : 0);
                break;
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockRedstoneChange(BlockRedstoneEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        MechanicListenerAdapter.handleRedstoneForBlock(event.getBlock(), event.getOldCurrent(), event.getNewCurrent());
    }

    private static void handleRedstoneForBlock(Block block, int oldLevel, int newLevel) {
        boolean wasChange;
        World world = block.getWorld();
        boolean wasOn = oldLevel >= 1;
        boolean isOn = newLevel >= 1;
        boolean bl = wasChange = wasOn != isOn;
        if (!wasChange) {
            return;
        }
        int x = block.getX();
        int y = block.getY();
        int z = block.getZ();
        switch (block.getType()) {
            case REDSTONE_WIRE: {
                if (CraftBookPlugin.inst().getConfiguration().indirectRedstone) {
                    MechanicListenerAdapter.handleDirectWireInput(x - 1, y, z, block, oldLevel, newLevel);
                    MechanicListenerAdapter.handleDirectWireInput(x + 1, y, z, block, oldLevel, newLevel);
                    MechanicListenerAdapter.handleDirectWireInput(x, y, z - 1, block, oldLevel, newLevel);
                    MechanicListenerAdapter.handleDirectWireInput(x, y, z + 1, block, oldLevel, newLevel);
                    MechanicListenerAdapter.handleDirectWireInput(x, y + 1, z, block, oldLevel, newLevel);
                    MechanicListenerAdapter.handleDirectWireInput(x, y - 1, z, block, oldLevel, newLevel);
                } else {
                    Material above = world.getBlockAt(x, y + 1, z).getType();
                    Material westSide = world.getBlockAt(x, y, z + 1).getType();
                    Material westSideAbove = world.getBlockAt(x, y + 1, z + 1).getType();
                    Material westSideBelow = world.getBlockAt(x, y - 1, z + 1).getType();
                    Material eastSide = world.getBlockAt(x, y, z - 1).getType();
                    Material eastSideAbove = world.getBlockAt(x, y + 1, z - 1).getType();
                    Material eastSideBelow = world.getBlockAt(x, y - 1, z - 1).getType();
                    Material northSide = world.getBlockAt(x - 1, y, z).getType();
                    Material northSideAbove = world.getBlockAt(x - 1, y + 1, z).getType();
                    Material northSideBelow = world.getBlockAt(x - 1, y - 1, z).getType();
                    Material southSide = world.getBlockAt(x + 1, y, z).getType();
                    Material southSideAbove = world.getBlockAt(x + 1, y + 1, z).getType();
                    Material southSideBelow = world.getBlockAt(x + 1, y - 1, z).getType();
                    if (!(CraftBookBukkitUtil.isRedstoneBlock(westSide) || CraftBookBukkitUtil.isRedstoneBlock(eastSide) || CraftBookBukkitUtil.isRedstoneBlock(westSideAbove) && westSide != Material.AIR && above == Material.AIR || CraftBookBukkitUtil.isRedstoneBlock(eastSideAbove) && eastSide != Material.AIR && above == Material.AIR || CraftBookBukkitUtil.isRedstoneBlock(westSideBelow) && westSide == Material.AIR || CraftBookBukkitUtil.isRedstoneBlock(eastSideBelow) && eastSide == Material.AIR)) {
                        MechanicListenerAdapter.handleDirectWireInput(x - 1, y, z, block, oldLevel, newLevel);
                        MechanicListenerAdapter.handleDirectWireInput(x + 1, y, z, block, oldLevel, newLevel);
                        MechanicListenerAdapter.handleDirectWireInput(x - 1, y - 1, z, block, oldLevel, newLevel);
                        MechanicListenerAdapter.handleDirectWireInput(x + 1, y - 1, z, block, oldLevel, newLevel);
                    }
                    if (!(CraftBookBukkitUtil.isRedstoneBlock(northSide) || CraftBookBukkitUtil.isRedstoneBlock(southSide) || CraftBookBukkitUtil.isRedstoneBlock(northSideAbove) && northSide != Material.AIR && above == Material.AIR || CraftBookBukkitUtil.isRedstoneBlock(southSideAbove) && southSide != Material.AIR && above == Material.AIR || CraftBookBukkitUtil.isRedstoneBlock(northSideBelow) && northSide == Material.AIR || CraftBookBukkitUtil.isRedstoneBlock(southSideBelow) && southSide == Material.AIR)) {
                        MechanicListenerAdapter.handleDirectWireInput(x, y, z - 1, block, oldLevel, newLevel);
                        MechanicListenerAdapter.handleDirectWireInput(x, y, z + 1, block, oldLevel, newLevel);
                        MechanicListenerAdapter.handleDirectWireInput(x, y - 1, z - 1, block, oldLevel, newLevel);
                        MechanicListenerAdapter.handleDirectWireInput(x, y - 1, z + 1, block, oldLevel, newLevel);
                    }
                    MechanicListenerAdapter.handleDirectWireInput(x, y + 1, z, block, oldLevel, newLevel);
                    MechanicListenerAdapter.handleDirectWireInput(x, y - 1, z, block, oldLevel, newLevel);
                }
                return;
            }
            case COMPARATOR: 
            case REPEATER: {
                Directional diode = (Directional)block.getBlockData();
                BlockFace f = diode.getFacing();
                MechanicListenerAdapter.handleDirectWireInput(x + f.getModX(), y, z + f.getModZ(), block, oldLevel, newLevel);
                if (block.getRelative(f).getType() != Material.AIR) {
                    MechanicListenerAdapter.handleDirectWireInput(x + f.getModX(), y - 1, z + f.getModZ(), block, oldLevel, newLevel);
                    MechanicListenerAdapter.handleDirectWireInput(x + f.getModX(), y + 1, z + f.getModZ(), block, oldLevel, newLevel);
                    MechanicListenerAdapter.handleDirectWireInput(x + f.getModX() + 1, y - 1, z + f.getModZ(), block, oldLevel, newLevel);
                    MechanicListenerAdapter.handleDirectWireInput(x + f.getModX() - 1, y - 1, z + f.getModZ(), block, oldLevel, newLevel);
                    MechanicListenerAdapter.handleDirectWireInput(x + f.getModX() + 1, y - 1, z + f.getModZ() + 1, block, oldLevel, newLevel);
                    MechanicListenerAdapter.handleDirectWireInput(x + f.getModX() - 1, y - 1, z + f.getModZ() - 1, block, oldLevel, newLevel);
                }
                return;
            }
            case ACACIA_BUTTON: 
            case BIRCH_BUTTON: 
            case DARK_OAK_BUTTON: 
            case JUNGLE_BUTTON: 
            case OAK_BUTTON: 
            case SPRUCE_BUTTON: 
            case STONE_BUTTON: 
            case LEVER: {
                BlockFace face;
                Directional button = (Directional)block.getBlockData();
                if (button == null || (face = button.getFacing().getOppositeFace()) == null) break;
                MechanicListenerAdapter.handleDirectWireInput(x + face.getModX() * 2, y + face.getModY() * 2, z + face.getModZ() * 2, block, oldLevel, newLevel);
                break;
            }
            case POWERED_RAIL: 
            case ACTIVATOR_RAIL: {
                return;
            }
        }
        MechanicListenerAdapter.handleDirectWireInput(x - 1, y, z, block, oldLevel, newLevel);
        MechanicListenerAdapter.handleDirectWireInput(x + 1, y, z, block, oldLevel, newLevel);
        MechanicListenerAdapter.handleDirectWireInput(x - 1, y - 1, z, block, oldLevel, newLevel);
        MechanicListenerAdapter.handleDirectWireInput(x + 1, y - 1, z, block, oldLevel, newLevel);
        MechanicListenerAdapter.handleDirectWireInput(x, y, z - 1, block, oldLevel, newLevel);
        MechanicListenerAdapter.handleDirectWireInput(x, y, z + 1, block, oldLevel, newLevel);
        MechanicListenerAdapter.handleDirectWireInput(x, y - 1, z - 1, block, oldLevel, newLevel);
        MechanicListenerAdapter.handleDirectWireInput(x, y - 1, z + 1, block, oldLevel, newLevel);
        MechanicListenerAdapter.handleDirectWireInput(x, y + 1, z, block, oldLevel, newLevel);
        MechanicListenerAdapter.handleDirectWireInput(x, y - 1, z, block, oldLevel, newLevel);
    }

    private static void handleDirectWireInput(int x, int y, int z, Block sourceBlock, int oldLevel, int newLevel) {
        Block block = sourceBlock.getWorld().getBlockAt(x, y, z);
        if (CraftBookBukkitUtil.equals(sourceBlock.getLocation(), block.getLocation())) {
            return;
        }
        SourcedBlockRedstoneEvent event = new SourcedBlockRedstoneEvent(sourceBlock, block, oldLevel, newLevel);
        CraftBookPlugin.inst().getServer().getPluginManager().callEvent((Event)event);
        if (CraftBookPlugin.inst().useLegacyCartSystem) {
            CraftBookPlugin.server().getScheduler().runTask((Plugin)CraftBookPlugin.inst(), () -> {
                try {
                    CartMechanismBlocks cmb = CartMechanismBlocks.find(event.getBlock());
                    CartBlockRedstoneEvent ev = new CartBlockRedstoneEvent(event.getBlock(), event.getSource(), event.getOldCurrent(), event.getNewCurrent(), cmb, CartBlockMechanism.getCart(cmb.rail));
                    CraftBookPlugin.inst().getServer().getPluginManager().callEvent((Event)ev);
                }
                catch (InvalidMechanismException invalidMechanismException) {
                    // empty catch block
                }
            });
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onVehicleMove(VehicleMoveEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (CraftBookPlugin.inst().useLegacyCartSystem && event.getVehicle() instanceof Minecart) {
            try {
                Minecart cart = (Minecart)event.getVehicle();
                CartMechanismBlocks cmb = CartMechanismBlocks.findByRail(event.getTo().getBlock());
                cmb.setFromBlock(event.getFrom().getBlock());
                Location from = event.getFrom();
                Location to = event.getTo();
                if (LocationUtil.getDistanceSquared(from, to) > 4.0) {
                    return;
                }
                boolean minor = from.getBlockX() == to.getBlockX() && from.getBlockY() == to.getBlockY() && from.getBlockZ() == to.getBlockZ();
                CartBlockImpactEvent ev = new CartBlockImpactEvent(cart, from, to, cmb, minor);
                CraftBookPlugin.inst().getServer().getPluginManager().callEvent((Event)ev);
            }
            catch (InvalidMechanismException invalidMechanismException) {
                // empty catch block
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onVehicleEnter(VehicleEnterEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (!event.getVehicle().getWorld().isChunkLoaded(event.getVehicle().getLocation().getBlockX() >> 4, event.getVehicle().getLocation().getBlockZ() >> 4)) {
            return;
        }
        if (CraftBookPlugin.inst().useLegacyCartSystem && event.getVehicle() instanceof Minecart) {
            try {
                Minecart cart = (Minecart)event.getVehicle();
                Block block = event.getVehicle().getLocation().getBlock();
                CartMechanismBlocks cmb = CartMechanismBlocks.findByRail(block);
                cmb.setFromBlock(block);
                CartBlockEnterEvent ev = new CartBlockEnterEvent((Vehicle)cart, event.getEntered(), cmb);
                CraftBookPlugin.inst().getServer().getPluginManager().callEvent((Event)ev);
                if (ev.isCancelled()) {
                    event.setCancelled(true);
                }
            }
            catch (InvalidMechanismException invalidMechanismException) {
                // empty catch block
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onSignChange(SignChangeEvent event) {
        for (int i = 0; i < 4; ++i) {
            String line = event.getLine(i);
            if (!line.startsWith("&0") && !line.startsWith("\u00a70")) continue;
            line = line.substring(2);
            event.setLine(i, line);
        }
    }
}

