/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.bukkit;

import com.google.common.collect.Sets;
import com.sk89q.bukkit.util.CommandsManagerRegistration;
import com.sk89q.craftbook.CraftBookMechanic;
import com.sk89q.craftbook.CraftBookPlayer;
import com.sk89q.craftbook.bukkit.BukkitConfiguration;
import com.sk89q.craftbook.bukkit.BukkitCraftBookPlayer;
import com.sk89q.craftbook.bukkit.MechanicListenerAdapter;
import com.sk89q.craftbook.bukkit.commands.TopLevelCommands;
import com.sk89q.craftbook.bukkit.util.CraftBookBukkitUtil;
import com.sk89q.craftbook.core.LanguageManager;
import com.sk89q.craftbook.core.st.MechanicClock;
import com.sk89q.craftbook.core.st.SelfTriggeringManager;
import com.sk89q.craftbook.mechanics.AIMechanic;
import com.sk89q.craftbook.mechanics.Ammeter;
import com.sk89q.craftbook.mechanics.BetterLeads;
import com.sk89q.craftbook.mechanics.BetterPhysics;
import com.sk89q.craftbook.mechanics.BetterPistons;
import com.sk89q.craftbook.mechanics.BetterPlants;
import com.sk89q.craftbook.mechanics.Bookcase;
import com.sk89q.craftbook.mechanics.BounceBlocks;
import com.sk89q.craftbook.mechanics.Chair;
import com.sk89q.craftbook.mechanics.ChunkAnchor;
import com.sk89q.craftbook.mechanics.CommandSigns;
import com.sk89q.craftbook.mechanics.CookingPot;
import com.sk89q.craftbook.mechanics.Elevator;
import com.sk89q.craftbook.mechanics.Footprints;
import com.sk89q.craftbook.mechanics.GlowStone;
import com.sk89q.craftbook.mechanics.HiddenSwitch;
import com.sk89q.craftbook.mechanics.JackOLantern;
import com.sk89q.craftbook.mechanics.LightStone;
import com.sk89q.craftbook.mechanics.LightSwitch;
import com.sk89q.craftbook.mechanics.MapChanger;
import com.sk89q.craftbook.mechanics.Marquee;
import com.sk89q.craftbook.mechanics.Netherrack;
import com.sk89q.craftbook.mechanics.PaintingSwitch;
import com.sk89q.craftbook.mechanics.Payment;
import com.sk89q.craftbook.mechanics.RedstoneJukebox;
import com.sk89q.craftbook.mechanics.Snow;
import com.sk89q.craftbook.mechanics.Sponge;
import com.sk89q.craftbook.mechanics.Teleporter;
import com.sk89q.craftbook.mechanics.TreeLopper;
import com.sk89q.craftbook.mechanics.XPStorer;
import com.sk89q.craftbook.mechanics.area.Area;
import com.sk89q.craftbook.mechanics.area.simple.Bridge;
import com.sk89q.craftbook.mechanics.area.simple.Door;
import com.sk89q.craftbook.mechanics.area.simple.Gate;
import com.sk89q.craftbook.mechanics.boat.Drops;
import com.sk89q.craftbook.mechanics.boat.LandBoats;
import com.sk89q.craftbook.mechanics.boat.RemoveEntities;
import com.sk89q.craftbook.mechanics.boat.SpeedModifiers;
import com.sk89q.craftbook.mechanics.boat.Uncrashable;
import com.sk89q.craftbook.mechanics.boat.WaterPlaceOnly;
import com.sk89q.craftbook.mechanics.cauldron.ImprovedCauldron;
import com.sk89q.craftbook.mechanics.cauldron.legacy.Cauldron;
import com.sk89q.craftbook.mechanics.crafting.CustomCrafting;
import com.sk89q.craftbook.mechanics.dispenser.DispenserRecipes;
import com.sk89q.craftbook.mechanics.drops.CustomDrops;
import com.sk89q.craftbook.mechanics.drops.legacy.LegacyCustomDrops;
import com.sk89q.craftbook.mechanics.headdrops.HeadDrops;
import com.sk89q.craftbook.mechanics.ic.ICMechanic;
import com.sk89q.craftbook.mechanics.items.CommandItemDefinition;
import com.sk89q.craftbook.mechanics.items.CommandItems;
import com.sk89q.craftbook.mechanics.minecart.CollisionEntry;
import com.sk89q.craftbook.mechanics.minecart.ConstantSpeed;
import com.sk89q.craftbook.mechanics.minecart.EmptyDecay;
import com.sk89q.craftbook.mechanics.minecart.EmptySlowdown;
import com.sk89q.craftbook.mechanics.minecart.ExitRemover;
import com.sk89q.craftbook.mechanics.minecart.FallModifier;
import com.sk89q.craftbook.mechanics.minecart.ItemPickup;
import com.sk89q.craftbook.mechanics.minecart.MobBlocker;
import com.sk89q.craftbook.mechanics.minecart.MoreRails;
import com.sk89q.craftbook.mechanics.minecart.NoCollide;
import com.sk89q.craftbook.mechanics.minecart.PlaceAnywhere;
import com.sk89q.craftbook.mechanics.minecart.RailPlacer;
import com.sk89q.craftbook.mechanics.minecart.TemporaryCart;
import com.sk89q.craftbook.mechanics.minecart.VisionSteering;
import com.sk89q.craftbook.mechanics.minecart.blocks.CartBlockMechanism;
import com.sk89q.craftbook.mechanics.minecart.blocks.CartBooster;
import com.sk89q.craftbook.mechanics.minecart.blocks.CartDeposit;
import com.sk89q.craftbook.mechanics.minecart.blocks.CartDispenser;
import com.sk89q.craftbook.mechanics.minecart.blocks.CartEjector;
import com.sk89q.craftbook.mechanics.minecart.blocks.CartLift;
import com.sk89q.craftbook.mechanics.minecart.blocks.CartMaxSpeed;
import com.sk89q.craftbook.mechanics.minecart.blocks.CartMessenger;
import com.sk89q.craftbook.mechanics.minecart.blocks.CartReverser;
import com.sk89q.craftbook.mechanics.minecart.blocks.CartSorter;
import com.sk89q.craftbook.mechanics.minecart.blocks.CartStation;
import com.sk89q.craftbook.mechanics.minecart.blocks.CartTeleporter;
import com.sk89q.craftbook.mechanics.pipe.Pipes;
import com.sk89q.craftbook.mechanics.signcopier.SignCopier;
import com.sk89q.craftbook.mechanics.variables.VariableManager;
import com.sk89q.craftbook.util.ArrayUtil;
import com.sk89q.craftbook.util.CompatabilityUtil;
import com.sk89q.craftbook.util.ItemSyntax;
import com.sk89q.craftbook.util.RegexUtil;
import com.sk89q.craftbook.util.UUIDMappings;
import com.sk89q.craftbook.util.compat.companion.CompanionPlugins;
import com.sk89q.craftbook.util.compat.nms.NMSAdapter;
import com.sk89q.craftbook.util.persistent.PersistentStorage;
import com.sk89q.minecraft.util.commands.CommandException;
import com.sk89q.minecraft.util.commands.CommandPermissionsException;
import com.sk89q.minecraft.util.commands.CommandUsageException;
import com.sk89q.minecraft.util.commands.CommandsManager;
import com.sk89q.minecraft.util.commands.Injector;
import com.sk89q.minecraft.util.commands.MissingNestedCommandException;
import com.sk89q.minecraft.util.commands.SimpleInjector;
import com.sk89q.minecraft.util.commands.WrappedCommandException;
import com.sk89q.util.yaml.YAMLFormat;
import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.wepif.PermissionsResolverManager;
import io.papermc.lib.PaperLib;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import javax.annotation.Nullable;
import org.bstats.bukkit.Metrics;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class CraftBookPlugin
extends JavaPlugin {
    public static CompanionPlugins plugins;
    private static CraftBookPlugin instance;
    private LanguageManager languageManager;
    private Random random;
    private CommandsManager<CommandSender> commands;
    private BukkitConfiguration config;
    private MechanicListenerAdapter managerAdapter;
    private MechanicClock mechanicClock;
    private PersistentStorage persistentStorage;
    private UUIDMappings uuidMappings;
    private List<CraftBookMechanic> mechanics;
    private SelfTriggeringManager selfTriggerManager;
    private NMSAdapter nmsAdapter;
    public static final Map<String, Class<? extends CraftBookMechanic>> availableMechanics;
    public boolean useLegacyCartSystem = false;
    private YAMLProcessor mechanismsConfig;
    private static PrintWriter debugLogger;

    public CraftBookPlugin() {
        instance = this;
    }

    @Nullable
    public static String getVersion() {
        return null;
    }

    public List<CraftBookMechanic> getMechanics() {
        return this.mechanics;
    }

    public boolean isMechanicEnabled(Class<? extends CraftBookMechanic> clazz) {
        for (CraftBookMechanic mech : this.mechanics) {
            if (!mech.getClass().equals(clazz)) continue;
            return true;
        }
        return false;
    }

    public CraftBookMechanic getMechanic(Class<? extends CraftBookMechanic> clazz) {
        for (CraftBookMechanic mech : this.mechanics) {
            if (!mech.getClass().equals(clazz)) continue;
            return mech;
        }
        return null;
    }

    public UUIDMappings getUUIDMappings() {
        return this.uuidMappings;
    }

    public NMSAdapter getNmsAdapter() {
        return this.nmsAdapter;
    }

    public void setNmsAdapter(NMSAdapter nmsAdapter) {
        this.nmsAdapter = nmsAdapter;
    }

    public void onEnable() {
        ItemSyntax.plugin = this;
        this.nmsAdapter = new NMSAdapter();
        plugins = new CompanionPlugins();
        plugins.initiate(this);
        this.getDataFolder().mkdirs();
        this.createDefaultConfiguration(new File(this.getDataFolder(), "config.yml"), "config.yml");
        this.config = new BukkitConfiguration(new YAMLProcessor(new File(this.getDataFolder(), "config.yml"), true, YAMLFormat.EXTENDED), CraftBookPlugin.logger());
        try {
            this.config.load();
        }
        catch (Throwable e) {
            this.getLogger().severe("Failed to load CraftBook Configuration File! Is it corrupt?");
            this.getLogger().severe(CraftBookPlugin.getStackTrace(e));
            this.getLogger().severe("Disabling CraftBook due to invalid Configuration File!");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.persistentStorage = PersistentStorage.createFromType(this.config.persistentStorageType);
        if (this.persistentStorage != null) {
            this.persistentStorage.open();
        }
        this.uuidMappings = new UUIDMappings();
        this.uuidMappings.enable();
        CraftBookPlugin.logDebugMessage("Initializing Managers!", "startup");
        this.managerAdapter = new MechanicListenerAdapter();
        CraftBookPlugin.logDebugMessage("Initializing Permission!", "startup");
        PermissionsResolverManager.initialize((Plugin)this);
        CraftBookPlugin.logDebugMessage("Initializing Commands!", "startup");
        this.commands = new CommandsManager<CommandSender>(){

            public boolean hasPermission(CommandSender player, String perm) {
                return CraftBookPlugin.inst().hasPermission(player, perm);
            }
        };
        this.commands.setInjector((Injector)new SimpleInjector(new Object[]{this}));
        CommandsManagerRegistration reg = new CommandsManagerRegistration((Plugin)this, this.commands);
        reg.register(TopLevelCommands.class);
        if (this.config.realisticRandoms) {
            try {
                this.random = SecureRandom.getInstance("SHA1PRNG");
            }
            catch (NoSuchAlgorithmException e1) {
                this.getLogger().severe(CraftBookPlugin.getStackTrace(e1));
            }
        }
        this.setupCraftBook();
        this.registerGlobalEvents();
        this.getServer().getPluginManager().registerEvents(new Listener(){

            @EventHandler(priority=EventPriority.LOWEST)
            public void signChange(SignChangeEvent event) {
                for (int i = 0; i < event.getLines().length; ++i) {
                    StringBuilder builder = new StringBuilder();
                    for (char c : event.getLine(i).toCharArray()) {
                        if (c >= '\uf700' && c <= '\uf747') continue;
                        builder.append(c);
                    }
                    String fixed = builder.toString();
                    if (fixed.equals(event.getLine(i))) continue;
                    event.setLine(i, fixed);
                }
            }

            @EventHandler(priority=EventPriority.HIGH)
            public void playerJoin(PlayerJoinEvent event) {
                if (!event.getPlayer().isOp()) {
                    return;
                }
                boolean foundAMech = false;
                for (CraftBookMechanic mech : CraftBookPlugin.this.getMechanics()) {
                    if (mech instanceof VariableManager) continue;
                    foundAMech = true;
                    break;
                }
                if (!foundAMech) {
                    event.getPlayer().sendMessage(ChatColor.RED + "[CraftBook] Warning! You have no mechanics enabled, the plugin will appear to do nothing until a feature is enabled!");
                }
            }
        }, (Plugin)this);
        boolean foundAMech = false;
        for (CraftBookMechanic mech : this.mechanics) {
            if (mech instanceof VariableManager) continue;
            foundAMech = true;
            break;
        }
        if (!foundAMech) {
            Bukkit.getScheduler().runTaskTimer((Plugin)this, () -> this.getLogger().warning(ChatColor.RED + "Warning! You have no mechanics enabled, the plugin will appear to do nothing until a feature is enabled!"), 20L, 6000L);
        }
        PaperLib.suggestPaper((Plugin)this);
    }

    public void setupCraftBook() {
        if (this.config.debugLogToFile) {
            try {
                debugLogger = new PrintWriter(new File(this.getDataFolder(), "debug.log"));
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
            }
        }
        CraftBookPlugin.logDebugMessage("Initializing Languages!", "startup");
        this.languageManager = new LanguageManager();
        this.languageManager.init();
        this.getServer().getScheduler().runTask((Plugin)this, CompatabilityUtil::init);
        this.mechanics = new ArrayList<CraftBookMechanic>();
        CraftBookPlugin.logDebugMessage("Initializing Mechanisms!", "startup");
        this.createDefaultConfiguration(new File(this.getDataFolder(), "mechanisms.yml"), "mechanisms.yml");
        this.mechanismsConfig = new YAMLProcessor(new File(this.getDataFolder(), "mechanisms.yml"), true, YAMLFormat.EXTENDED);
        try {
            this.mechanismsConfig.load();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.mechanismsConfig.setWriteDefaults(true);
        this.mechanismsConfig.setHeader(new String[]{"# CraftBook Mechanism Configuration. Generated for version: " + (CraftBookPlugin.inst() == null ? CraftBookPlugin.getVersion() : CraftBookPlugin.inst().getDescription().getVersion()), "# This configuration will automatically add new configuration options for you,", "# So there is no need to regenerate this configuration unless you need to.", "# More information about these features are available at...", "# " + CraftBookPlugin.getWikiDomain() + "/Usage", "#", "# NOTE! MAKE SURE TO ENABLE FEATURES IN THE config.yml FILE!", ""});
        for (String enabled : Sets.newHashSet(this.config.enabledMechanics)) {
            Class<? extends CraftBookMechanic> mechClass = availableMechanics.get(enabled);
            try {
                if (mechClass == null) continue;
                CraftBookMechanic mech = mechClass.newInstance();
                mech.loadConfiguration(this.mechanismsConfig, "mechanics." + enabled + '.');
                this.mechanics.add(mech);
            }
            catch (Throwable t) {
                this.getLogger().log(Level.WARNING, "Failed to load mechanic: " + enabled, t);
            }
        }
        this.mechanismsConfig.save();
        boolean hasSTMechanic = false;
        Iterator<CraftBookMechanic> iter = this.mechanics.iterator();
        while (iter.hasNext()) {
            CraftBookMechanic mech = iter.next();
            try {
                if (!mech.enable()) {
                    this.getLogger().warning("Failed to enable mechanic: " + mech.getClass().getSimpleName());
                    mech.disable();
                    iter.remove();
                    continue;
                }
                this.getServer().getPluginManager().registerEvents((Listener)mech, (Plugin)this);
                if (mech instanceof CookingPot || mech instanceof ICMechanic && !((ICMechanic)mech).disableSelfTriggered) {
                    hasSTMechanic = true;
                }
                if (!(mech instanceof CartBlockMechanism)) continue;
                this.useLegacyCartSystem = true;
            }
            catch (Throwable t) {
                this.getLogger().log(Level.WARNING, "Failed to enable mechanic: " + mech.getClass().getSimpleName(), t);
            }
        }
        if (hasSTMechanic) {
            this.setupSelfTriggered();
        }
    }

    public boolean enableMechanic(String mechanic) {
        try {
            this.mechanismsConfig.load();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.mechanismsConfig.setHeader(new String[]{"# CraftBook Mechanism Configuration. Generated for version: " + (CraftBookPlugin.inst() == null ? CraftBookPlugin.getVersion() : CraftBookPlugin.inst().getDescription().getVersion()), "# This configuration will automatically add new configuration options for you,", "# So there is no need to regenerate this configuration unless you need to.", "# More information about these features are available at...", "# " + CraftBookPlugin.getWikiDomain() + "/Usage", "#", "# NOTE! MAKE SURE TO ENABLE FEATURES IN THE config.yml FILE!", ""});
        Class<? extends CraftBookMechanic> mechClass = availableMechanics.get(mechanic);
        try {
            CraftBookMechanic mech;
            if (mechClass != null) {
                mech = mechClass.newInstance();
                mech.loadConfiguration(this.mechanismsConfig, "mechanics." + mechanic + '.');
                this.mechanics.add(mech);
                if (!mech.enable()) {
                    this.getLogger().warning("Failed to enable mechanic: " + mech.getClass().getSimpleName());
                    mech.disable();
                    return false;
                }
            } else {
                return false;
            }
            this.getServer().getPluginManager().registerEvents((Listener)mech, (Plugin)this);
        }
        catch (Throwable t) {
            this.getLogger().log(Level.WARNING, "Failed to load mechanic: " + mechanic, t);
            return false;
        }
        this.mechanismsConfig.save();
        this.config.save();
        return true;
    }

    public boolean disableMechanic(String mechanic) {
        Class<? extends CraftBookMechanic> mechClass = availableMechanics.get(mechanic);
        if (mechClass == null) {
            return false;
        }
        boolean found = false;
        for (CraftBookMechanic mech : this.mechanics) {
            if (!mech.getClass().equals(mechClass)) continue;
            found = true;
            break;
        }
        if (!found) {
            return false;
        }
        this.config.enabledMechanics.remove(mechanic);
        this.config.save();
        return true;
    }

    public void registerGlobalEvents() {
        CraftBookPlugin.logDebugMessage("Registring managers!", "startup");
        this.getServer().getPluginManager().registerEvents((Listener)this.managerAdapter, (Plugin)CraftBookPlugin.inst());
        if (this.config.easterEggs) {
            Bukkit.getScheduler().runTaskLater((Plugin)this, new Runnable(){

                @Override
                public void run() {
                    CraftBookPlugin.logDebugMessage("Checking easter eggs!", "startup");
                    Calendar date = Calendar.getInstance();
                    if (date.get(2) == 5 && date.get(5) == 22) {
                        CraftBookPlugin.this.getLogger().info("Happy " + this.formatDate(date.get(1) - 2012) + " reddit cakeday me4502!");
                    } else if (date.get(2) == 9 && date.get(5) == 16) {
                        CraftBookPlugin.this.getLogger().info("Happy birthday me4502!");
                    } else if (date.get(2) == 0 && date.get(5) == 1) {
                        CraftBookPlugin.this.getLogger().info("Happy new years! Happy " + date.get(1) + "!!!");
                    } else if (date.get(2) == 9 && date.get(5) == 22) {
                        CraftBookPlugin.this.getLogger().info("Happy " + this.formatDate(date.get(1) - 2010) + " birthday CraftBook!");
                    } else if (date.get(2) == 3 && date.get(5) == 24) {
                        CraftBookPlugin.this.getLogger().info("CraftBook has been under Me4502's 'harsh dictatorship :P' for " + (date.get(1) - 2012) + " year(s) today!");
                    }
                }

                private String formatDate(int date) {
                    if (String.valueOf(date).endsWith("1")) {
                        return date + "st";
                    }
                    if (String.valueOf(date).endsWith("2")) {
                        return date + "nd";
                    }
                    if (String.valueOf(date).endsWith("3")) {
                        return date + "rd";
                    }
                    return date + "th";
                }
            }, 20L);
        }
        try {
            CraftBookPlugin.logDebugMessage("Initializing Metrics!", "startup");
            Metrics metrics = new Metrics((Plugin)this);
            metrics.addCustomChart((Metrics.CustomChart)new Metrics.AdvancedPie("language", () -> this.languageManager.getLanguages().stream().collect(Collectors.toMap(Function.identity(), o -> 1))));
            metrics.addCustomChart((Metrics.CustomChart)new Metrics.SimpleBarChart("enabled_mechanics", () -> this.mechanics.stream().collect(Collectors.toMap(mech -> mech.getClass().getSimpleName(), o -> 1))));
        }
        catch (Throwable e1) {
            CraftBookBukkitUtil.printStacktrace(e1);
        }
    }

    public void onDisable() {
        if (this.languageManager != null) {
            this.languageManager.close();
        }
        if (this.mechanics != null) {
            for (CraftBookMechanic mech : this.mechanics) {
                mech.disable();
            }
            this.mechanics = null;
        }
        if (this.hasPersistentStorage()) {
            this.persistentStorage.close();
        }
        if (this.uuidMappings != null) {
            this.uuidMappings.disable();
        }
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        try {
            this.commands.execute(cmd.getName(), args, (Object)sender, new Object[]{sender});
        }
        catch (CommandPermissionsException e) {
            sender.sendMessage(ChatColor.RED + "You don't have permission.");
        }
        catch (MissingNestedCommandException e) {
            sender.sendMessage(ChatColor.RED + e.getUsage());
        }
        catch (CommandUsageException e) {
            sender.sendMessage(ChatColor.RED + e.getMessage());
            sender.sendMessage(ChatColor.RED + e.getUsage());
        }
        catch (WrappedCommandException e) {
            if (e.getCause() instanceof NumberFormatException) {
                sender.sendMessage(ChatColor.RED + "Number expected, string received instead.");
            } else {
                sender.sendMessage(ChatColor.RED + "An error has occurred. See console.");
                e.printStackTrace();
            }
        }
        catch (CommandException e) {
            sender.sendMessage(ChatColor.RED + e.getMessage());
        }
        return true;
    }

    public static CraftBookPlugin inst() {
        return instance;
    }

    public static void setInstance(CraftBookPlugin instance) throws IllegalArgumentException {
        if (CraftBookPlugin.instance != null) {
            throw new IllegalArgumentException("Instance already set!");
        }
        CraftBookPlugin.instance = instance;
    }

    public static Logger logger() {
        return CraftBookPlugin.inst().getLogger();
    }

    public static Server server() {
        return CraftBookPlugin.inst().getServer();
    }

    private void setupSelfTriggered() {
        this.mechanicClock = new MechanicClock();
        this.selfTriggerManager = new SelfTriggeringManager();
        this.getLogger().info("Enumerating chunks for self-triggered components...");
        long start = System.currentTimeMillis();
        int numWorlds = 0;
        int numChunks = 0;
        for (World world : this.getServer().getWorlds()) {
            for (Chunk chunk : world.getLoadedChunks()) {
                this.selfTriggerManager.registerSelfTrigger(chunk);
                ++numChunks;
            }
            ++numWorlds;
        }
        long time = System.currentTimeMillis() - start;
        this.getLogger().info(numChunks + " chunk(s) for " + numWorlds + " world(s) processed (" + time + "ms elapsed)");
        this.getServer().getScheduler().runTaskTimer((Plugin)this, (Runnable)this.mechanicClock, 0L, (long)this.config.stThinkRate);
        this.getServer().getPluginManager().registerEvents((Listener)this.selfTriggerManager, (Plugin)this);
    }

    public static void registerEvents(Listener ... listeners) {
        for (Listener listener : listeners) {
            CraftBookPlugin.inst().getServer().getPluginManager().registerEvents(listener, (Plugin)CraftBookPlugin.inst());
        }
    }

    public void registerCommands(Class<?> clazz) {
        CommandsManagerRegistration reg = new CommandsManagerRegistration((Plugin)this, this.commands);
        reg.register(clazz);
    }

    public BukkitConfiguration getConfiguration() {
        return this.config;
    }

    public YAMLProcessor getMechanismsConfig() {
        return this.mechanismsConfig;
    }

    public LanguageManager getLanguageManager() {
        return this.languageManager;
    }

    public Random getRandom() {
        if (this.random == null) {
            return ThreadLocalRandom.current();
        }
        return this.random;
    }

    public boolean inGroup(Player player, String group) {
        try {
            return PermissionsResolverManager.getInstance().inGroup((OfflinePlayer)player, group);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return false;
        }
    }

    public String[] getGroups(Player player) {
        try {
            return PermissionsResolverManager.getInstance().getGroups((OfflinePlayer)player);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return ArrayUtil.EMPTY_STRINGS;
        }
    }

    public String toUniqueName(CommandSender sender) {
        if (sender instanceof ConsoleCommandSender) {
            return "*Console*";
        }
        return sender.getName();
    }

    public String toName(CommandSender sender) {
        if (sender instanceof ConsoleCommandSender) {
            return "*Console*";
        }
        if (sender instanceof Player) {
            return ((Player)sender).getDisplayName();
        }
        return sender.getName();
    }

    public boolean hasPermission(CommandSender sender, String perm) {
        if (sender.isOp()) {
            if (sender instanceof Player) {
                if (!this.config.noOpPermissions) {
                    return true;
                }
            } else {
                return true;
            }
        }
        if (sender instanceof Player) {
            Player player = (Player)sender;
            return PermissionsResolverManager.getInstance().hasPermission(player.getWorld().getName(), (OfflinePlayer)player, perm);
        }
        return false;
    }

    public void checkPermission(CommandSender sender, String perm) throws CommandPermissionsException {
        if (!this.hasPermission(sender, perm)) {
            throw new CommandPermissionsException();
        }
    }

    public static Player checkPlayer(CommandSender sender) throws CommandException {
        if (sender instanceof Player) {
            return (Player)sender;
        }
        throw new CommandException("A player is expected.");
    }

    public CraftBookPlayer wrapPlayer(Player player) {
        return new BukkitCraftBookPlayer(this, player);
    }

    public SelfTriggeringManager getSelfTriggerManager() {
        return this.selfTriggerManager;
    }

    public void reloadConfiguration() throws Throwable {
        if (this.mechanics != null) {
            for (CraftBookMechanic mech : this.mechanics) {
                mech.disable();
            }
        }
        this.mechanics = null;
        this.getServer().getScheduler().cancelTasks((Plugin)CraftBookPlugin.inst());
        HandlerList.unregisterAll((Plugin)CraftBookPlugin.inst());
        if (this.config.debugLogToFile) {
            debugLogger.close();
            debugLogger = null;
        }
        this.config.load();
        this.managerAdapter = new MechanicListenerAdapter();
        this.mechanicClock = new MechanicClock();
        this.setupCraftBook();
        this.registerGlobalEvents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDefaultConfiguration(File actual, String defaultName) {
        File parent = actual.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        if (actual.exists()) {
            return;
        }
        InputStream input = null;
        JarFile file = null;
        try {
            file = new JarFile(this.getFile());
            ZipEntry copy = file.getEntry("defaults/" + defaultName);
            if (copy == null) {
                file.close();
                throw new FileNotFoundException();
            }
            input = file.getInputStream(copy);
        }
        catch (IOException e) {
            this.getLogger().severe("Unable to read default configuration: " + defaultName);
        }
        if (input != null) {
            FileOutputStream output = null;
            try {
                output = new FileOutputStream(actual);
                byte[] buf = new byte[8192];
                int length = 0;
                while ((length = input.read(buf)) > 0) {
                    output.write(buf, 0, length);
                }
                this.getLogger().info("Default configuration file written: " + actual.getAbsolutePath());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    file.close();
                }
                catch (IOException iOException) {}
                try {
                    input.close();
                }
                catch (IOException iOException) {}
                try {
                    if (output != null) {
                        output.close();
                    }
                }
                catch (IOException iOException) {}
            }
        } else if (file != null) {
            try {
                file.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public File getFile() {
        return super.getFile();
    }

    public static String getStackTrace(Throwable ex) {
        StringWriter out = new StringWriter();
        PrintWriter pw = new PrintWriter(out);
        ex.printStackTrace(pw);
        return ((Object)out).toString();
    }

    public static boolean isDebugFlagEnabled(String flag) {
        if (CraftBookPlugin.inst() == null) {
            return false;
        }
        if (!CraftBookPlugin.inst().config.debugMode || CraftBookPlugin.inst().config.debugFlags == null || CraftBookPlugin.inst().config.debugFlags.isEmpty()) {
            return false;
        }
        String[] flagBits = RegexUtil.PERIOD_PATTERN.split(flag);
        String tempFlag = "";
        for (int i = 0; i < flagBits.length; ++i) {
            tempFlag = i == 0 ? flagBits[i] : tempFlag + "." + flagBits[i];
            for (String testflag : CraftBookPlugin.inst().config.debugFlags) {
                if (!testflag.toLowerCase(Locale.ENGLISH).equals(tempFlag)) continue;
                return true;
            }
        }
        return false;
    }

    public static void logDebugMessage(String message, String code) {
        if (!CraftBookPlugin.isDebugFlagEnabled(code)) {
            return;
        }
        CraftBookPlugin.logger().info("[Debug][" + code + "] " + message);
        if (CraftBookPlugin.inst().config.debugLogToFile) {
            debugLogger.println("[" + code + "] " + message);
        }
    }

    public boolean hasPersistentStorage() {
        return this.persistentStorage != null && this.persistentStorage.isValid();
    }

    public PersistentStorage getPersistentStorage() {
        return this.persistentStorage;
    }

    public void setPersistentStorage(PersistentStorage storage) {
        this.persistentStorage = storage;
        this.config.persistentStorageType = storage.getType();
        this.config.config.setProperty("persistent-storage-type", (Object)storage.getType());
        this.config.config.save();
    }

    public final String parseItemSyntax(String item) {
        CommandItemDefinition def;
        if (CommandItems.INSTANCE != null && (def = CommandItems.INSTANCE.getDefinitionByName(item)) != null) {
            return ItemSyntax.getStringFromItem(def.getItem());
        }
        return item;
    }

    public static String getWikiDomain() {
        return "http://wiki.sk89q.com/wiki/CraftBook";
    }

    static {
        availableMechanics = new TreeMap<String, Class<? extends CraftBookMechanic>>();
        availableMechanics.put("Variables", VariableManager.class);
        availableMechanics.put("CommandItems", CommandItems.class);
        availableMechanics.put("CustomCrafting", CustomCrafting.class);
        availableMechanics.put("DispenserRecipes", DispenserRecipes.class);
        availableMechanics.put("Snow", Snow.class);
        availableMechanics.put("CustomDrops", CustomDrops.class);
        availableMechanics.put("LegacyCustomDrops", LegacyCustomDrops.class);
        availableMechanics.put("AI", AIMechanic.class);
        availableMechanics.put("PaintingSwitcher", PaintingSwitch.class);
        availableMechanics.put("BetterPhysics", BetterPhysics.class);
        availableMechanics.put("HeadDrops", HeadDrops.class);
        availableMechanics.put("BetterLeads", BetterLeads.class);
        availableMechanics.put("Marquee", Marquee.class);
        availableMechanics.put("TreeLopper", TreeLopper.class);
        availableMechanics.put("MapChanger", MapChanger.class);
        availableMechanics.put("XPStorer", XPStorer.class);
        availableMechanics.put("LightStone", LightStone.class);
        availableMechanics.put("CommandSigns", CommandSigns.class);
        availableMechanics.put("LightSwitch", LightSwitch.class);
        availableMechanics.put("ChunkAnchor", ChunkAnchor.class);
        availableMechanics.put("Ammeter", Ammeter.class);
        availableMechanics.put("HiddenSwitch", HiddenSwitch.class);
        availableMechanics.put("Bookcase", Bookcase.class);
        availableMechanics.put("SignCopier", SignCopier.class);
        availableMechanics.put("Bridge", Bridge.class);
        availableMechanics.put("Door", Door.class);
        availableMechanics.put("Elevator", Elevator.class);
        availableMechanics.put("Teleporter", Teleporter.class);
        availableMechanics.put("ToggleArea", Area.class);
        availableMechanics.put("Cauldron", ImprovedCauldron.class);
        availableMechanics.put("LegacyCauldron", Cauldron.class);
        availableMechanics.put("Gate", Gate.class);
        availableMechanics.put("BetterPistons", BetterPistons.class);
        availableMechanics.put("CookingPot", CookingPot.class);
        availableMechanics.put("Sponge", Sponge.class);
        availableMechanics.put("BetterPlants", BetterPlants.class);
        availableMechanics.put("Chairs", Chair.class);
        availableMechanics.put("Footprints", Footprints.class);
        availableMechanics.put("Pay", Payment.class);
        availableMechanics.put("Jukebox", RedstoneJukebox.class);
        availableMechanics.put("Glowstone", GlowStone.class);
        availableMechanics.put("Netherrack", Netherrack.class);
        availableMechanics.put("JackOLantern", JackOLantern.class);
        availableMechanics.put("Pipes", Pipes.class);
        availableMechanics.put("BounceBlocks", BounceBlocks.class);
        availableMechanics.put("ICs", ICMechanic.class);
        availableMechanics.put("MinecartBooster", CartBooster.class);
        availableMechanics.put("MinecartReverser", CartReverser.class);
        availableMechanics.put("MinecartSorter", CartSorter.class);
        availableMechanics.put("MinecartStation", CartStation.class);
        availableMechanics.put("MinecartEjector", CartEjector.class);
        availableMechanics.put("MinecartDeposit", CartDeposit.class);
        availableMechanics.put("MinecartTeleporter", CartTeleporter.class);
        availableMechanics.put("MinecartElevator", CartLift.class);
        availableMechanics.put("MinecartDispenser", CartDispenser.class);
        availableMechanics.put("MinecartMessenger", CartMessenger.class);
        availableMechanics.put("MinecartMaxSpeed", CartMaxSpeed.class);
        availableMechanics.put("MinecartMoreRails", MoreRails.class);
        availableMechanics.put("MinecartRemoveEntities", com.sk89q.craftbook.mechanics.minecart.RemoveEntities.class);
        availableMechanics.put("MinecartVisionSteering", VisionSteering.class);
        availableMechanics.put("MinecartDecay", EmptyDecay.class);
        availableMechanics.put("MinecartMobBlocker", MobBlocker.class);
        availableMechanics.put("MinecartExitRemover", ExitRemover.class);
        availableMechanics.put("MinecartCollisionEntry", CollisionEntry.class);
        availableMechanics.put("MinecartItemPickup", ItemPickup.class);
        availableMechanics.put("MinecartFallModifier", FallModifier.class);
        availableMechanics.put("MinecartConstantSpeed", ConstantSpeed.class);
        availableMechanics.put("MinecartRailPlacer", RailPlacer.class);
        availableMechanics.put("MinecartSpeedModifiers", com.sk89q.craftbook.mechanics.minecart.SpeedModifiers.class);
        availableMechanics.put("MinecartEmptySlowdown", EmptySlowdown.class);
        availableMechanics.put("MinecartNoCollide", NoCollide.class);
        availableMechanics.put("MinecartPlaceAnywhere", PlaceAnywhere.class);
        availableMechanics.put("MinecartTemporaryCart", TemporaryCart.class);
        availableMechanics.put("BoatRemoveEntities", RemoveEntities.class);
        availableMechanics.put("BoatUncrashable", Uncrashable.class);
        availableMechanics.put("BoatDrops", Drops.class);
        availableMechanics.put("BoatDecay", com.sk89q.craftbook.mechanics.boat.EmptyDecay.class);
        availableMechanics.put("BoatSpeedModifiers", SpeedModifiers.class);
        availableMechanics.put("LandBoats", LandBoats.class);
        availableMechanics.put("BoatExitRemover", com.sk89q.craftbook.mechanics.boat.ExitRemover.class);
        availableMechanics.put("BoatWaterPlaceOnly", WaterPlaceOnly.class);
    }
}

