/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.bukkit;

import com.sk89q.craftbook.CraftBookPlayer;
import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import com.sk89q.craftbook.bukkit.util.CraftBookBukkitUtil;
import com.sk89q.craftbook.core.LanguageManager;
import com.sk89q.worldedit.bukkit.BukkitPlayer;
import com.sk89q.worldedit.util.HandSide;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.item.ItemType;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public final class BukkitCraftBookPlayer
extends BukkitPlayer
implements CraftBookPlayer {
    protected final CraftBookPlugin plugin;
    protected final Player player;

    public BukkitCraftBookPlayer(CraftBookPlugin plugin, Player player) {
        super(CraftBookPlugin.plugins.getWorldEdit(), player);
        this.plugin = plugin;
        this.player = player;
    }

    public void print(String message) {
        this.player.sendMessage(ChatColor.GOLD + ChatColor.translateAlternateColorCodes((char)'&', (String)this.translate(message)));
    }

    public void printError(String message) {
        this.player.sendMessage(ChatColor.RED + ChatColor.translateAlternateColorCodes((char)'&', (String)this.translate(message)));
    }

    public void printRaw(String message) {
        this.player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.translate(message)));
    }

    public boolean hasPermission(String perm) {
        return this.plugin.hasPermission((CommandSender)this.player, perm);
    }

    @Override
    public void teleport(Location location) {
        this.player.teleport(CraftBookBukkitUtil.toLocation(location));
    }

    @Override
    public boolean isInsideVehicle() {
        return this.player.isInsideVehicle();
    }

    @Override
    public boolean isHoldingBlock() {
        ItemType mainitem = this.getItemInHand(HandSide.MAIN_HAND).getType();
        ItemType offitem = this.getItemInHand(HandSide.OFF_HAND).getType();
        return mainitem.hasBlockType() && !mainitem.getBlockType().getMaterial().isAir() || offitem.hasBlockType() && !offitem.getBlockType().getMaterial().isAir();
    }

    @Override
    public String translate(String message) {
        return this.plugin.getLanguageManager().getString(message, LanguageManager.getPlayersLanguage(this.player));
    }

    @Override
    public boolean isSneaking() {
        return this.player.isSneaking();
    }

    @Override
    public String getCraftBookId() {
        return CraftBookPlugin.inst().getUUIDMappings().getCBID(this.getUniqueId());
    }
}

