/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.util.persistent;

import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import com.sk89q.craftbook.util.persistent.PersistentStorage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;

public class SQLitePersistentStorage
extends PersistentStorage {
    private Connection db;

    @Override
    public void open() {
        this.createConnection();
    }

    public void createConnection() {
        File file = new File(CraftBookPlugin.inst().getDataFolder(), "persistance.db");
        if (file.exists()) {
            file.renameTo(new File(CraftBookPlugin.inst().getDataFolder(), "persistence.db"));
            file.delete();
        }
        try {
            Class.forName("org.sqlite.JDBC");
            this.db = DriverManager.getConnection("jdbc:sqlite:plugins/CraftBook/persistence.db");
            DatabaseMetaData dbm = this.db.getMetaData();
            ResultSet tables = dbm.getTables(null, null, "PersistentData", null);
            if (!tables.next()) {
                String createTable = "CREATE TABLE PersistentData (KEY VARCHAR(255) PRIMARY KEY, VALUE TEXT)";
                try {
                    Statement state = this.db.createStatement();
                    state.executeUpdate(createTable);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void close() {
        try {
            if (!this.db.isClosed()) {
                this.db.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getType() {
        return "SQLite";
    }

    private static void close(ResultSet results) {
        if (results != null) {
            try {
                results.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    private static void close(PreparedStatement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object get(String location) {
        Object object;
        ResultSet results;
        PreparedStatement statement;
        block8: {
            Object var4_4;
            block7: {
                statement = null;
                results = null;
                try {
                    statement = this.db.prepareStatement("SELECT * FROM PersistentData WHERE KEY = ?");
                    statement.setString(1, location);
                    results = statement.executeQuery();
                    if (!results.next()) {
                        var4_4 = null;
                        SQLitePersistentStorage.close(results);
                        break block7;
                    }
                    object = SQLitePersistentStorage.fromString(results.getString(2));
                    SQLitePersistentStorage.close(results);
                    break block8;
                }
                catch (IOException | ClassNotFoundException | SQLException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            SQLitePersistentStorage.close(statement);
            return var4_4;
        }
        SQLitePersistentStorage.close(statement);
        return object;
        finally {
            SQLitePersistentStorage.close(results);
            SQLitePersistentStorage.close(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(String location, Object data) {
        if (!(data instanceof Serializable) && !(data instanceof ConfigurationSerializable)) {
            CraftBookPlugin.logger().warning("Failed to put item in db! " + data.getClass().getSimpleName() + " is NOT serializable!");
            return;
        }
        PreparedStatement statement = null;
        try {
            statement = this.db.prepareStatement("INSERT OR REPLACE INTO PersistentData VALUES(?,?)");
            statement.setString(1, location);
            statement.setObject(2, SQLitePersistentStorage.toString(data));
            statement.executeUpdate();
        }
        catch (IOException | SQLException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                SQLitePersistentStorage.close(statement);
                throw throwable;
            }
            SQLitePersistentStorage.close(statement);
        }
        SQLitePersistentStorage.close(statement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean has(String location) {
        boolean bl;
        PreparedStatement statement = null;
        ResultSet results = null;
        try {
            statement = this.db.prepareStatement("SELECT * FROM PersistentData WHERE KEY = ?");
            statement.setString(1, location);
            results = statement.executeQuery();
            bl = results.next();
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                SQLitePersistentStorage.close(statement);
                SQLitePersistentStorage.close(results);
                throw throwable;
            }
            SQLitePersistentStorage.close(statement);
            SQLitePersistentStorage.close(results);
            return false;
        }
        SQLitePersistentStorage.close(statement);
        SQLitePersistentStorage.close(results);
        return bl;
    }

    @Override
    public boolean isValid() {
        try {
            return this.db != null && !this.db.isClosed();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getVersion() {
        ResultSet results;
        PreparedStatement insertStatement;
        PreparedStatement statement;
        block5: {
            int n;
            statement = null;
            insertStatement = null;
            results = null;
            try {
                statement = this.db.prepareStatement("SELECT * FROM PersistentData WHERE KEY = ?");
                statement.setString(1, "VERSION");
                results = statement.executeQuery();
                if (!results.next()) {
                    insertStatement = this.db.prepareStatement("INSERT INTO PersistentData VALUES(?,?)");
                    insertStatement.setString(1, "VERSION");
                    insertStatement.setInt(2, this.getCurrentVersion());
                    insertStatement.executeUpdate();
                    break block5;
                }
                n = results.getInt(2);
            }
            catch (SQLException e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    SQLitePersistentStorage.close(statement);
                    SQLitePersistentStorage.close(insertStatement);
                    SQLitePersistentStorage.close(results);
                    throw throwable;
                }
                SQLitePersistentStorage.close(statement);
                SQLitePersistentStorage.close(insertStatement);
                SQLitePersistentStorage.close(results);
            }
            SQLitePersistentStorage.close(statement);
            SQLitePersistentStorage.close(insertStatement);
            SQLitePersistentStorage.close(results);
            return n;
        }
        SQLitePersistentStorage.close(statement);
        SQLitePersistentStorage.close(insertStatement);
        SQLitePersistentStorage.close(results);
        return this.getCurrentVersion();
    }

    @Override
    public int getCurrentVersion() {
        return 1;
    }

    @Override
    public void convertVersion(int version) {
    }

    @Override
    public void importData(Map<String, Object> data, boolean replace) {
        try {
            if (replace) {
                this.db.prepareStatement("DELETE FROM PersistentData").execute();
            }
            for (Map.Entry<String, Object> dat : data.entrySet()) {
                this.set(dat.getKey(), dat.getValue());
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> exportData() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        PreparedStatement statement = null;
        ResultSet results = null;
        try {
            statement = this.db.prepareStatement("SELECT * FROM PersistentData");
            results = statement.executeQuery();
            while (results.next()) {
                data.put(results.getString(1), results.getObject(2));
            }
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                SQLitePersistentStorage.close(statement);
                SQLitePersistentStorage.close(results);
                throw throwable;
            }
            SQLitePersistentStorage.close(statement);
            SQLitePersistentStorage.close(results);
        }
        SQLitePersistentStorage.close(statement);
        SQLitePersistentStorage.close(results);
        return data;
    }

    private static Object fromString(String s) throws IOException, ClassNotFoundException {
        byte[] data = s.getBytes(StandardCharsets.UTF_8);
        BukkitObjectInputStream ois = new BukkitObjectInputStream((InputStream)new ByteArrayInputStream(data));
        Object o = ois.readObject();
        ois.close();
        return o;
    }

    private static String toString(Object o) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BukkitObjectOutputStream oos = new BukkitObjectOutputStream((OutputStream)baos);
        oos.writeObject(o);
        oos.close();
        return new String(baos.toByteArray(), StandardCharsets.UTF_8);
    }
}

