/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.util.persistent;

import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import com.sk89q.craftbook.util.persistent.DummyPersistentStorage;
import com.sk89q.craftbook.util.persistent.SQLitePersistentStorage;
import com.sk89q.craftbook.util.persistent.YAMLPersistentStorage;
import java.util.Map;

public abstract class PersistentStorage {
    public abstract void open();

    public abstract void close();

    public abstract String getType();

    public abstract Object get(String var1);

    public abstract void set(String var1, Object var2);

    public abstract boolean has(String var1);

    public abstract boolean isValid();

    public abstract int getVersion();

    public abstract int getCurrentVersion();

    public abstract void convertVersion(int var1);

    public void convertType(String type) {
        Map<String, Object> data = this.exportData();
        PersistentStorage stor = PersistentStorage.createFromType(type);
        stor.importData(data, true);
        CraftBookPlugin.inst().setPersistentStorage(stor);
    }

    public abstract void importData(Map<String, Object> var1, boolean var2);

    public abstract Map<String, Object> exportData();

    public static PersistentStorage createFromType(String type) {
        if (type.equalsIgnoreCase("YAML")) {
            return new YAMLPersistentStorage();
        }
        if (type.equalsIgnoreCase("DUMMY")) {
            return new DummyPersistentStorage();
        }
        if (type.equalsIgnoreCase("SQLite")) {
            return new SQLitePersistentStorage();
        }
        return null;
    }
}

