/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.util.jinglenote;

import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import com.sk89q.craftbook.bukkit.util.CraftBookBukkitUtil;
import com.sk89q.craftbook.util.SearchArea;
import com.sk89q.craftbook.util.jinglenote.JingleSequencer;

public abstract class JingleNotePlayer
implements Runnable {
    protected final String player;
    private JingleSequencer sequencer;
    protected SearchArea area;

    public JingleNotePlayer(String player, JingleSequencer seq, SearchArea area) {
        this.player = player;
        this.sequencer = seq;
        this.area = area;
    }

    @Override
    public void run() {
        if (this.sequencer == null) {
            return;
        }
        try {
            try {
                this.sequencer.play(this);
            }
            catch (Throwable t) {
                CraftBookBukkitUtil.printStacktrace(t);
            }
            while (this.isPlaying()) {
                Thread.sleep(10L);
            }
        }
        catch (InterruptedException e) {
            CraftBookBukkitUtil.printStacktrace(e);
        }
        finally {
            CraftBookPlugin.logDebugMessage("Finished playing for: " + this.player, "midi.stop");
            this.stop();
        }
    }

    public boolean isPlaying() {
        return this.sequencer != null && (this.sequencer.isPlaying() || !this.sequencer.hasPlayedBefore());
    }

    public String getPlayer() {
        return this.player;
    }

    public void stop() {
        if (this.sequencer != null) {
            this.sequencer.stop(this);
            this.sequencer = null;
        }
    }

    public abstract void play(JingleSequencer.Note var1);
}

