/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.util.jinglenote;

import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import com.sk89q.craftbook.util.SearchArea;
import com.sk89q.craftbook.util.jinglenote.JingleNotePlayer;
import com.sk89q.craftbook.util.jinglenote.JingleSequencer;
import com.sk89q.craftbook.util.jinglenote.bukkit.BukkitJingleNotePlayer;
import java.util.HashMap;
import java.util.Map;

public class JingleNoteManager {
    private final Map<String, JingleNotePlayer> instances = new HashMap<String, JingleNotePlayer>();

    public boolean isPlaying(String player) {
        return this.instances.containsKey(player) && this.instances.get(player).isPlaying();
    }

    public boolean isPlaying() {
        return !this.instances.isEmpty();
    }

    public void play(String player, JingleSequencer sequencer, SearchArea area) {
        if (this.instances.containsKey(player)) {
            this.stop(player);
        }
        CraftBookPlugin.logDebugMessage("Playing sequencer for player: " + player, "midi");
        BukkitJingleNotePlayer notePlayer = new BukkitJingleNotePlayer(player, sequencer, area);
        Thread thread = new Thread(notePlayer);
        thread.setDaemon(true);
        thread.setPriority(10);
        thread.setName("JingleNotePlayer for " + player);
        thread.start();
        this.instances.put(player, notePlayer);
    }

    public boolean stop(String player) {
        if (this.instances.containsKey(player)) {
            this.instances.remove(player).stop();
            return true;
        }
        return false;
    }

    public void stopAll() {
        for (JingleNotePlayer notePlayer : this.instances.values()) {
            notePlayer.stop();
        }
        this.instances.clear();
    }
}

