/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.util;

import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.UUID;

public final class UUIDMappings {
    private Connection db;

    public void enable() {
        this.createConnection();
    }

    private void createConnection() {
        try {
            Class.forName("org.sqlite.JDBC");
            this.db = DriverManager.getConnection("jdbc:sqlite:plugins/CraftBook/uuid-mappings.db");
            DatabaseMetaData dbm = this.db.getMetaData();
            ResultSet tables = dbm.getTables(null, null, "mappings", null);
            if (!tables.next()) {
                String createTable = "CREATE TABLE mappings (UUID CHAR(36) PRIMARY KEY, CBID CHAR(6) UNIQUE)";
                try {
                    Statement state = this.db.createStatement();
                    state.executeUpdate(createTable);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void close(ResultSet results) {
        if (results != null) {
            try {
                results.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    private static void close(PreparedStatement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UUID getUUID(String cbID) {
        ResultSet results;
        PreparedStatement statement;
        UUID uuid;
        block5: {
            uuid = null;
            statement = null;
            results = null;
            statement = this.db.prepareStatement("SELECT UUID FROM mappings WHERE CBID = ?");
            statement.setString(1, cbID);
            results = statement.executeQuery();
            if (results.next()) break block5;
            UUID uUID = null;
            UUIDMappings.close(statement);
            UUIDMappings.close(results);
            return uUID;
        }
        try {
            uuid = UUID.fromString(results.getString(1));
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                UUIDMappings.close(statement);
                UUIDMappings.close(results);
                throw throwable;
            }
            UUIDMappings.close(statement);
            UUIDMappings.close(results);
        }
        UUIDMappings.close(statement);
        UUIDMappings.close(results);
        return uuid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCBID(UUID uuid) {
        ResultSet results;
        PreparedStatement insertStatement;
        PreparedStatement statement;
        String cbId;
        block7: {
            cbId = null;
            statement = null;
            insertStatement = null;
            results = null;
            statement = this.db.prepareStatement("SELECT CBID FROM mappings WHERE UUID = ?");
            statement.setString(1, uuid.toString());
            results = statement.executeQuery();
            if (results.next()) break block7;
            boolean foundOne = false;
            while (!foundOne) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < 6; ++i) {
                    sb.append(Integer.toHexString(CraftBookPlugin.inst().getRandom().nextInt(16)));
                }
                sb.setLength(6);
                cbId = sb.toString();
                statement = this.db.prepareStatement("SELECT UUID FROM mappings WHERE CBID = ?");
                statement.setString(1, cbId);
                UUIDMappings.close(results);
                results = statement.executeQuery();
                if (results.next()) continue;
                foundOne = true;
                insertStatement = this.db.prepareStatement("INSERT INTO mappings VALUES(?,?)");
                insertStatement.setString(1, uuid.toString());
                insertStatement.setString(2, cbId);
                insertStatement.executeUpdate();
            }
            String string = cbId;
            UUIDMappings.close(statement);
            UUIDMappings.close(insertStatement);
            UUIDMappings.close(results);
            return string;
        }
        try {
            cbId = results.getString(1);
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                UUIDMappings.close(statement);
                UUIDMappings.close(insertStatement);
                UUIDMappings.close(results);
                throw throwable;
            }
            UUIDMappings.close(statement);
            UUIDMappings.close(insertStatement);
            UUIDMappings.close(results);
        }
        UUIDMappings.close(statement);
        UUIDMappings.close(insertStatement);
        UUIDMappings.close(results);
        return cbId;
    }

    public void disable() {
        try {
            if (this.db != null && !this.db.isClosed()) {
                this.db.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

