/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.util;

import com.sk89q.craftbook.bukkit.util.CraftBookBukkitUtil;
import org.bukkit.Keyed;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Sign;
import org.bukkit.block.data.type.WallSign;
import org.bukkit.event.block.SignChangeEvent;

public final class SignUtil {
    public static boolean isSign(Block block) {
        return SignUtil.isStandingSign(block) || SignUtil.isWallSign(block);
    }

    public static boolean isStandingSign(Block block) {
        return Tag.STANDING_SIGNS.isTagged((Keyed)block.getType());
    }

    public static boolean isWallSign(Block block) {
        return Tag.WALL_SIGNS.isTagged((Keyed)block.getType());
    }

    public static BlockFace getFacing(Block sign) {
        return SignUtil.getBack(sign);
    }

    public static BlockFace getFront(Block sign) {
        BlockData blockData = sign.getBlockData();
        if (blockData instanceof Sign) {
            return ((Sign)blockData).getRotation();
        }
        if (blockData instanceof WallSign) {
            return ((WallSign)blockData).getFacing();
        }
        return BlockFace.SELF;
    }

    public static Block getFrontBlock(Block sign) {
        return sign.getRelative(SignUtil.getFront(sign));
    }

    public static BlockFace getBack(Block sign) {
        return SignUtil.getFront(sign).getOppositeFace();
    }

    public static Block getBackBlock(Block sign) {
        return sign.getRelative(SignUtil.getBack(sign));
    }

    public static Block getNextSign(Block sign, String criterea, int searchRadius) {
        Block otherBlock = sign;
        BlockFace way = sign.getFace(SignUtil.getBackBlock(sign));
        boolean found = false;
        for (int i = 0; i < searchRadius; ++i) {
            if (SignUtil.isSign(otherBlock.getRelative(way))) {
                if (!CraftBookBukkitUtil.toChangedSign(otherBlock = otherBlock.getRelative(way)).getLine(1).equalsIgnoreCase(criterea)) continue;
                found = true;
                break;
            }
            otherBlock = otherBlock.getRelative(way);
        }
        if (!found) {
            return null;
        }
        return otherBlock;
    }

    public static BlockFace getRight(Block sign) {
        return SignUtil.getCounterClockWise(SignUtil.getFront(sign));
    }

    public static Block getLeftBlock(Block sign) {
        return sign.getRelative(SignUtil.getLeft(sign));
    }

    public static BlockFace getLeft(Block sign) {
        return SignUtil.getClockWise(SignUtil.getFront(sign));
    }

    public static Block getRightBlock(Block sign) {
        return sign.getRelative(SignUtil.getRight(sign));
    }

    public static boolean isCardinal(Block sign) {
        BlockFace facing = SignUtil.getFront(sign);
        switch (facing) {
            case NORTH: 
            case SOUTH: 
            case EAST: 
            case WEST: {
                return true;
            }
        }
        return false;
    }

    public static BlockFace getClockWise(BlockFace face) {
        switch (face) {
            case NORTH: {
                return BlockFace.EAST;
            }
            case EAST: {
                return BlockFace.SOUTH;
            }
            case SOUTH: {
                return BlockFace.WEST;
            }
            case WEST: {
                return BlockFace.NORTH;
            }
        }
        return BlockFace.SELF;
    }

    public static BlockFace getCounterClockWise(BlockFace face) {
        switch (face) {
            case NORTH: {
                return BlockFace.WEST;
            }
            case EAST: {
                return BlockFace.NORTH;
            }
            case SOUTH: {
                return BlockFace.EAST;
            }
            case WEST: {
                return BlockFace.SOUTH;
            }
        }
        return BlockFace.SELF;
    }

    public static void cancelSign(SignChangeEvent event) {
        event.setCancelled(true);
        event.getBlock().breakNaturally();
    }

    public static boolean doesSignHaveText(Block sign, String text, int line) {
        return SignUtil.isSign(sign) && CraftBookBukkitUtil.toChangedSign(sign).getLine(line).equals(text);
    }
}

