/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.util;

import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;

public final class RedstoneUtil {
    public static Power isPowered(Block mech, BlockFace face) {
        Block pow = mech.getRelative(face);
        if (CraftBookPlugin.isDebugFlagEnabled("redstone")) {
            RedstoneUtil.debug(pow);
        }
        if (RedstoneUtil.isPotentialPowerSource(mech, pow)) {
            if (pow.isBlockPowered() || pow.isBlockIndirectlyPowered()) {
                return Power.ON;
            }
            return Power.OFF;
        }
        return Power.NA;
    }

    public static boolean isPotentialPowerSource(Material typeId) {
        return typeId == Material.REDSTONE_WIRE || typeId == Material.REPEATER || typeId == Material.LEVER || typeId == Material.REDSTONE_TORCH || typeId == Material.REDSTONE_WALL_TORCH || Tag.WOODEN_PRESSURE_PLATES.isTagged((Keyed)typeId) || typeId == Material.STONE_PRESSURE_PLATE || typeId == Material.HEAVY_WEIGHTED_PRESSURE_PLATE || typeId == Material.LIGHT_WEIGHTED_PRESSURE_PLATE || typeId == Material.COMPARATOR || typeId == Material.REDSTONE_BLOCK;
    }

    public static boolean isPotentialPowerSource(Block pow) {
        return RedstoneUtil.isPotentialPowerSource(pow.getType());
    }

    public static boolean isPotentialPowerSource(Block mech, Block pow) {
        return RedstoneUtil.isPotentialPowerSource(pow);
    }

    public static void debug(Block block) {
        CraftBookPlugin.inst().getLogger().info("block " + block + " power debug:");
        CraftBookPlugin.inst().getLogger().info("\tblock.isBlockPowered() : " + block.isBlockPowered());
        CraftBookPlugin.inst().getLogger().info("\tblock.isBlockIndirectlyPowered() : " + block.isBlockIndirectlyPowered());
        for (BlockFace bf : BlockFace.values()) {
            CraftBookPlugin.inst().getLogger().info("\tblock.isBlockFacePowered(" + bf + ") : " + block.isBlockFacePowered(bf));
            CraftBookPlugin.inst().getLogger().info("\tblock.getFace(" + bf + ").isBlockPowered() : " + block.getRelative(bf).isBlockPowered());
            CraftBookPlugin.inst().getLogger().info("\tblock.isBlockFaceIndirectlyPowered(" + bf + ") : " + block.isBlockFaceIndirectlyPowered(bf));
            CraftBookPlugin.inst().getLogger().info("\tblock.getFace(" + bf + ").isBlockIndirectlyPowered(" + bf + ") : " + block.getRelative(bf).isBlockIndirectlyPowered());
        }
        CraftBookPlugin.inst().getLogger().info("");
    }

    public static enum Power {
        NA,
        ON,
        OFF;

    }
}

