/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.util;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import com.sk89q.craftbook.mechanics.variables.VariableCommands;
import com.sk89q.craftbook.mechanics.variables.VariableManager;
import com.sk89q.craftbook.util.RegexUtil;
import com.sk89q.craftbook.util.Tuple2;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public final class ParsingUtil {
    private static final LoadingCache<String, List<String>> variableFinderCache = CacheBuilder.newBuilder().maximumSize(1024L).expireAfterAccess(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, List<String>>(){

        public List<String> load(String line) throws Exception {
            ArrayList<String> variables = new ArrayList<String>();
            for (String bit : RegexUtil.PERCENT_PATTERN.split(line)) {
                if (line.indexOf(bit) > 0 && line.charAt(line.indexOf(bit) - 1) == '\\' || bit.trim().isEmpty() || bit.trim().equals("|")) continue;
                variables.add(bit.trim());
            }
            return variables;
        }
    });

    public static String parseLine(String line, Player player) {
        if (player != null) {
            line = ParsingUtil.parsePlayerTags(line, player);
        }
        line = ParsingUtil.parseVariables(line, (CommandSender)player);
        return line;
    }

    public static String parsePlayerTags(String line, Player player) {
        line = StringUtils.replace((String)line, (String)"@p.l", (String)(player.getLocation().getX() + ":" + player.getLocation().getY() + ":" + player.getLocation().getZ()));
        line = StringUtils.replace((String)line, (String)"@p.x", (String)String.valueOf(player.getLocation().getX()));
        line = StringUtils.replace((String)line, (String)"@p.y", (String)String.valueOf(player.getLocation().getY()));
        line = StringUtils.replace((String)line, (String)"@p.z", (String)String.valueOf(player.getLocation().getZ()));
        line = StringUtils.replace((String)line, (String)"@p.bx", (String)String.valueOf(player.getLocation().getBlockX()));
        line = StringUtils.replace((String)line, (String)"@p.by", (String)String.valueOf(player.getLocation().getBlockY()));
        line = StringUtils.replace((String)line, (String)"@p.bz", (String)String.valueOf(player.getLocation().getBlockZ()));
        line = StringUtils.replace((String)line, (String)"@p.w", (String)String.valueOf(player.getLocation().getWorld().getName()));
        line = StringUtils.replace((String)line, (String)"@p.u", (String)player.getUniqueId().toString());
        line = StringUtils.replace((String)line, (String)"@p.i", (String)CraftBookPlugin.inst().getUUIDMappings().getCBID(player.getUniqueId()));
        line = StringUtils.replace((String)line, (String)"@p", (String)player.getName());
        return line;
    }

    public static List<String> getPossibleVariables(String line) {
        if (!line.contains("%")) {
            return new ArrayList<String>();
        }
        return (List)variableFinderCache.getUnchecked((Object)line);
    }

    public static String parseVariables(String line, CommandSender player) {
        if (CraftBookPlugin.inst() == null || VariableManager.instance == null || VariableManager.instance.getVariableStore().isEmpty()) {
            return line;
        }
        for (String var : ParsingUtil.getPossibleVariables(line)) {
            String value;
            String key;
            CraftBookPlugin.logDebugMessage("Possible variable: " + var + " detected!", "variables.line-parsing");
            if (var.contains("|")) {
                String[] bits = RegexUtil.PIPE_PATTERN.split(var);
                if (bits.length < 2) {
                    key = "global";
                    value = var;
                } else {
                    key = bits[0];
                    value = bits[1];
                }
                CraftBookPlugin.logDebugMessage("Variable " + value + " at " + key + " detected!", "variables.line-parsing");
            } else {
                key = "global";
                value = var;
                CraftBookPlugin.logDebugMessage("Global Variable " + value + " detected!", "variables.line-parsing");
            }
            if (player != null && !VariableCommands.hasVariablePermission(player, key, value, "use")) continue;
            CraftBookPlugin.logDebugMessage(var + " permissions granted!", "variables.line-parsing");
            for (Map.Entry<Tuple2<String, String>, String> bit : VariableManager.instance.getVariableStore().entrySet()) {
                if (!((String)bit.getKey().b).equals(key) || !((String)bit.getKey().a).equals(value)) continue;
                line = StringUtils.replace((String)line, (String)("%" + var + "%"), (String)bit.getValue());
            }
        }
        return StringUtils.replace((String)line, (String)"\\%", (String)"%");
    }
}

