/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.util;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.CraftBookPlayer;
import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import com.sk89q.craftbook.bukkit.util.CraftBookBukkitUtil;
import com.sk89q.craftbook.mechanics.ic.AbstractIC;
import com.sk89q.craftbook.mechanics.ic.ICMechanic;
import com.sk89q.craftbook.mechanics.ic.ICVerificationException;
import com.sk89q.craftbook.mechanics.pipe.PipeRequestEvent;
import com.sk89q.craftbook.util.InventoryUtil;
import com.sk89q.craftbook.util.LocationUtil;
import com.sk89q.craftbook.util.RegexUtil;
import com.sk89q.craftbook.util.SignUtil;
import com.sk89q.craftbook.util.VerifyUtil;
import com.sk89q.worldedit.IncompleteRegionException;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.regions.EllipsoidRegion;
import com.sk89q.worldedit.regions.RegionSelector;
import com.sk89q.worldedit.regions.selector.CuboidRegionSelector;
import com.sk89q.worldedit.regions.selector.SphereRegionSelector;
import com.sk89q.worldedit.session.SessionOwner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Switch;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public final class ICUtil {
    public static boolean setState(Block block, boolean state, Block source) {
        if (block.getType() != Material.LEVER) {
            return false;
        }
        Switch lever = (Switch)block.getBlockData();
        if (!block.getRelative(lever.getFacing().getOppositeFace()).equals(source)) {
            return false;
        }
        boolean wasOn = lever.isPowered();
        if (wasOn != state) {
            lever.setPowered(state);
            block.setBlockData((BlockData)lever);
            source.setBlockData(source.getBlockData(), true);
            BlockRedstoneEvent leverEvent = new BlockRedstoneEvent(block, wasOn ? 15 : 0, state ? 15 : 0);
            BlockRedstoneEvent sourceEvent = new BlockRedstoneEvent(source, wasOn ? 15 : 0, state ? 15 : 0);
            CraftBookPlugin.inst().getServer().getPluginManager().callEvent((Event)leverEvent);
            CraftBookPlugin.inst().getServer().getPluginManager().callEvent((Event)sourceEvent);
            return true;
        }
        return false;
    }

    public static void parseSignFlags(CraftBookPlayer player, ChangedSign sign) {
        for (int i = 2; i < 4; ++i) {
            RegionSelector selector;
            if (sign.getLine(i).contains("[off]")) {
                if (CraftBookPlugin.plugins.getWorldEdit() == null) {
                    sign.setLine(i, StringUtils.replace((String)sign.getLine(i), (String)"[off]", (String)""));
                    player.printError("worldedit.ic.notfound");
                } else {
                    selector = WorldEdit.getInstance().getSessionManager().get((SessionOwner)player).getRegionSelector(player.getWorld());
                    try {
                        String z;
                        String y;
                        String x;
                        Vector3 centre;
                        if (selector instanceof CuboidRegionSelector) {
                            centre = selector.getRegion().getMaximumPoint().add(selector.getRegion().getMinimumPoint());
                            BlockVector3 offset = (centre = centre.divide(2)).subtract(BukkitAdapter.adapt((Location)sign.getBlock().getLocation()).toVector().toBlockPoint());
                            x = Double.toString(offset.getX());
                            if (x.endsWith(".0")) {
                                x = StringUtils.replace((String)x, (String)".0", (String)"");
                            }
                            if ((y = Double.toString(offset.getY())).endsWith(".0")) {
                                y = StringUtils.replace((String)y, (String)".0", (String)"");
                            }
                            if ((z = Double.toString(offset.getZ())).endsWith(".0")) {
                                z = StringUtils.replace((String)z, (String)".0", (String)"");
                            }
                            sign.setLine(i, StringUtils.replace((String)sign.getLine(i), (String)"[off]", (String)("&" + x + ":" + y + ":" + z)));
                        } else if (selector instanceof SphereRegionSelector) {
                            centre = selector.getRegion().getCenter();
                            Vector3 offset = centre.subtract(BukkitAdapter.adapt((Location)sign.getBlock().getLocation()).toVector());
                            x = Double.toString(offset.getX());
                            if (x.endsWith(".0")) {
                                x = StringUtils.replace((String)x, (String)".0", (String)"");
                            }
                            if ((y = Double.toString(offset.getY())).endsWith(".0")) {
                                y = StringUtils.replace((String)y, (String)".0", (String)"");
                            }
                            if ((z = Double.toString(offset.getZ())).endsWith(".0")) {
                                z = StringUtils.replace((String)z, (String)".0", (String)"");
                            }
                            sign.setLine(i, StringUtils.replace((String)sign.getLine(i), (String)"[off]", (String)("&" + x + ":" + y + ":" + z)));
                        } else {
                            sign.setLine(i, StringUtils.replace((String)sign.getLine(i), (String)"[off]", (String)""));
                            player.printError("worldedit.ic.unsupported");
                        }
                    }
                    catch (IncompleteRegionException e) {
                        player.printError("worldedit.ic.noselection");
                    }
                }
            }
            if (!sign.getLine(i).contains("[rad]")) continue;
            if (CraftBookPlugin.plugins.getWorldEdit() == null) {
                sign.setLine(i, StringUtils.replace((String)sign.getLine(i), (String)"[rad]", (String)""));
                player.printError("worldedit.ic.notfound");
                continue;
            }
            selector = WorldEdit.getInstance().getSessionManager().get((SessionOwner)player).getRegionSelector(player.getWorld());
            try {
                String x;
                if (selector instanceof CuboidRegionSelector) {
                    String z;
                    String y;
                    x = Double.toString(Math.abs(selector.getRegion().getMaximumPoint().getX() - selector.getRegion().getMinimumPoint().getX()) / 2);
                    if (x.endsWith(".0")) {
                        x = StringUtils.replace((String)x, (String)".0", (String)"");
                    }
                    if ((y = Double.toString(Math.abs(selector.getRegion().getMaximumPoint().getY() - selector.getRegion().getMinimumPoint().getY()) / 2)).endsWith(".0")) {
                        y = StringUtils.replace((String)y, (String)".0", (String)"");
                    }
                    if ((z = Double.toString(Math.abs(selector.getRegion().getMaximumPoint().getZ() - selector.getRegion().getMinimumPoint().getZ()) / 2)).endsWith(".0")) {
                        z = StringUtils.replace((String)z, (String)".0", (String)"");
                    }
                    sign.setLine(i, StringUtils.replace((String)sign.getLine(i), (String)"[rad]", (String)(x + "," + y + "," + z)));
                    continue;
                }
                if (selector instanceof SphereRegionSelector) {
                    double amounts = ((EllipsoidRegion)selector.getRegion()).getRadius().getX();
                    x = Double.toString(amounts);
                    if (x.endsWith(".0")) {
                        x = StringUtils.replace((String)x, (String)".0", (String)"");
                    }
                    sign.setLine(i, StringUtils.replace((String)sign.getLine(i), (String)"[rad]", (String)x));
                    continue;
                }
                sign.setLine(i, StringUtils.replace((String)sign.getLine(i), (String)"[rad]", (String)""));
                player.printError("worldedit.ic.unsupported");
                continue;
            }
            catch (IncompleteRegionException e) {
                player.printError("worldedit.ic.noselection");
            }
        }
        sign.update(false);
    }

    public static Vector3 parseUnsafeBlockLocation(String line) throws NumberFormatException, ArrayIndexOutOfBoundsException {
        String[] split;
        line = StringUtils.replace((String)StringUtils.replace((String)StringUtils.replace((String)line, (String)"!", (String)""), (String)"^", (String)""), (String)"&", (String)"");
        double offsetX = 0.0;
        double offsetY = 0.0;
        double offsetZ = 0.0;
        if (line.contains("=")) {
            line = RegexUtil.EQUALS_PATTERN.split(line)[1];
        }
        if ((split = RegexUtil.COLON_PATTERN.split(line)).length > 1) {
            offsetX = Double.parseDouble(split[0]);
            offsetY = Double.parseDouble(split[1]);
            offsetZ = Double.parseDouble(split[2]);
        } else {
            offsetY = Double.parseDouble(line);
        }
        return Vector3.at((double)offsetX, (double)offsetY, (double)offsetZ);
    }

    public static Block parseBlockLocation(ChangedSign sign, String line, LocationCheckType relative) {
        Block target = SignUtil.getBackBlock(CraftBookBukkitUtil.toSign(sign).getBlock());
        if (line.contains("!")) {
            relative = LocationCheckType.getTypeFromChar('!');
        } else if (line.contains("^")) {
            relative = LocationCheckType.getTypeFromChar('^');
        } else if (line.contains("&")) {
            relative = LocationCheckType.getTypeFromChar('&');
        }
        BlockVector3 offsets = BlockVector3.ZERO;
        try {
            offsets = ICUtil.parseUnsafeBlockLocation(line).toBlockPoint();
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException runtimeException) {
            // empty catch block
        }
        if (offsets.getBlockX() == 0 && offsets.getBlockY() == 0 && offsets.getBlockZ() == 0) {
            return target;
        }
        if (relative == LocationCheckType.RELATIVE) {
            target = LocationUtil.getRelativeOffset(sign, offsets.getBlockX(), offsets.getBlockY(), offsets.getBlockZ());
        } else if (relative == LocationCheckType.OFFSET) {
            target = LocationUtil.getOffset(target, offsets.getBlockX(), offsets.getBlockY(), offsets.getBlockZ());
        } else if (relative == LocationCheckType.ABSOLUTE) {
            target = new Location(target.getWorld(), (double)offsets.getBlockX(), (double)offsets.getBlockY(), (double)offsets.getBlockZ()).getBlock();
        }
        return target;
    }

    public static Block parseBlockLocation(ChangedSign sign, int lPos, LocationCheckType relative) {
        return ICUtil.parseBlockLocation(sign, sign.getLine(lPos), relative);
    }

    public static Block parseBlockLocation(ChangedSign sign, int lPos) {
        return ICUtil.parseBlockLocation(sign, lPos, ICMechanic.instance.defaultCoordinates);
    }

    public static Block parseBlockLocation(ChangedSign sign) {
        return ICUtil.parseBlockLocation(sign, 2, ICMechanic.instance.defaultCoordinates);
    }

    public static void verifySignSyntax(ChangedSign sign) throws ICVerificationException {
        ICUtil.verifySignLocationSyntax(sign, 2);
    }

    public static void verifySignLocationSyntax(ChangedSign sign, int i) throws ICVerificationException {
        try {
            String[] strings;
            String line = sign.getLine(i);
            line = StringUtils.replace((String)StringUtils.replace((String)StringUtils.replace((String)line, (String)"!", (String)""), (String)"^", (String)""), (String)"&", (String)"");
            if (line.contains("=")) {
                String[] split = RegexUtil.EQUALS_PATTERN.split(line, 2);
                if (RegexUtil.COMMA_PATTERN.split(split[0]).length > 1) {
                    String[] rads = RegexUtil.COMMA_PATTERN.split(split[0]);
                    Double.parseDouble(rads[0]);
                    Double.parseDouble(rads[1]);
                    Double.parseDouble(rads[2]);
                } else {
                    Double.parseDouble(split[0]);
                }
                strings = RegexUtil.COLON_PATTERN.split(split[1], 3);
            } else {
                strings = RegexUtil.COLON_PATTERN.split(line);
            }
            if (strings.length > 1) {
                Double.parseDouble(strings[1]);
                Double.parseDouble(strings[2]);
            }
            Double.parseDouble(strings[0]);
        }
        catch (Exception e) {
            throw new ICVerificationException("Wrong syntax! Needs to be: radius=x:y:z or radius=y or y");
        }
    }

    public static Vector3 parseRadius(ChangedSign sign) {
        return ICUtil.parseRadius(sign, 2);
    }

    public static Vector3 parseRadius(ChangedSign sign, int lPos) {
        return ICUtil.parseRadius(sign.getLine(lPos));
    }

    public static Vector3 parseRadius(String line) {
        Vector3 radius = Vector3.at((double)10.0, (double)10.0, (double)10.0);
        try {
            radius = ICUtil.parseUnsafeRadius(line);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return radius;
    }

    public static Vector3 parseUnsafeRadius(String line) throws NumberFormatException {
        String[] radians = RegexUtil.COMMA_PATTERN.split(RegexUtil.EQUALS_PATTERN.split(line, 2)[0]);
        if (radians.length > 1) {
            double x = VerifyUtil.verifyRadius(Double.parseDouble(radians[0]), ICMechanic.instance.maxRange);
            double y = VerifyUtil.verifyRadius(Double.parseDouble(radians[1]), ICMechanic.instance.maxRange);
            double z = VerifyUtil.verifyRadius(Double.parseDouble(radians[2]), ICMechanic.instance.maxRange);
            return Vector3.at((double)x, (double)y, (double)z);
        }
        double r = Double.parseDouble(radians[0]);
        r = VerifyUtil.verifyRadius(r, ICMechanic.instance.maxRange);
        return Vector3.at((double)r, (double)r, (double)r);
    }

    public static void collectItem(AbstractIC ic, BlockVector3 offset, ItemStack ... items) {
        Sign sign = CraftBookBukkitUtil.toSign(ic.getSign());
        Block backB = ic.getBackBlock();
        BlockFace back = SignUtil.getBack(sign.getBlock());
        Block pipe = backB.getRelative(back);
        PipeRequestEvent event = new PipeRequestEvent(pipe, new ArrayList<ItemStack>(Arrays.asList(items)), backB);
        Bukkit.getPluginManager().callEvent((Event)event);
        List<ItemStack> results = event.getItems();
        Block invHolder = backB.getRelative(offset.getBlockX(), offset.getBlockY(), offset.getBlockZ());
        if (InventoryUtil.doesBlockHaveInventory(invHolder)) {
            InventoryHolder c = (InventoryHolder)invHolder.getState();
            results = InventoryUtil.addItemsToInventory(c, results.toArray(new ItemStack[0]));
        }
        for (ItemStack item : results) {
            backB.getWorld().dropItemNaturally(sign.getLocation().add(0.5, 0.0, 0.5), item);
        }
    }

    public static enum LocationCheckType {
        RELATIVE('^'),
        OFFSET('&'),
        ABSOLUTE('!');

        char c;

        private LocationCheckType(char c) {
            this.c = c;
        }

        public static LocationCheckType getTypeFromChar(char c) {
            for (LocationCheckType t : LocationCheckType.values()) {
                if (t.c != c) continue;
                return t;
            }
            return RELATIVE;
        }

        public static LocationCheckType getTypeFromName(String name) {
            if (name.length() == 1) {
                return LocationCheckType.getTypeFromChar(name.charAt(0));
            }
            for (LocationCheckType t : LocationCheckType.values()) {
                if (!t.name().equalsIgnoreCase(name)) continue;
                return t;
            }
            return RELATIVE;
        }
    }
}

