/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.util;

import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerInteractEvent;

public final class EventUtil {
    private static final Map<Event, Long> ignoredEvents = new WeakHashMap<Event, Long>();
    private static Set<Class<?>> ignoredEventTypes = new HashSet();
    private static int lastGarbageCollect = 0;

    public static boolean shouldIgnoreEvent(Event ev) {
        if (!EventUtil.shouldIgnoreEventType(ev.getClass())) {
            return false;
        }
        if (CraftBookPlugin.inst() == null || !CraftBookPlugin.inst().getConfiguration().advancedBlockChecks) {
            return false;
        }
        Long time = ignoredEvents.get(ev);
        if (time == null) {
            return false;
        }
        if (System.currentTimeMillis() - time > 3000L) {
            ignoredEvents.remove(ev);
        }
        return true;
    }

    public static void ignoreEvent(Event ev) {
        if (!CraftBookPlugin.inst().getConfiguration().advancedBlockChecks) {
            return;
        }
        if (!EventUtil.shouldIgnoreEventType(ev.getClass())) {
            ignoredEventTypes.add(ev.getClass());
        }
        if (++lastGarbageCollect > 100) {
            EventUtil.garbageCollectEvents();
        }
        ignoredEvents.put(ev, System.currentTimeMillis());
    }

    private static boolean shouldIgnoreEventType(Class<?> type) {
        return ignoredEventTypes.contains(type);
    }

    public static void garbageCollectEvents() {
        lastGarbageCollect = 0;
        ignoredEvents.entrySet().removeIf(bit -> System.currentTimeMillis() - (Long)bit.getValue() > 5000L);
    }

    public static boolean passesFilter(Event event) {
        if (CraftBookPlugin.inst() != null && CraftBookPlugin.inst().getConfiguration().advancedBlockChecks && event instanceof Cancellable && ((Cancellable)event).isCancelled() && (!(event instanceof PlayerInteractEvent) || ((PlayerInteractEvent)event).getClickedBlock() != null)) {
            return false;
        }
        return !EventUtil.shouldIgnoreEvent(event);
    }
}

