/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.util;

import com.sk89q.craftbook.util.LocationUtil;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.Vector3;
import java.util.Comparator;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;

public class DistanceComparator<T extends BlockState>
implements Comparator<T> {
    private final Vector3 origin;

    public DistanceComparator(Vector3 origin) {
        this.origin = origin;
    }

    @Override
    public int compare(T o1, T o2) {
        double dist2;
        Block b1 = o1.getBlock();
        Block b2 = o2.getBlock();
        double dist1 = LocationUtil.getDistanceSquared(b1.getLocation(), BukkitAdapter.adapt((World)b1.getWorld(), (Vector3)this.origin));
        if (dist1 < (dist2 = LocationUtil.getDistanceSquared(b2.getLocation(), BukkitAdapter.adapt((World)b2.getWorld(), (Vector3)this.origin)))) {
            return -1;
        }
        if (dist1 > dist2) {
            return 1;
        }
        return 0;
    }
}

