/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.variables;

import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import com.sk89q.craftbook.bukkit.util.CraftBookBukkitUtil;
import com.sk89q.craftbook.mechanics.variables.VariableManager;
import com.sk89q.craftbook.util.RegexUtil;
import com.sk89q.craftbook.util.Tuple2;
import com.sk89q.craftbook.util.profile.Profile;
import com.sk89q.craftbook.util.profile.resolver.HttpRepositoryService;
import com.sk89q.craftbook.util.profile.resolver.ProfileService;
import com.sk89q.util.yaml.YAMLProcessor;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;

public class VariableConfiguration {
    public final YAMLProcessor config;
    protected final Logger logger;

    public VariableConfiguration(YAMLProcessor config, Logger logger) {
        this.config = config;
        this.logger = logger;
    }

    public void load() {
        try {
            this.config.load();
        }
        catch (IOException e) {
            CraftBookBukkitUtil.printStacktrace(e);
            return;
        }
        boolean shouldSave = false;
        if (this.config.getKeys("variables") == null) {
            return;
        }
        for (String key : this.config.getKeys("variables")) {
            String[] keys = RegexUtil.PIPE_PATTERN.split(key, 2);
            if (keys.length == 1) {
                keys = new String[]{"global", key};
            } else if (CraftBookPlugin.inst().getConfiguration().convertNamesToCBID) {
                if (CraftBookPlugin.inst().getUUIDMappings().getUUID(keys[0]) != null) continue;
                OfflinePlayer player = Bukkit.getOfflinePlayer((String)keys[0]);
                if (player.hasPlayedBefore()) {
                    try {
                        ProfileService resolver = HttpRepositoryService.forMinecraft();
                        Profile profile = resolver.findByName(player.getName());
                        UUID uuid = profile.getUniqueId();
                        keys[0] = CraftBookPlugin.inst().getUUIDMappings().getCBID(uuid);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    shouldSave = true;
                }
            }
            String value = String.valueOf(this.config.getProperty("variables." + key));
            if (!RegexUtil.VARIABLE_KEY_PATTERN.matcher(keys[1]).find() || !RegexUtil.VARIABLE_VALUE_PATTERN.matcher(value).find()) continue;
            VariableManager.instance.setVariable(keys[1], keys[0], value);
        }
        if (shouldSave) {
            this.save();
        }
    }

    public void save() {
        this.config.clear();
        for (Map.Entry<Tuple2<String, String>, String> var : VariableManager.instance.getVariableStore().entrySet()) {
            if (!RegexUtil.VARIABLE_KEY_PATTERN.matcher((CharSequence)var.getKey().a).find() || !RegexUtil.VARIABLE_VALUE_PATTERN.matcher(var.getValue()).find()) continue;
            this.config.setProperty("variables." + (String)var.getKey().b + '|' + (String)var.getKey().a, (Object)var.getValue());
        }
        this.config.save();
    }
}

