/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.minecart.blocks;

import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import com.sk89q.craftbook.mechanics.minecart.blocks.CartBlockMechanism;
import com.sk89q.craftbook.mechanics.minecart.blocks.CartMechanismBlocks;
import com.sk89q.craftbook.mechanics.minecart.blocks.StationCommands;
import com.sk89q.craftbook.mechanics.minecart.events.CartBlockEnterEvent;
import com.sk89q.craftbook.mechanics.minecart.events.CartBlockImpactEvent;
import com.sk89q.craftbook.mechanics.minecart.events.CartBlockRedstoneEvent;
import com.sk89q.craftbook.util.BlockSyntax;
import com.sk89q.craftbook.util.CartUtil;
import com.sk89q.craftbook.util.ItemSyntax;
import com.sk89q.craftbook.util.ItemUtil;
import com.sk89q.craftbook.util.SignUtil;
import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.worldedit.world.block.BlockTypes;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class CartStation
extends CartBlockMechanism {
    @Override
    public boolean enable() {
        CraftBookPlugin.inst().registerCommands(StationCommands.class);
        return true;
    }

    @EventHandler
    public void onVehicleImpact(CartBlockImpactEvent event) {
        this.stationInteraction(event.getMinecart(), event.getBlocks());
    }

    @EventHandler
    public void onBlockPower(CartBlockRedstoneEvent event) {
        this.stationInteraction(event.getMinecart(), event.getBlocks());
    }

    public void stationInteraction(Minecart cart, CartMechanismBlocks blocks) {
        if (!blocks.matches(this.getMaterial())) {
            return;
        }
        if (!blocks.matches("station")) {
            return;
        }
        if (cart == null) {
            return;
        }
        switch (CartStation.isActive(blocks)) {
            case ON: {
                CartStation.launch(cart, blocks.sign);
                break;
            }
            case OFF: 
            case NA: {
                CartUtil.stop(cart);
                Location l = blocks.rail.getLocation().add(0.5, 0.5, 0.5);
                if (cart.getLocation().equals((Object)l)) break;
                cart.teleport(l);
            }
        }
    }

    private static void launch(Minecart cart, Block director) {
        cart.setVelocity(CartStation.propel(SignUtil.getFacing(director)));
    }

    public static Vector propel(BlockFace face) {
        return new Vector((double)face.getModX() * 0.2, (double)face.getModY() * 0.2, (double)face.getModZ() * 0.2);
    }

    @EventHandler
    public void onVehicleEnter(CartBlockEnterEvent event) {
        ItemStack testItem;
        if (!event.getBlocks().matches(this.getMaterial())) {
            return;
        }
        if (!event.getBlocks().matches("station")) {
            return;
        }
        if (!event.getBlocks().getSign().getLine(2).equalsIgnoreCase("AUTOSTART")) {
            return;
        }
        if (!event.getBlocks().getSign().getLine(3).isEmpty() && event.getEntered() instanceof Player && !ItemUtil.areItemsIdentical(testItem = ItemSyntax.getItem(event.getBlocks().getSign().getLine(3)), ((Player)event.getEntered()).getItemInHand())) {
            return;
        }
        switch (CartStation.isActive(event.getBlocks())) {
            case ON: {
                CartStation.launch(event.getMinecart(), event.getBlocks().sign);
                break;
            }
            case OFF: 
            case NA: {
                CartUtil.stop(event.getMinecart());
                Location l = event.getBlocks().rail.getLocation().add(0.5, 0.5, 0.5);
                if (event.getMinecart().getLocation().equals((Object)l)) break;
                event.getMinecart().teleport(l);
            }
        }
    }

    @Override
    public String getName() {
        return "Station";
    }

    @Override
    public String[] getApplicableSigns() {
        return new String[]{"station"};
    }

    @Override
    public void loadConfiguration(YAMLProcessor config, String path) {
        config.setComment(path + "block", "Sets the block that is the base of the station mechanic.");
        this.material = BlockSyntax.getBlock(config.getString(path + "block", BlockTypes.OBSIDIAN.getId()), true);
    }
}

