/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.minecart.blocks;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.util.CraftBookBukkitUtil;
import com.sk89q.craftbook.util.LocationUtil;
import com.sk89q.craftbook.util.RailUtil;
import com.sk89q.craftbook.util.SignUtil;
import com.sk89q.craftbook.util.exceptions.InvalidMechanismException;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.MultipleFacing;

public class CartMechanismBlocks {
    public final Block rail;
    public final Block base;
    public final Block sign;
    public Block from;

    private CartMechanismBlocks(Block rail, Block base, Block sign) {
        this.rail = rail;
        this.base = base;
        this.sign = sign;
    }

    public static CartMechanismBlocks find(Block unknown) throws InvalidMechanismException {
        Material ti = unknown.getType();
        if (SignUtil.isSign(unknown)) {
            return CartMechanismBlocks.findBySign(unknown);
        }
        if (RailUtil.isTrack(ti)) {
            return CartMechanismBlocks.findByRail(unknown);
        }
        return CartMechanismBlocks.findByBase(unknown);
    }

    public static CartMechanismBlocks findByRail(Block rail) throws InvalidMechanismException {
        if (!RailUtil.isTrack(rail.getType())) {
            throw new InvalidMechanismException("rail argument must be a rail!");
        }
        BlockFace face = BlockFace.DOWN;
        if (rail.getType() == Material.LADDER) {
            face = ((Directional)rail.getBlockData()).getFacing().getOppositeFace();
        } else if (rail.getType() == Material.VINE) {
            MultipleFacing vine = (MultipleFacing)rail.getBlockData();
            for (BlockFace test : LocationUtil.getDirectFaces()) {
                if (!vine.hasFace(test.getOppositeFace())) continue;
                face = test;
                break;
            }
        }
        if (SignUtil.isSign(rail.getRelative(face, 2))) {
            return new CartMechanismBlocks(rail, rail.getRelative(face, 1), rail.getRelative(face, 2));
        }
        if (SignUtil.isSign(rail.getRelative(face, 3))) {
            return new CartMechanismBlocks(rail, rail.getRelative(face, 1), rail.getRelative(face, 3));
        }
        if (SignUtil.isSign(rail.getRelative(face, 1).getRelative(BlockFace.EAST, 1))) {
            return new CartMechanismBlocks(rail, rail.getRelative(face, 1), rail.getRelative(face, 1).getRelative(BlockFace.EAST, 1));
        }
        if (SignUtil.isSign(rail.getRelative(face, 1).getRelative(BlockFace.WEST, 1))) {
            return new CartMechanismBlocks(rail, rail.getRelative(face, 1), rail.getRelative(face, 1).getRelative(BlockFace.WEST, 1));
        }
        if (SignUtil.isSign(rail.getRelative(face, 1).getRelative(BlockFace.NORTH, 1))) {
            return new CartMechanismBlocks(rail, rail.getRelative(face, 1), rail.getRelative(face, 1).getRelative(BlockFace.NORTH, 1));
        }
        if (SignUtil.isSign(rail.getRelative(face, 1).getRelative(BlockFace.SOUTH, 1))) {
            return new CartMechanismBlocks(rail, rail.getRelative(face, 1), rail.getRelative(face, 1).getRelative(BlockFace.SOUTH, 1));
        }
        return new CartMechanismBlocks(rail, rail.getRelative(face, 1), null);
    }

    private static CartMechanismBlocks findByBase(Block base) throws InvalidMechanismException {
        if (!RailUtil.isTrack(base.getRelative(BlockFace.UP, 1).getType())) {
            throw new InvalidMechanismException("could not find rails.");
        }
        if (SignUtil.isSign(base.getRelative(BlockFace.DOWN, 1))) {
            return new CartMechanismBlocks(base.getRelative(BlockFace.UP, 1), base, base.getRelative(BlockFace.DOWN, 1));
        }
        if (SignUtil.isSign(base.getRelative(BlockFace.DOWN, 2))) {
            return new CartMechanismBlocks(base.getRelative(BlockFace.UP, 1), base, base.getRelative(BlockFace.DOWN, 2));
        }
        if (SignUtil.isSign(base.getRelative(BlockFace.EAST, 1))) {
            return new CartMechanismBlocks(base.getRelative(BlockFace.UP, 1), base, base.getRelative(BlockFace.EAST, 1));
        }
        if (SignUtil.isSign(base.getRelative(BlockFace.WEST, 1))) {
            return new CartMechanismBlocks(base.getRelative(BlockFace.UP, 1), base, base.getRelative(BlockFace.WEST, 1));
        }
        if (SignUtil.isSign(base.getRelative(BlockFace.NORTH, 1))) {
            return new CartMechanismBlocks(base.getRelative(BlockFace.UP, 1), base, base.getRelative(BlockFace.NORTH, 1));
        }
        if (SignUtil.isSign(base.getRelative(BlockFace.SOUTH, 1))) {
            return new CartMechanismBlocks(base.getRelative(BlockFace.UP, 1), base, base.getRelative(BlockFace.SOUTH, 1));
        }
        return new CartMechanismBlocks(base.getRelative(BlockFace.UP, 1), base, null);
    }

    private static CartMechanismBlocks findBySign(Block sign) throws InvalidMechanismException {
        if (!SignUtil.isSign(sign)) {
            throw new InvalidMechanismException("sign argument must be a sign!");
        }
        if (RailUtil.isTrack(sign.getRelative(BlockFace.UP, 2).getType())) {
            return new CartMechanismBlocks(sign.getRelative(BlockFace.UP, 2), sign.getRelative(BlockFace.UP, 1), sign);
        }
        if (RailUtil.isTrack(sign.getRelative(BlockFace.UP, 3).getType())) {
            return new CartMechanismBlocks(sign.getRelative(BlockFace.UP, 3), sign.getRelative(BlockFace.UP, 2), sign);
        }
        if (RailUtil.isTrack(sign.getRelative(SignUtil.getBack(sign), 1).getRelative(BlockFace.UP, 1).getType())) {
            return new CartMechanismBlocks(sign.getRelative(SignUtil.getBack(sign), 1).getRelative(BlockFace.UP, 1), sign.getRelative(SignUtil.getBack(sign), 1), sign);
        }
        throw new InvalidMechanismException("could not find rails.");
    }

    public void setFromBlock(Block block) {
        this.from = block;
    }

    public boolean matches(String mechname) {
        return this.hasSign() && this.getSign().getLine(1).equalsIgnoreCase("[" + mechname + "]");
    }

    public boolean matches(BlockStateHolder mat) {
        return mat.equalsFuzzy((BlockStateHolder)BukkitAdapter.adapt((BlockData)this.base.getBlockData()));
    }

    public ChangedSign getSign() {
        return !this.hasSign() ? null : CraftBookBukkitUtil.toChangedSign(this.sign);
    }

    boolean hasSign() {
        return this.sign != null && SignUtil.isSign(this.sign);
    }

    boolean hasRail() {
        return this.rail != null;
    }

    boolean hasBase() {
        return this.base != null;
    }
}

