/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.minecart.blocks;

import com.sk89q.craftbook.bukkit.util.CraftBookBukkitUtil;
import com.sk89q.craftbook.mechanics.minecart.blocks.CartBlockMechanism;
import com.sk89q.craftbook.mechanics.minecart.events.CartBlockImpactEvent;
import com.sk89q.craftbook.util.BlockSyntax;
import com.sk89q.craftbook.util.RedstoneUtil;
import com.sk89q.craftbook.util.SignUtil;
import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.List;
import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;

public class CartEjector
extends CartBlockMechanism {
    @EventHandler
    public void onVehicleImpact(CartBlockImpactEvent event) {
        if (!event.getBlocks().matches(this.getMaterial())) {
            return;
        }
        if (event.getMinecart().isEmpty()) {
            return;
        }
        if (RedstoneUtil.Power.OFF == CartEjector.isActive(event.getBlocks())) {
            return;
        }
        Block ejectTarget = !event.getBlocks().hasSign() ? event.getBlocks().rail : (!event.getBlocks().matches("eject") ? event.getBlocks().rail : event.getBlocks().rail.getRelative(SignUtil.getFront(event.getBlocks().sign)));
        List passengers = event.getMinecart().getPassengers();
        event.getMinecart().eject();
        passengers.forEach(ent -> ent.teleport(CraftBookBukkitUtil.center(ejectTarget.getLocation())));
    }

    @Override
    public String getName() {
        return "Ejector";
    }

    @Override
    public String[] getApplicableSigns() {
        return new String[]{"Eject"};
    }

    @Override
    public void loadConfiguration(YAMLProcessor config, String path) {
        config.setComment(path + "block", "Sets the block that is the base of the ejector mechanic.");
        this.material = BlockSyntax.getBlock(config.getString(path + "block", BlockTypes.IRON_BLOCK.getId()), true);
    }
}

