/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.minecart.blocks;

import com.sk89q.craftbook.bukkit.util.CraftBookBukkitUtil;
import com.sk89q.craftbook.mechanics.minecart.blocks.CartBlockMechanism;
import com.sk89q.craftbook.mechanics.minecart.blocks.CartMechanismBlocks;
import com.sk89q.craftbook.mechanics.minecart.events.CartBlockImpactEvent;
import com.sk89q.craftbook.mechanics.minecart.events.CartBlockRedstoneEvent;
import com.sk89q.craftbook.util.BlockSyntax;
import com.sk89q.craftbook.util.EntityUtil;
import com.sk89q.craftbook.util.RailUtil;
import com.sk89q.craftbook.util.RedstoneUtil;
import com.sk89q.craftbook.util.SignUtil;
import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.Locale;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Chest;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.minecart.ExplosiveMinecart;
import org.bukkit.entity.minecart.HopperMinecart;
import org.bukkit.entity.minecart.PoweredMinecart;
import org.bukkit.entity.minecart.StorageMinecart;
import org.bukkit.event.EventHandler;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class CartDispenser
extends CartBlockMechanism {
    private boolean minecartDispenserLegacy;
    private boolean minecartDispenserAntiSpam;
    private boolean minecartDispenserPropel;

    @EventHandler
    public void onCartImpact(CartBlockImpactEvent event) {
        this.performMechanic(event.getMinecart(), event.getBlocks());
    }

    @EventHandler
    public void onRedstoneImpact(CartBlockRedstoneEvent event) {
        this.performMechanic(event.getMinecart(), event.getBlocks());
    }

    public void performMechanic(Minecart cart, CartMechanismBlocks blocks) {
        if (!blocks.matches(this.getMaterial())) {
            return;
        }
        if (!blocks.matches("dispenser")) {
            return;
        }
        RedstoneUtil.Power pow = CartDispenser.isActive(blocks);
        boolean inf = "inf".equalsIgnoreCase(blocks.getSign().getLine(2));
        if (inf) {
            CartType type = CartType.fromString(blocks.getSign().getLine(0));
            if (cart == null) {
                switch (pow) {
                    case ON: {
                        if (!blocks.getSign().getLine(3).toLowerCase(Locale.ENGLISH).contains("collect")) {
                            this.dispense(blocks, null, type);
                        }
                        return;
                    }
                }
            } else {
                switch (pow) {
                    case ON: {
                        return;
                    }
                    case OFF: 
                    case NA: {
                        if (blocks.getSign().getLine(3).toLowerCase(Locale.ENGLISH).contains("dispense")) break;
                        CartDispenser.collect(cart, null);
                    }
                }
            }
        } else {
            for (Chest c : RailUtil.getNearbyChests(blocks.base)) {
                Inventory inv = c.getInventory();
                CartType type = CartType.fromString(blocks.getSign().getLine(0));
                if (cart == null) {
                    switch (pow) {
                        case ON: {
                            if (!blocks.getSign().getLine(3).toLowerCase(Locale.ENGLISH).contains("collect")) {
                                this.dispense(blocks, inv, type);
                            }
                            return;
                        }
                    }
                    continue;
                }
                switch (pow) {
                    case ON: {
                        return;
                    }
                    case OFF: 
                    case NA: {
                        if (!blocks.getSign().getLine(3).toLowerCase(Locale.ENGLISH).contains("dispense")) {
                            CartDispenser.collect(cart, inv);
                        }
                        return;
                    }
                }
            }
        }
    }

    private static void collect(Minecart cart, Inventory inv) {
        if (cart == null || cart.isDead()) {
            return;
        }
        cart.eject();
        cart.setDamage(9000.0);
        cart.remove();
        if (inv != null) {
            Material cartType = Material.MINECART;
            if (cart instanceof StorageMinecart) {
                cartType = Material.CHEST_MINECART;
            } else if (cart instanceof PoweredMinecart) {
                cartType = Material.FURNACE_MINECART;
            } else if (cart instanceof ExplosiveMinecart) {
                cartType = Material.TNT_MINECART;
            } else if (cart instanceof HopperMinecart) {
                cartType = Material.HOPPER_MINECART;
            }
            inv.addItem(new ItemStack[]{new ItemStack(cartType, 1)});
        }
    }

    private void dispense(CartMechanismBlocks blocks, Inventory inv, CartType type) {
        Location location = CraftBookBukkitUtil.center(blocks.rail.getLocation());
        if (this.minecartDispenserLegacy) {
            BlockFace direction = SignUtil.getFront(blocks.sign).getOppositeFace();
            location = blocks.rail.getRelative(direction).getLocation();
        }
        if (this.minecartDispenserAntiSpam && EntityUtil.isEntityOfTypeInBlock(location.getBlock(), EntityType.MINECART)) {
            return;
        }
        if (inv != null) {
            if (type.equals((Object)CartType.Minecart)) {
                if (!inv.contains(Material.MINECART)) {
                    return;
                }
                inv.removeItem(new ItemStack[]{new ItemStack(Material.MINECART, 1)});
            } else if (type.equals((Object)CartType.StorageMinecart)) {
                if (!inv.contains(Material.CHEST_MINECART)) {
                    return;
                }
                inv.removeItem(new ItemStack[]{new ItemStack(Material.CHEST_MINECART, 1)});
            } else if (type.equals((Object)CartType.PoweredMinecart)) {
                if (!inv.contains(Material.FURNACE_MINECART)) {
                    return;
                }
                inv.removeItem(new ItemStack[]{new ItemStack(Material.FURNACE_MINECART, 1)});
            } else if (type.equals((Object)CartType.TNTMinecart)) {
                if (!inv.contains(Material.TNT_MINECART)) {
                    return;
                }
                inv.removeItem(new ItemStack[]{new ItemStack(Material.TNT_MINECART, 1)});
            } else if (type.equals((Object)CartType.HopperMinecart)) {
                if (!inv.contains(Material.HOPPER_MINECART)) {
                    return;
                }
                inv.removeItem(new ItemStack[]{new ItemStack(Material.HOPPER_MINECART, 1)});
            }
        }
        Minecart cart = (Minecart)blocks.rail.getWorld().spawn(location, type.toClass());
        if (this.minecartDispenserPropel) {
            BlockFace dir = SignUtil.getBack(blocks.sign);
            Vector vel = new Vector(dir.getModX(), dir.getModY(), dir.getModZ());
            cart.setVelocity(vel.normalize());
        }
    }

    @Override
    public String getName() {
        return "Dispenser";
    }

    @Override
    public String[] getApplicableSigns() {
        return new String[]{"Dispenser"};
    }

    @Override
    public void loadConfiguration(YAMLProcessor config, String path) {
        config.setComment(path + "block", "Sets the block that is the base of the dispenser mechanic.");
        this.material = BlockSyntax.getBlock(config.getString(path + "block", BlockTypes.EMERALD_ORE.getId()), true);
        config.setComment(path + "spawn-infront", "Sets whether the minecarts should spawn infront of the mechanic instead of directly above.");
        this.minecartDispenserLegacy = config.getBoolean(path + "spawn-infront", false);
        config.setComment(path + "check-for-carts", "Sets whether or not the mechanic checks for existing carts before spawning a new one.");
        this.minecartDispenserAntiSpam = config.getBoolean(path + "check-for-carts", true);
        config.setComment(path + "propel-cart", "Sets whether or not the dispenser propels carts that it spawns.");
        this.minecartDispenserPropel = config.getBoolean(path + "propel-cart", false);
    }

    private static enum CartType {
        Minecart("Minecart", Minecart.class),
        StorageMinecart("Storage", StorageMinecart.class),
        PoweredMinecart("Powered", PoweredMinecart.class),
        TNTMinecart("TNT", ExplosiveMinecart.class),
        HopperMinecart("Hopper", HopperMinecart.class);

        private final Class<? extends Minecart> cl;
        private final String name;

        private CartType(String name, Class<? extends Minecart> cl) {
            this.name = name;
            this.cl = cl;
        }

        public static CartType fromString(String s) {
            for (CartType ct : CartType.values()) {
                if (ct == null || !ct.name.equalsIgnoreCase(s)) continue;
                return ct;
            }
            return Minecart;
        }

        public Class<? extends Minecart> toClass() {
            return this.cl;
        }
    }
}

