/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.minecart.blocks;

import com.sk89q.craftbook.mechanics.minecart.blocks.CartBlockMechanism;
import com.sk89q.craftbook.mechanics.minecart.events.CartBlockImpactEvent;
import com.sk89q.craftbook.util.BlockSyntax;
import com.sk89q.craftbook.util.RedstoneUtil;
import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockTypes;
import org.bukkit.event.EventHandler;
import org.bukkit.util.Vector;

public class CartBooster
extends CartBlockMechanism {
    private BlockStateHolder minecartSpeedModMaxBoostBlock;
    private BlockStateHolder minecartSpeedMod25xBoostBlock;
    private BlockStateHolder minecartSpeedMod50xSlowBlock;
    private BlockStateHolder minecartSpeedMod20xSlowBlock;

    @EventHandler
    public void onVehicleImpact(CartBlockImpactEvent event) {
        if (event.isMinor()) {
            return;
        }
        if (RedstoneUtil.Power.OFF == CartBooster.isActive(event.getBlocks())) {
            return;
        }
        Vector newVelocity = event.getVehicle().getVelocity();
        if (event.getBlocks().matches(this.minecartSpeedModMaxBoostBlock)) {
            newVelocity.normalize().multiply(event.getMinecart().getMaxSpeed());
        } else if (event.getBlocks().matches(this.minecartSpeedMod25xBoostBlock)) {
            newVelocity.multiply(1.25);
        } else if (event.getBlocks().matches(this.minecartSpeedMod20xSlowBlock)) {
            newVelocity.multiply(0.8);
        } else if (event.getBlocks().matches(this.minecartSpeedMod50xSlowBlock)) {
            newVelocity.multiply(0.5);
        } else {
            return;
        }
        event.getVehicle().setVelocity(newVelocity);
    }

    @Override
    public String getName() {
        return "Booster";
    }

    @Override
    public String[] getApplicableSigns() {
        return null;
    }

    @Override
    public void loadConfiguration(YAMLProcessor config, String path) {
        config.setComment(path + "max-boost-block", "Sets the block that is the base of the max boost block.");
        this.minecartSpeedModMaxBoostBlock = BlockSyntax.getBlock(config.getString(path + "max-boost-block", BlockTypes.GOLD_BLOCK.getId()), true);
        config.setComment(path + "25x-boost-block", "Sets the block that is the base of the 25x boost block.");
        this.minecartSpeedMod25xBoostBlock = BlockSyntax.getBlock(config.getString(path + "25x-boost-block", BlockTypes.GOLD_ORE.getId()), true);
        config.setComment(path + "50x-slow-block", "Sets the block that is the base of the 50x slower block.");
        this.minecartSpeedMod50xSlowBlock = BlockSyntax.getBlock(config.getString(path + "50x-slow-block", BlockTypes.SOUL_SAND.getId()), true);
        config.setComment(path + "20x-slow-block", "Sets the block that is the base of the 20x slower block.");
        this.minecartSpeedMod20xSlowBlock = BlockSyntax.getBlock(config.getString(path + "20x-slow-block", BlockTypes.GRAVEL.getId()), true);
    }
}

