/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.minecart.blocks;

import com.sk89q.craftbook.AbstractCraftBookMechanic;
import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.CraftBookPlayer;
import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import com.sk89q.craftbook.bukkit.util.CraftBookBukkitUtil;
import com.sk89q.craftbook.mechanics.minecart.blocks.CartMechanismBlocks;
import com.sk89q.craftbook.mechanics.minecart.blocks.CartMessenger;
import com.sk89q.craftbook.util.EntityUtil;
import com.sk89q.craftbook.util.EventUtil;
import com.sk89q.craftbook.util.RedstoneUtil;
import com.sk89q.worldedit.util.auth.AuthorizationException;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import java.util.Locale;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Minecart;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.SignChangeEvent;

public abstract class CartBlockMechanism
extends AbstractCraftBookMechanic {
    protected BlockStateHolder material;
    public static final BlockFace[] powerSupplyOptions = new BlockFace[]{BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST};

    public BlockStateHolder getMaterial() {
        return this.material;
    }

    public static RedstoneUtil.Power isActive(CartMechanismBlocks blocks) {
        boolean isWired = false;
        if (blocks.hasSign()) {
            switch (CartBlockMechanism.isActive(blocks.sign)) {
                case ON: {
                    return RedstoneUtil.Power.ON;
                }
                case NA: {
                    break;
                }
                case OFF: {
                    isWired = true;
                }
            }
        }
        if (blocks.hasBase()) {
            switch (CartBlockMechanism.isActive(blocks.base)) {
                case ON: {
                    return RedstoneUtil.Power.ON;
                }
                case NA: {
                    break;
                }
                case OFF: {
                    isWired = true;
                }
            }
        }
        if (blocks.hasRail()) {
            switch (CartBlockMechanism.isActive(blocks.rail)) {
                case ON: {
                    return RedstoneUtil.Power.ON;
                }
                case NA: {
                    break;
                }
                case OFF: {
                    isWired = true;
                }
            }
        }
        return isWired ? RedstoneUtil.Power.OFF : RedstoneUtil.Power.NA;
    }

    private static RedstoneUtil.Power isActive(Block block) {
        boolean isWired = false;
        block5: for (BlockFace face : powerSupplyOptions) {
            RedstoneUtil.Power p = RedstoneUtil.isPowered(block, face);
            switch (p) {
                case ON: {
                    return RedstoneUtil.Power.ON;
                }
                case NA: {
                    continue block5;
                }
                case OFF: {
                    isWired = true;
                }
            }
        }
        return isWired ? RedstoneUtil.Power.OFF : RedstoneUtil.Power.NA;
    }

    public static Minecart getCart(Block rail) {
        for (Entity ent : rail.getChunk().getEntities()) {
            if (!(ent instanceof Minecart) || !EntityUtil.isEntityInBlock(ent, rail)) continue;
            return (Minecart)ent;
        }
        return null;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onSignChange(SignChangeEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        Block block = event.getBlock();
        String[] lines = event.getLines();
        CraftBookPlayer player = CraftBookPlugin.inst().wrapPlayer(event.getPlayer());
        try {
            if (this.getApplicableSigns() == null || this.getApplicableSigns().length == 0) {
                return;
            }
            boolean found = false;
            String lineFound = null;
            int lineNum = 1;
            for (String sign : this.getApplicableSigns()) {
                if (lines[1].equalsIgnoreCase('[' + sign + ']')) {
                    found = true;
                    lineFound = sign;
                    lineNum = 1;
                    break;
                }
                if (!(this instanceof CartMessenger) || !lines[0].equalsIgnoreCase('[' + sign + ']')) continue;
                found = true;
                lineFound = sign;
                lineNum = 0;
                break;
            }
            if (!found) {
                return;
            }
            if (!this.verify(CraftBookBukkitUtil.toChangedSign(event.getBlock(), lines, player), player)) {
                block.breakNaturally();
                event.setCancelled(true);
                return;
            }
            player.checkPermission("craftbook.vehicles." + this.getName().toLowerCase(Locale.ENGLISH));
            event.setLine(lineNum, '[' + lineFound + ']');
            player.print(this.getName() + " Created!");
        }
        catch (AuthorizationException e) {
            player.printError("vehicles.create-permission");
            block.breakNaturally();
            event.setCancelled(true);
        }
    }

    public abstract String getName();

    public abstract String[] getApplicableSigns();

    public boolean verify(ChangedSign sign, CraftBookPlayer player) {
        return true;
    }
}

