/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.minecart;

import com.sk89q.craftbook.AbstractCraftBookMechanic;
import com.sk89q.craftbook.CraftBookPlayer;
import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import com.sk89q.craftbook.util.BlockUtil;
import com.sk89q.craftbook.util.CartUtil;
import com.sk89q.craftbook.util.EventUtil;
import com.sk89q.craftbook.util.RailUtil;
import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.util.HandSide;
import com.sk89q.worldedit.world.item.ItemType;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Vehicle;
import org.bukkit.entity.minecart.RideableMinecart;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.plugin.Plugin;

public class TemporaryCart
extends AbstractCraftBookMechanic {
    private Set<RideableMinecart> minecarts = new HashSet<RideableMinecart>();

    public Set<RideableMinecart> getMinecarts() {
        return this.minecarts;
    }

    @Override
    public void disable() {
        for (RideableMinecart minecart : this.minecarts) {
            minecart.remove();
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK || event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        if (!RailUtil.isTrack(event.getClickedBlock().getType())) {
            return;
        }
        CraftBookPlayer player = CraftBookPlugin.inst().wrapPlayer(event.getPlayer());
        if (player.isHoldingBlock() || player.isInsideVehicle() || player.isSneaking()) {
            return;
        }
        if (CartUtil.isMinecart(BukkitAdapter.adapt((ItemType)player.getItemInHand(HandSide.MAIN_HAND).getType()))) {
            return;
        }
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (!player.hasPermission("craftbook.vehicles.temporary-cart.use")) {
            if (CraftBookPlugin.inst().getConfiguration().showPermissionMessages) {
                player.printError("mech.create-permission");
            }
            return;
        }
        RideableMinecart cart = (RideableMinecart)event.getClickedBlock().getWorld().spawn(BlockUtil.getBlockCentre(event.getClickedBlock()), RideableMinecart.class);
        this.minecarts.add(cart);
        cart.addPassenger((Entity)event.getPlayer());
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerDismount(VehicleExitEvent event) {
        if (!(event.getVehicle() instanceof RideableMinecart)) {
            return;
        }
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (!this.minecarts.contains(event.getVehicle())) {
            return;
        }
        Bukkit.getScheduler().runTaskLater((Plugin)CraftBookPlugin.inst(), () -> ((Vehicle)event.getVehicle()).remove(), 2L);
    }

    @Override
    public void loadConfiguration(YAMLProcessor config, String path) {
    }
}

