/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.minecart;

import com.sk89q.craftbook.AbstractCraftBookMechanic;
import com.sk89q.craftbook.util.EventUtil;
import com.sk89q.util.yaml.YAMLProcessor;
import org.bukkit.entity.Minecart;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.vehicle.VehicleCreateEvent;
import org.bukkit.util.Vector;

public class SpeedModifiers
extends AbstractCraftBookMechanic {
    private double maxSpeed;
    private double offRail;

    @EventHandler(priority=EventPriority.HIGH)
    public void onVehicleCreate(VehicleCreateEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (!(event.getVehicle() instanceof Minecart)) {
            return;
        }
        if (this.offRail > 0.0) {
            ((Minecart)event.getVehicle()).setDerailedVelocityMod(new Vector(this.offRail, this.offRail, this.offRail));
        }
        if (this.maxSpeed != 1.0) {
            ((Minecart)event.getVehicle()).setMaxSpeed(((Minecart)event.getVehicle()).getMaxSpeed() * this.maxSpeed);
        }
    }

    @Override
    public void loadConfiguration(YAMLProcessor config, String path) {
        config.setComment(path + "max-speed", "Sets the max speed modifier of carts. Normal max speed speed is 0.4D");
        this.maxSpeed = config.getDouble(path + "max-speed", 1.0);
        config.setComment(path + "off-rail-speed", "Sets the off-rail speed modifier of carts. 0 is none.");
        this.offRail = config.getDouble(path + "off-rail-speed", 0.0);
    }
}

