/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.minecart;

import com.sk89q.craftbook.AbstractCraftBookMechanic;
import com.sk89q.craftbook.util.EventUtil;
import com.sk89q.util.yaml.YAMLProcessor;
import org.bukkit.entity.Minecart;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.vehicle.VehicleEntityCollisionEvent;

public class NoCollide
extends AbstractCraftBookMechanic {
    private boolean empty;
    private boolean full;

    @EventHandler(priority=EventPriority.HIGH)
    public void onCartCollision(VehicleEntityCollisionEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (event.getVehicle() instanceof Minecart) {
            if (event.getVehicle().isEmpty() && !this.empty) {
                return;
            }
            if (!event.getVehicle().isEmpty() && !this.full) {
                return;
            }
            event.setCollisionCancelled(true);
        }
    }

    @Override
    public void loadConfiguration(YAMLProcessor config, String path) {
        config.setComment(path + "empty-carts", "Enable No Collide for empty carts.");
        this.empty = config.getBoolean(path + "empty-carts", true);
        config.setComment(path + "full-carts", "Enable No Collide for occupied carts.");
        this.full = config.getBoolean(path + "full-carts", false);
    }
}

